/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.supports.context;

import io.grpc.ForwardingServerCallListener;
import io.grpc.Metadata;
import io.grpc.ServerCall;
import io.grpc.ServerCallHandler;
import io.grpc.ServerInterceptor;
import io.quarkus.arc.Arc;
import io.quarkus.arc.ArcContainer;
import io.quarkus.arc.ManagedContext;
import io.quarkus.vertx.http.runtime.CurrentVertxRequest;
import io.vertx.core.Context;
import io.vertx.core.Vertx;
import io.vertx.ext.web.RoutingContext;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.inject.spi.Prioritized;
import java.lang.annotation.Annotation;

@ApplicationScoped
public class RoutingContextGrpcInterceptor
implements ServerInterceptor,
Prioritized {
    public <ReqT, RespT> ServerCall.Listener<ReqT> interceptCall(ServerCall<ReqT, RespT> call, Metadata headers, ServerCallHandler<ReqT, RespT> next) {
        Context currentContext = Vertx.currentContext();
        final RoutingContext routingContext = (RoutingContext)currentContext.getLocal((Object)RoutingContext.class.getName());
        return new ForwardingServerCallListener.SimpleForwardingServerCallListener<ReqT>(next.startCall(call, headers)){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            private void invoke(Runnable runnable) {
                ArcContainer container = Arc.container();
                ManagedContext reqContext = container.requestContext();
                CurrentVertxRequest cvr = null;
                if (reqContext.isActive()) {
                    cvr = (CurrentVertxRequest)container.select(CurrentVertxRequest.class, new Annotation[0]).get();
                    cvr.setCurrent(routingContext);
                }
                try {
                    runnable.run();
                }
                finally {
                    if (cvr != null && reqContext.isActive()) {
                        cvr.setCurrent(null);
                    }
                }
            }

            public void onMessage(ReqT message) {
                this.invoke(() -> super.onMessage(message));
            }

            public void onHalfClose() {
                this.invoke(() -> super.onHalfClose());
            }

            public void onCancel() {
                this.invoke(() -> super.onCancel());
            }

            public void onComplete() {
                this.invoke(() -> super.onComplete());
            }

            public void onReady() {
                this.invoke(() -> super.onReady());
            }
        };
    }

    public int getPriority() {
        return 2147483592;
    }
}

