/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime;

import grpc.health.v1.HealthOuterClass;
import io.grpc.BindableService;
import io.grpc.Server;
import io.grpc.ServerBuilder;
import io.grpc.ServerInterceptor;
import io.grpc.ServerInterceptors;
import io.grpc.ServerMethodDefinition;
import io.grpc.ServerServiceDefinition;
import io.grpc.netty.NettyServerBuilder;
import io.quarkus.arc.Arc;
import io.quarkus.arc.InstanceHandle;
import io.quarkus.arc.Subclass;
import io.quarkus.arc.runtime.BeanContainer;
import io.quarkus.grpc.api.ServerBuilderCustomizer;
import io.quarkus.grpc.auth.GrpcSecurityInterceptor;
import io.quarkus.grpc.reflection.service.ReflectionServiceV1;
import io.quarkus.grpc.reflection.service.ReflectionServiceV1alpha;
import io.quarkus.grpc.runtime.GrpcContainer;
import io.quarkus.grpc.runtime.GrpcSslUtils;
import io.quarkus.grpc.runtime.GrpcTestPortUtils;
import io.quarkus.grpc.runtime.Interceptors;
import io.quarkus.grpc.runtime.ServerInterceptorStorage;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.devmode.DevModeInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcHotReplacementInterceptor;
import io.quarkus.grpc.runtime.devmode.GrpcServerReloader;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import io.quarkus.grpc.runtime.supports.CompressionInterceptor;
import io.quarkus.grpc.runtime.supports.blocking.BlockingServerInterceptor;
import io.quarkus.grpc.spi.GrpcBuilderProvider;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.QuarkusBindException;
import io.quarkus.runtime.RuntimeValue;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.Recorder;
import io.quarkus.vertx.http.runtime.PortSystemProperties;
import io.quarkus.vertx.http.runtime.QuarkusErrorHandler;
import io.quarkus.vertx.http.runtime.security.HttpAuthenticator;
import io.quarkus.virtual.threads.VirtualThreadsRecorder;
import io.vertx.core.AbstractVerticle;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.DeploymentOptions;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.http.HttpServerRequest;
import io.vertx.core.http.HttpVersion;
import io.vertx.ext.web.Route;
import io.vertx.ext.web.Router;
import io.vertx.ext.web.RoutingContext;
import io.vertx.grpc.VertxServer;
import io.vertx.grpc.VertxServerBuilder;
import io.vertx.grpc.server.GrpcServer;
import io.vertx.grpc.server.GrpcServerOptions;
import io.vertx.grpc.server.GrpcServiceBridge;
import jakarta.enterprise.inject.Any;
import jakarta.enterprise.inject.Instance;
import jakarta.enterprise.util.TypeLiteral;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.lang.annotation.Annotation;
import java.net.BindException;
import java.time.Duration;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Pattern;
import org.jboss.logging.Logger;

@Recorder
public class GrpcServerRecorder {
    private static final Logger LOGGER = Logger.getLogger((String)GrpcServerRecorder.class.getName());
    private static final AtomicInteger grpcVerticleCount = new AtomicInteger(0);
    private static volatile DevModeWrapper devModeWrapper;
    private static volatile List<GrpcServiceDefinition> services;
    private static final Pattern GRPC_CONTENT_TYPE;
    private final RuntimeValue<GrpcConfiguration> runtimeConfig;

    public GrpcServerRecorder(RuntimeValue<GrpcConfiguration> runtimeConfig) {
        this.runtimeConfig = runtimeConfig;
    }

    public static List<GrpcServiceDefinition> getServices() {
        return services;
    }

    public void addMainRouterErrorHandlerIfSameServer(RuntimeValue<Router> mainRouter) {
        if (!((GrpcConfiguration)this.runtimeConfig.getValue()).server().useSeparateServer()) {
            ((Router)mainRouter.getValue()).route().last().failureHandler((Handler)new Handler<RoutingContext>(){
                private final Handler<RoutingContext> errorHandler = new QuarkusErrorHandler(LaunchMode.current().isDevOrTest(), false, Optional.empty());

                public void handle(RoutingContext event) {
                    if (GrpcServerRecorder.isGrpc(event)) {
                        this.errorHandler.handle((Object)event);
                    }
                }
            });
        }
    }

    public void initializeGrpcServer(boolean hasNoBindableServiceBeans, BeanContainer beanContainer, RuntimeValue<Vertx> vertxSupplier, RuntimeValue<Router> routerSupplier, ShutdownContext shutdown, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, LaunchMode launchMode, boolean securityPresent, Map<Integer, Handler<RoutingContext>> securityHandlers) {
        if (hasNoBindableServiceBeans && LaunchMode.current() != LaunchMode.DEVELOPMENT) {
            LOGGER.error((Object)"Unable to find beans exposing the `BindableService` interface - not starting the gRPC server");
            return;
        }
        Vertx vertx = (Vertx)vertxSupplier.getValue();
        GrpcServerConfiguration configuration = ((GrpcConfiguration)this.runtimeConfig.getValue()).server();
        GrpcBuilderProvider provider = GrpcBuilderProvider.findServerBuilderProvider(configuration);
        if (configuration.useSeparateServer()) {
            if (provider == null) {
                LOGGER.warn((Object)"Using legacy gRPC support with a separate HTTP server instance. This is the current default to maintain compatibility.\nYou can switch to the new unified HTTP server by setting quarkus.grpc.server.use-separate-server=false\nThis change is recommended for new applications and will become the default in future versions.\n");
            }
            if (launchMode == LaunchMode.DEVELOPMENT) {
                if (GrpcServerReloader.getServer() != null || provider != null && provider.serverAlreadyExists()) {
                    this.devModeReload((GrpcContainer)beanContainer.beanInstance(GrpcContainer.class, new Annotation[0]), vertx, configuration, provider, blockingMethodsPerService, virtualMethodsPerService, shutdown);
                } else {
                    this.devModeStart((GrpcContainer)beanContainer.beanInstance(GrpcContainer.class, new Annotation[0]), vertx, configuration, provider, blockingMethodsPerService, virtualMethodsPerService, shutdown, launchMode);
                }
            } else {
                this.prodStart((GrpcContainer)beanContainer.beanInstance(GrpcContainer.class, new Annotation[0]), vertx, configuration, provider, blockingMethodsPerService, virtualMethodsPerService, launchMode);
            }
        } else {
            this.buildGrpcServer(vertx, configuration, routerSupplier, shutdown, blockingMethodsPerService, virtualMethodsPerService, (GrpcContainer)beanContainer.beanInstance(GrpcContainer.class, new Annotation[0]), launchMode, securityPresent, securityHandlers);
        }
    }

    private void buildGrpcServer(Vertx vertx, GrpcServerConfiguration configuration, RuntimeValue<Router> routerSupplier, ShutdownContext shutdown, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, GrpcContainer grpcContainer, LaunchMode launchMode, boolean securityPresent, Map<Integer, Handler<RoutingContext>> securityHandlers) {
        boolean reflectionServiceEnabled;
        GrpcServerOptions options = new GrpcServerOptions();
        List<ServerBuilderCustomizer> serverBuilderCustomizers = Arc.container().select(new TypeLiteral<ServerBuilderCustomizer<?>>(){}, new Annotation[]{Any.Literal.INSTANCE}).stream().sorted(Comparator.comparing(ServerBuilderCustomizer::priority)).toList();
        serverBuilderCustomizers.forEach(sbc -> sbc.customize(configuration, options));
        if (!configuration.maxInboundMessageSize().isEmpty()) {
            options.setMaxMessageSize((long)configuration.maxInboundMessageSize().getAsInt());
        }
        GrpcServer server = GrpcServer.server((Vertx)vertx, (GrpcServerOptions)options);
        List<ServerInterceptor> globalInterceptors = grpcContainer.getSortedGlobalInterceptors();
        if (launchMode == LaunchMode.DEVELOPMENT) {
            globalInterceptors.add(new DevModeInterceptor(Thread.currentThread().getContextClassLoader()));
            globalInterceptors.add(new GrpcHotReplacementInterceptor());
        }
        List<GrpcServiceDefinition> toBeRegistered = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        for (GrpcServiceDefinition service : toBeRegistered) {
            ServerServiceDefinition serviceDefinition = this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, virtualMethodsPerService, compressionInterceptor, globalInterceptors, service, launchMode == LaunchMode.DEVELOPMENT);
            LOGGER.debugf("Registered gRPC service '%s'", (Object)service.definition.getServiceDescriptor().getName());
            GrpcServiceBridge grpcServiceBridge = GrpcServiceBridge.bridge((ServerServiceDefinition)serviceDefinition);
            grpcServiceBridge.bind(server);
            definitions.add(service.definition);
        }
        boolean bl = reflectionServiceEnabled = configuration.enableReflectionService() || launchMode == LaunchMode.DEVELOPMENT;
        if (reflectionServiceEnabled) {
            LOGGER.debug((Object)"Registering gRPC reflection service");
            ReflectionServiceV1 reflectionServiceV1 = new ReflectionServiceV1(definitions);
            ReflectionServiceV1alpha reflectionServiceV1alpha = new ReflectionServiceV1alpha(definitions);
            ServerServiceDefinition serverServiceDefinition = ServerInterceptors.intercept((BindableService)reflectionServiceV1, globalInterceptors);
            GrpcServiceBridge bridge = GrpcServiceBridge.bridge((ServerServiceDefinition)serverServiceDefinition);
            bridge.bind(server);
            ServerServiceDefinition serviceDefinitionAlpha = ServerInterceptors.intercept((BindableService)reflectionServiceV1alpha, globalInterceptors);
            GrpcServiceBridge bridgeAlpha = GrpcServiceBridge.bridge((ServerServiceDefinition)serviceDefinitionAlpha);
            bridgeAlpha.bind(server);
        }
        Router router = (Router)routerSupplier.getValue();
        if (securityHandlers != null) {
            for (Map.Entry entry : securityHandlers.entrySet()) {
                final Handler handler = (Handler)entry.getValue();
                final boolean isAuthenticationHandler = (Integer)entry.getKey() == -200;
                Route route = router.route().order(((Integer)entry.getKey()).intValue()).handler((Handler)new Handler<RoutingContext>(){

                    public void handle(final RoutingContext ctx) {
                        if (!GrpcServerRecorder.isGrpc(ctx)) {
                            ctx.next();
                        } else if (isAuthenticationHandler && ctx.get(HttpAuthenticator.class.getName()) != null) {
                            ctx.next();
                        } else {
                            Context capturedVertxContext;
                            if (!Context.isOnEventLoopThread() && (capturedVertxContext = Vertx.currentContext()) != null) {
                                capturedVertxContext.runOnContext((Handler)new Handler<Void>(){

                                    public void handle(Void unused) {
                                        handler.handle((Object)ctx);
                                    }
                                });
                                return;
                            }
                            handler.handle((Object)ctx);
                        }
                    }
                });
                shutdown.addShutdownTask(() -> ((Route)route).remove());
            }
        }
        LOGGER.info((Object)"Starting new Quarkus gRPC server (using Vert.x transport)...");
        Route route = router.route().handler(ctx -> {
            if (!GrpcServerRecorder.isGrpc(ctx)) {
                ctx.next();
            } else {
                Context capturedVertxContext;
                if (securityPresent) {
                    GrpcSecurityInterceptor.propagateSecurityIdentityWithDuplicatedCtx(ctx);
                }
                if (!Context.isOnEventLoopThread() && (capturedVertxContext = Vertx.currentContext()) != null) {
                    capturedVertxContext.runOnContext((Handler)new Handler<Void>(){

                        public void handle(Void unused) {
                            GrpcServerRecorder.routingContextAware(server, ctx);
                        }
                    });
                    return;
                }
                GrpcServerRecorder.routingContextAware(server, ctx);
            }
        });
        shutdown.addShutdownTask(() -> ((Route)route).remove());
        this.initHealthStorage();
    }

    private static void routingContextAware(GrpcServer server, RoutingContext context) {
        Context currentContext = Vertx.currentContext();
        currentContext.putLocal((Object)RoutingContext.class.getName(), (Object)context);
        try {
            server.handle((Object)context.request());
        }
        finally {
            currentContext.removeLocal((Object)RoutingContext.class.getName());
        }
    }

    private static boolean isGrpc(RoutingContext rc) {
        HttpServerRequest request = rc.request();
        HttpVersion version = request.version();
        if (HttpVersion.HTTP_1_0.equals((Object)version) || HttpVersion.HTTP_1_1.equals((Object)version)) {
            LOGGER.debugf("Expecting %s, received %s - not a gRPC request", (Object)HttpVersion.HTTP_2, (Object)version);
            return false;
        }
        String header = request.getHeader("content-type");
        return header != null && GRPC_CONTENT_TYPE.matcher(header.toLowerCase(Locale.ROOT)).matches();
    }

    private void prodStart(GrpcContainer grpcContainer, Vertx vertx, GrpcServerConfiguration configuration, GrpcBuilderProvider<?> provider, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, LaunchMode launchMode) {
        CompletableFuture startResult = new CompletableFuture();
        vertx.deployVerticle(() -> new GrpcServerVerticle(configuration, grpcContainer, provider, launchMode, blockingMethodsPerService, virtualMethodsPerService), new DeploymentOptions().setInstances(configuration.instances()), result -> {
            if (result.failed()) {
                startResult.completeExceptionally(result.cause());
            } else {
                this.postStartup(configuration, provider, launchMode == LaunchMode.TEST);
                startResult.complete(null);
            }
        });
        try {
            startResult.get(1L, TimeUnit.MINUTES);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            LOGGER.error((Object)"Unable to start the gRPC server, waiting for server start interrupted");
        }
        catch (TimeoutException e) {
            LOGGER.error((Object)"Unable to start the gRPC server, still not listening after 1 minute");
        }
        catch (ExecutionException e) {
            LOGGER.error((Object)"Unable to start the gRPC server", e.getCause());
        }
    }

    private void postStartup(GrpcServerConfiguration configuration, GrpcBuilderProvider<?> provider, boolean test) {
        this.initHealthStorage();
        int port = test ? GrpcTestPortUtils.testPort(configuration) : configuration.port();
        Object msg = "Started ";
        msg = provider != null ? (String)msg + provider.serverInfo(configuration.host(), port, configuration) : (String)msg + String.format("gRPC server on %s:%d [%s]", configuration.host(), port, "TLS enabled: " + !configuration.plainText());
        LOGGER.info(msg);
    }

    private void initHealthStorage() {
        InstanceHandle storageHandle = Arc.container().instance(GrpcHealthStorage.class, new Annotation[0]);
        if (storageHandle.isAvailable()) {
            GrpcHealthStorage storage = (GrpcHealthStorage)storageHandle.get();
            storage.setStatus("", HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
            for (GrpcServiceDefinition service : services) {
                storage.setStatus(service.definition.getServiceDescriptor().getName(), HealthOuterClass.HealthCheckResponse.ServingStatus.SERVING);
            }
        }
    }

    private void devModeStart(GrpcContainer grpcContainer, Vertx vertx, GrpcServerConfiguration configuration, GrpcBuilderProvider<?> provider, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, ShutdownContext shutdown, LaunchMode launchMode) {
        Map.Entry<Integer, Server> portToServer = this.buildServer(vertx, configuration, provider, blockingMethodsPerService, virtualMethodsPerService, grpcContainer, launchMode);
        Server server = portToServer.getValue();
        if (provider == null) {
            CompletableFuture future = new CompletableFuture();
            devModeWrapper = new DevModeWrapper(Thread.currentThread().getContextClassLoader());
            VertxServer vertxServer = (VertxServer)server;
            vertxServer.start(ar -> {
                if (ar.failed()) {
                    Throwable effectiveCause = this.getEffectiveThrowable((AsyncResult<Void>)ar, configuration.host(), (Integer)portToServer.getKey());
                    if (effectiveCause instanceof QuarkusBindException) {
                        LOGGER.error((Object)"Unable to start the gRPC server");
                    } else {
                        LOGGER.error((Object)"Unable to start the gRPC server", effectiveCause);
                    }
                    future.completeExceptionally(effectiveCause);
                } else {
                    this.postStartup(configuration, provider, false);
                    future.complete(true);
                    grpcVerticleCount.incrementAndGet();
                }
            });
            try {
                future.get(1L, TimeUnit.MINUTES);
            }
            catch (TimeoutException e) {
                LOGGER.error((Object)"Failed to start grpc server in time", (Throwable)e);
            }
            catch (ExecutionException e) {
                throw new RuntimeException("grpc server start failed", e);
            }
            catch (InterruptedException e) {
                LOGGER.warn((Object)"Waiting for grpc server start interrupted", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            GrpcServerReloader.init(vertxServer);
            shutdown.addShutdownTask(GrpcServerReloader::reset);
        } else {
            try {
                provider.startServer(server);
            }
            catch (Exception e) {
                LOGGER.error((Object)"Unable to start the gRPC server", (Throwable)e);
                throw new IllegalStateException(e);
            }
            this.postStartup(configuration, provider, false);
            provider.postStartup(server, shutdown);
        }
    }

    private void applyNettySettings(GrpcServerConfiguration configuration, VertxServerBuilder builder) {
        if (configuration.netty() != null) {
            GrpcServerConfiguration.GrpcServerNettyConfig config = configuration.netty();
            NettyServerBuilder nettyServerBuilder = builder.nettyBuilder();
            config.keepAliveTime().ifPresent(duration -> nettyServerBuilder.keepAliveTime(duration.toNanos(), TimeUnit.NANOSECONDS));
            config.permitKeepAliveTime().ifPresent(duration -> nettyServerBuilder.permitKeepAliveTime(duration.toNanos(), TimeUnit.NANOSECONDS));
            config.permitKeepAliveWithoutCalls().ifPresent(arg_0 -> ((NettyServerBuilder)nettyServerBuilder).permitKeepAliveWithoutCalls(arg_0));
        }
    }

    private void applyTransportSecurityConfig(GrpcServerConfiguration configuration, ServerBuilder builder) {
        if (configuration.transportSecurity() != null) {
            File cert = configuration.transportSecurity().certificate().map(File::new).orElse(null);
            File key = configuration.transportSecurity().key().map(File::new).orElse(null);
            if (cert != null || key != null) {
                builder.useTransportSecurity(cert, key);
            }
        }
    }

    private static boolean hasNoServices(Instance<BindableService> services) {
        return services.isUnsatisfied() || services.stream().count() == 1L && ((BindableService)services.get()).bindService().getServiceDescriptor().getName().equals("grpc.health.v1.Health");
    }

    private static List<GrpcServiceDefinition> collectServiceDefinitions(Instance<BindableService> services) {
        ArrayList<GrpcServiceDefinition> definitions = new ArrayList<GrpcServiceDefinition>();
        for (BindableService service : services) {
            ServerServiceDefinition definition = service.bindService();
            definitions.add(new GrpcServiceDefinition(service, definition));
        }
        GrpcServerRecorder.services = definitions;
        return definitions;
    }

    private Throwable getEffectiveThrowable(AsyncResult<Void> ar, String host, int port) {
        Throwable effectiveCause = ar.cause();
        while (effectiveCause.getCause() != null) {
            effectiveCause = effectiveCause.getCause();
        }
        if (effectiveCause instanceof BindException) {
            BindException e = (BindException)effectiveCause;
            effectiveCause = new QuarkusBindException(host, port, e);
        }
        return effectiveCause;
    }

    private void devModeReload(GrpcContainer grpcContainer, Vertx vertx, GrpcServerConfiguration configuration, GrpcBuilderProvider<?> provider, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, ShutdownContext shutdown) {
        List<GrpcServiceDefinition> services = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        HashMap methods = new HashMap();
        for (GrpcServiceDefinition service : services) {
            definitions.add(service.definition);
        }
        List<ServerInterceptor> globalInterceptors = grpcContainer.getSortedGlobalInterceptors();
        ArrayList<ServerServiceDefinition> servicesWithInterceptors = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        for (GrpcServiceDefinition service : services) {
            servicesWithInterceptors.add(this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, virtualMethodsPerService, compressionInterceptor, globalInterceptors, service, true));
        }
        servicesWithInterceptors.add(new ReflectionServiceV1(definitions).bindService());
        servicesWithInterceptors.add(new ReflectionServiceV1alpha(definitions).bindService());
        for (ServerServiceDefinition serviceWithInterceptors : servicesWithInterceptors) {
            for (ServerMethodDefinition method : serviceWithInterceptors.getMethods()) {
                methods.put(method.getMethodDescriptor().getFullMethodName(), method);
            }
        }
        this.initHealthStorage();
        ArrayList<ServerInterceptor> devModeInterceptors = new ArrayList<ServerInterceptor>();
        if (provider != null) {
            devModeInterceptors.add(new DevModeInterceptor(Thread.currentThread().getContextClassLoader()));
            devModeInterceptors.add(new GrpcHotReplacementInterceptor());
            provider.devModeReload(servicesWithInterceptors, methods, devModeInterceptors, shutdown);
        } else {
            devModeWrapper = new DevModeWrapper(Thread.currentThread().getContextClassLoader());
            GrpcServerReloader.reinitialize(servicesWithInterceptors, methods, devModeInterceptors);
            shutdown.addShutdownTask(GrpcServerReloader::reset);
        }
    }

    public static int getVerticleCount() {
        return grpcVerticleCount.get();
    }

    public RuntimeValue<ServerInterceptorStorage> initServerInterceptorStorage(Map<String, Set<Class<?>>> perServiceInterceptors, Set<Class<?>> globalInterceptors) {
        return new RuntimeValue((Object)new ServerInterceptorStorage(perServiceInterceptors, globalInterceptors));
    }

    private Map.Entry<Integer, Server> buildServer(Vertx vertx, GrpcServerConfiguration configuration, GrpcBuilderProvider provider, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, GrpcContainer grpcContainer, LaunchMode launchMode) {
        int port = launchMode == LaunchMode.TEST ? configuration.testPort() : configuration.port();
        AtomicBoolean usePlainText = new AtomicBoolean();
        VertxServerBuilder builder = provider != null ? provider.createServerBuilder(vertx, configuration, launchMode) : VertxServerBuilder.forAddress((Vertx)vertx, (String)configuration.host(), (int)port);
        List<ServerBuilderCustomizer> serverBuilderCustomizers = Arc.container().select(new TypeLiteral<ServerBuilderCustomizer<?>>(){}, new Annotation[]{Any.Literal.INSTANCE}).stream().sorted(Comparator.comparing(ServerBuilderCustomizer::priority)).toList();
        for (ServerBuilderCustomizer scb : serverBuilderCustomizers) {
            scb.customize(configuration, builder);
        }
        if (provider == null) {
            VertxServerBuilder vsBuilder = builder;
            vsBuilder.useSsl(options -> {
                try {
                    usePlainText.set(GrpcSslUtils.applySslOptions(configuration, options));
                }
                catch (IOException e) {
                    throw new UncheckedIOException(e);
                }
            });
            this.applyNettySettings(configuration, vsBuilder);
            if (launchMode == LaunchMode.DEVELOPMENT) {
                vsBuilder.commandDecorator(command -> vertx.executeBlocking(GrpcHotReplacementInterceptor::fire, false).onComplete(result -> devModeWrapper.run((Runnable)command)));
            }
        }
        if (configuration.maxInboundMessageSize().isPresent()) {
            builder.maxInboundMessageSize(configuration.maxInboundMessageSize().getAsInt());
        }
        if (configuration.maxInboundMetadataSize().isPresent()) {
            builder.maxInboundMetadataSize(configuration.maxInboundMetadataSize().getAsInt());
        }
        Optional<Duration> handshakeTimeout = configuration.handshakeTimeout();
        handshakeTimeout.ifPresent(arg_0 -> GrpcServerRecorder.lambda$buildServer$10((ServerBuilder)builder, arg_0));
        this.applyTransportSecurityConfig(configuration, (ServerBuilder)builder);
        boolean reflectionServiceEnabled = configuration.enableReflectionService() || launchMode == LaunchMode.DEVELOPMENT;
        List<GrpcServiceDefinition> toBeRegistered = GrpcServerRecorder.collectServiceDefinitions(grpcContainer.getServices());
        ArrayList<ServerServiceDefinition> definitions = new ArrayList<ServerServiceDefinition>();
        CompressionInterceptor compressionInterceptor = this.prepareCompressionInterceptor(configuration);
        List<ServerInterceptor> globalInterceptors = grpcContainer.getSortedGlobalInterceptors();
        for (GrpcServiceDefinition service : toBeRegistered) {
            builder.addService(this.serviceWithInterceptors(vertx, grpcContainer, blockingMethodsPerService, virtualMethodsPerService, compressionInterceptor, globalInterceptors, service, launchMode == LaunchMode.DEVELOPMENT));
            LOGGER.debugf("Registered gRPC service '%s'", (Object)service.definition.getServiceDescriptor().getName());
            definitions.add(service.definition);
        }
        if (reflectionServiceEnabled) {
            LOGGER.debug((Object)"Registering gRPC reflection service");
            builder.addService(ServerInterceptors.intercept((BindableService)new ReflectionServiceV1(definitions), globalInterceptors));
            builder.addService(ServerInterceptors.intercept((BindableService)new ReflectionServiceV1alpha(definitions), globalInterceptors));
        }
        if (LOGGER.isDebugEnabled()) {
            Object msg = "Starting ";
            msg = provider != null ? (String)msg + provider.serverInfo(configuration.host(), port, configuration) : (String)msg + String.format("gRPC server on %s:%d [TLS enabled: %s]", configuration.host(), port, !usePlainText.get());
            LOGGER.debug(msg);
        }
        return new AbstractMap.SimpleEntry<Integer, Server>(port, builder.build());
    }

    private CompressionInterceptor prepareCompressionInterceptor(GrpcServerConfiguration configuration) {
        CompressionInterceptor compressionInterceptor = null;
        if (configuration.compression().isPresent()) {
            compressionInterceptor = new CompressionInterceptor(configuration.compression().get());
        }
        return compressionInterceptor;
    }

    private ServerServiceDefinition serviceWithInterceptors(Vertx vertx, GrpcContainer grpcContainer, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService, CompressionInterceptor compressionInterceptor, List<ServerInterceptor> globalInterceptors, GrpcServiceDefinition service, boolean devMode) {
        ArrayList<Object> interceptors = new ArrayList<Object>();
        if (compressionInterceptor != null) {
            interceptors.add(compressionInterceptor);
        }
        interceptors.addAll(globalInterceptors);
        interceptors.addAll(grpcContainer.getSortedPerServiceInterceptors(service.getImplementationClassName()));
        if (!blockingMethodsPerService.isEmpty()) {
            List<String> list = blockingMethodsPerService.get(service.getImplementationClassName());
            List<String> virtuals = virtualMethodsPerService.get(service.getImplementationClassName());
            if (list != null || virtuals != null) {
                interceptors.add(new BlockingServerInterceptor(vertx, list, virtuals, VirtualThreadsRecorder.getCurrent(), devMode));
            }
        }
        interceptors.sort(Interceptors.INTERCEPTOR_COMPARATOR);
        return ServerInterceptors.intercept((ServerServiceDefinition)service.definition, interceptors);
    }

    private static /* synthetic */ void lambda$buildServer$10(ServerBuilder builder, Duration duration) {
        builder.handshakeTimeout(duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    static {
        services = Collections.emptyList();
        GRPC_CONTENT_TYPE = Pattern.compile("^application/grpc.*");
    }

    public static final class GrpcServiceDefinition {
        public final BindableService service;
        public final ServerServiceDefinition definition;

        GrpcServiceDefinition(BindableService service, ServerServiceDefinition definition) {
            this.service = service;
            this.definition = definition;
        }

        public String getImplementationClassName() {
            return GrpcServiceDefinition.getImplementationClassName(this.service);
        }

        public static String getImplementationClassName(BindableService service) {
            if (service instanceof Subclass) {
                return service.getClass().getSuperclass().getName();
            }
            return service.getClass().getName();
        }
    }

    private static class DevModeWrapper {
        private final ClassLoader classLoader;

        public DevModeWrapper(ClassLoader contextClassLoader) {
            this.classLoader = contextClassLoader;
        }

        public void run(Runnable command) {
            ClassLoader originalTccl = Thread.currentThread().getContextClassLoader();
            Thread.currentThread().setContextClassLoader(this.classLoader);
            try {
                command.run();
            }
            finally {
                Thread.currentThread().setContextClassLoader(originalTccl);
            }
        }
    }

    private class GrpcServerVerticle
    extends AbstractVerticle {
        private final GrpcServerConfiguration configuration;
        private final GrpcContainer grpcContainer;
        private final GrpcBuilderProvider provider;
        private final LaunchMode launchMode;
        private final Map<String, List<String>> blockingMethodsPerService;
        private final Map<String, List<String>> virtualMethodsPerService;
        private volatile PortSystemProperties portSystemProperties;
        private Server grpcServer;

        GrpcServerVerticle(GrpcServerConfiguration configuration, GrpcContainer grpcContainer, GrpcBuilderProvider provider, LaunchMode launchMode, Map<String, List<String>> blockingMethodsPerService, Map<String, List<String>> virtualMethodsPerService) {
            this.configuration = configuration;
            this.grpcContainer = grpcContainer;
            this.provider = provider;
            this.launchMode = launchMode;
            this.blockingMethodsPerService = blockingMethodsPerService;
            this.virtualMethodsPerService = virtualMethodsPerService;
        }

        public void start(Promise<Void> startPromise) {
            if (this.grpcContainer.getServices().isUnsatisfied()) {
                LOGGER.warn((Object)"Unable to find bean exposing the `BindableService` interface - not starting the gRPC server");
                return;
            }
            Map.Entry<Integer, Server> portToServer = GrpcServerRecorder.this.buildServer(this.getVertx(), this.configuration, this.provider, this.blockingMethodsPerService, this.virtualMethodsPerService, this.grpcContainer, this.launchMode);
            this.grpcServer = portToServer.getValue();
            if (this.grpcServer instanceof VertxServer) {
                VertxServer server = (VertxServer)this.grpcServer;
                server.start(ar -> {
                    if (ar.failed()) {
                        Throwable effectiveCause = GrpcServerRecorder.this.getEffectiveThrowable((AsyncResult<Void>)ar, this.configuration.host(), (Integer)portToServer.getKey());
                        if (effectiveCause instanceof QuarkusBindException) {
                            LOGGER.error((Object)"Unable to start the gRPC server");
                        } else {
                            LOGGER.error((Object)"Unable to start the gRPC server", effectiveCause);
                        }
                        startPromise.fail(effectiveCause);
                    } else {
                        try {
                            int actualPort = this.grpcServer.getPort();
                            if (actualPort != (Integer)portToServer.getKey()) {
                                this.portSystemProperties = new PortSystemProperties();
                                this.portSystemProperties.set("grpc.server", actualPort, this.launchMode);
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        startPromise.complete();
                        grpcVerticleCount.incrementAndGet();
                    }
                });
            } else {
                this.vertx.executeBlocking(() -> {
                    try {
                        this.grpcServer.start();
                        int actualPort = this.grpcServer.getPort();
                        if (actualPort != (Integer)portToServer.getKey()) {
                            this.portSystemProperties = new PortSystemProperties();
                            this.portSystemProperties.set("grpc.server", actualPort, this.launchMode);
                        }
                        startPromise.complete();
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)"Unable to start gRPC server", (Throwable)e);
                        startPromise.fail((Throwable)e);
                    }
                    return null;
                });
            }
        }

        public void stop(Promise<Void> stopPromise) {
            if (this.grpcServer instanceof VertxServer) {
                VertxServer server = (VertxServer)this.grpcServer;
                server.shutdown(ar -> {
                    if (ar.failed()) {
                        Throwable cause = ar.cause();
                        LOGGER.errorf(cause, "Unable to stop the gRPC server gracefully", new Object[0]);
                        stopPromise.fail(cause);
                    } else {
                        LOGGER.debug((Object)"gRPC Server stopped");
                        stopPromise.complete();
                        grpcVerticleCount.decrementAndGet();
                    }
                    if (this.portSystemProperties != null) {
                        this.portSystemProperties.restore();
                    }
                });
            } else {
                try {
                    this.grpcServer.shutdownNow().awaitTermination(10L, TimeUnit.SECONDS);
                    stopPromise.complete();
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    stopPromise.fail((Throwable)e);
                    throw new IllegalStateException(e);
                }
                catch (Exception e) {
                    LOGGER.errorf((Throwable)e, "Unable to stop the gRPC server gracefully", new Object[0]);
                    stopPromise.fail((Throwable)e);
                }
                finally {
                    if (this.portSystemProperties != null) {
                        this.portSystemProperties.restore();
                    }
                }
            }
        }
    }
}

