/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.config;

import io.quarkus.grpc.runtime.config.GrpcServerConfiguration;
import io.quarkus.grpc.runtime.config.InProcess;
import io.quarkus.runtime.annotations.ConfigDocSection;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import java.util.OptionalInt;
import java.util.OptionalLong;

@ConfigGroup
public interface GrpcClientConfiguration {
    public static final String DNS = "dns";
    public static final String XDS = "xds";

    @WithDefault(value="false")
    public boolean useQuarkusGrpcClient();

    @WithDefault(value="true")
    public boolean useVertxEventLoop();

    @ConfigDocSection(generated=true)
    public ClientXds xds();

    public InProcess inProcess();

    public StorkConfig stork();

    @WithDefault(value="9000")
    public int port();

    public OptionalInt testPort();

    @WithDefault(value="localhost")
    public String host();

    public SslClientConfig ssl();

    public Optional<String> tlsConfigurationName();

    public TlsClientConfig tls();

    @WithDefault(value="dns")
    public String nameResolver();

    public Optional<Boolean> plainText();

    public Optional<Duration> keepAliveTime();

    public OptionalInt flowControlWindow();

    public Optional<Duration> idleTimeout();

    public Optional<Duration> keepAliveTimeout();

    @WithDefault(value="false")
    public boolean keepAliveWithoutCalls();

    @WithDefault(value="5")
    public int maxHedgedAttempts();

    @WithDefault(value="5")
    public int maxRetryAttempts();

    public OptionalInt maxTraceEvents();

    public OptionalInt maxInboundMessageSize();

    public OptionalInt maxInboundMetadataSize();

    @WithDefault(value="TLS")
    public String negotiationType();

    public Optional<String> overrideAuthority();

    public OptionalLong perRpcBufferLimit();

    @WithDefault(value="false")
    public boolean retry();

    public OptionalLong retryBufferSize();

    public Optional<String> userAgent();

    @WithDefault(value="pick_first")
    public String loadBalancingPolicy();

    public Optional<String> compression();

    public Optional<Duration> deadline();

    @ConfigGroup
    public static interface StorkConfig {
        @WithDefault(value="10")
        public int threads();

        @WithDefault(value="5000")
        public long deadline();

        @WithDefault(value="3")
        public int retries();

        @WithDefault(value="60")
        public long delay();

        @WithDefault(value="120")
        public long period();
    }

    @ConfigGroup
    public static interface ClientXds
    extends GrpcServerConfiguration.Xds {
        public Optional<String> target();
    }

    @ConfigGroup
    public static interface TlsClientConfig {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="false")
        public boolean trustAll();

        public PemTrustCertConfiguration trustCertificatePem();

        public JksConfiguration trustCertificateJks();

        public PfxConfiguration trustCertificateP12();

        public PemKeyCertConfiguration keyCertificatePem();

        public JksConfiguration keyCertificateJks();

        public PfxConfiguration keyCertificateP12();

        @WithDefault(value="true")
        public boolean verifyHostname();

        @ConfigGroup
        public static interface PemKeyCertConfiguration {
            public Optional<List<String>> keys();

            public Optional<List<String>> certs();
        }

        @ConfigGroup
        public static interface PfxConfiguration {
            public Optional<String> path();

            public Optional<String> password();
        }

        @ConfigGroup
        public static interface JksConfiguration {
            public Optional<String> path();

            public Optional<String> password();
        }

        @ConfigGroup
        public static interface PemTrustCertConfiguration {
            public Optional<List<String>> certs();
        }
    }

    @ConfigGroup
    public static interface SslClientConfig {
        public Optional<Path> certificate();

        public Optional<Path> key();

        public Optional<Path> trustStore();
    }
}

