/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.health;

import grpc.health.v1.HealthOuterClass;
import io.quarkus.runtime.ShutdownEvent;
import io.smallrye.mutiny.operators.multi.processors.BroadcastProcessor;
import jakarta.enterprise.context.ApplicationScoped;
import jakarta.enterprise.event.Observes;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.Consumer;
import java.util.function.Function;

@ApplicationScoped
public class GrpcHealthStorage {
    public static final String DEFAULT_SERVICE_NAME = "";
    private final Map<String, HealthOuterClass.HealthCheckResponse.ServingStatus> statuses = new ConcurrentHashMap<String, HealthOuterClass.HealthCheckResponse.ServingStatus>();
    private final Map<String, BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus>> statusBroadcasters = new ConcurrentHashMap<String, BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus>>();

    public GrpcHealthStorage() {
        BroadcastProcessor broadcastProcessor = BroadcastProcessor.create();
        broadcastProcessor.subscribe().with((Consumer)new Consumer<HealthOuterClass.HealthCheckResponse.ServingStatus>(){

            @Override
            public void accept(HealthOuterClass.HealthCheckResponse.ServingStatus status) {
                GrpcHealthStorage.this.statuses.put(GrpcHealthStorage.DEFAULT_SERVICE_NAME, status);
            }
        });
        this.statusBroadcasters.put(DEFAULT_SERVICE_NAME, (BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus>)broadcastProcessor);
        broadcastProcessor.onNext((Object)HealthOuterClass.HealthCheckResponse.ServingStatus.NOT_SERVING);
    }

    public void setStatus(String service, HealthOuterClass.HealthCheckResponse.ServingStatus status) {
        String serviceName = service == null ? DEFAULT_SERVICE_NAME : service;
        BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> broadcastProcessor = this.statusBroadcasters.computeIfAbsent(serviceName, new Function<String, BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus>>(){

            @Override
            public BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> apply(String sn) {
                return GrpcHealthStorage.this.createBroadcastProcessor(sn);
            }
        });
        broadcastProcessor.onNext((Object)status);
    }

    public Map<String, HealthOuterClass.HealthCheckResponse.ServingStatus> getStatuses() {
        return this.statuses;
    }

    void shutdown(@Observes ShutdownEvent e) {
        for (BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> servingStatusBroadcastProcessor : this.statusBroadcasters.values()) {
            servingStatusBroadcastProcessor.onComplete();
        }
    }

    private BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> createBroadcastProcessor(final String serviceName) {
        BroadcastProcessor processor = BroadcastProcessor.create();
        processor.subscribe().with((Consumer)new Consumer<HealthOuterClass.HealthCheckResponse.ServingStatus>(){

            @Override
            public void accept(HealthOuterClass.HealthCheckResponse.ServingStatus status) {
                GrpcHealthStorage.this.statuses.put(serviceName, status);
            }
        });
        return processor;
    }

    public HealthOuterClass.HealthCheckResponse statusForService(String serviceName) {
        HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus = this.statuses.getOrDefault(serviceName, HealthOuterClass.HealthCheckResponse.ServingStatus.UNKNOWN);
        return this.resultForStatus(servingStatus);
    }

    public HealthOuterClass.HealthCheckResponse resultForStatus(HealthOuterClass.HealthCheckResponse.ServingStatus servingStatus) {
        return HealthOuterClass.HealthCheckResponse.newBuilder().setStatus(servingStatus).build();
    }

    BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> createStatusBroadcastProcessor(String serviceName) {
        return this.statusBroadcasters.computeIfAbsent(serviceName, new Function<String, BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus>>(){

            @Override
            public BroadcastProcessor<HealthOuterClass.HealthCheckResponse.ServingStatus> apply(String sn) {
                return GrpcHealthStorage.this.createBroadcastProcessor(sn);
            }
        });
    }
}

