/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc.runtime.devmode;

import grpc.health.v1.HealthOuterClass;
import io.grpc.MethodDescriptor;
import io.grpc.ServerMethodDefinition;
import io.quarkus.arc.Subclass;
import io.quarkus.arc.Unremovable;
import io.quarkus.dev.console.DevConsoleManager;
import io.quarkus.grpc.runtime.GrpcServerRecorder;
import io.quarkus.grpc.runtime.config.GrpcConfiguration;
import io.quarkus.grpc.runtime.devmode.DelegatingGrpcBeansStorage;
import io.quarkus.grpc.runtime.health.GrpcHealthStorage;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Singleton;

@Unremovable
@Singleton
public class GrpcServices
extends AbstractMap<String, ServiceDefinitionAndStatus> {
    @Inject
    GrpcConfiguration configuration;
    @Inject
    GrpcHealthStorage healthStorage;
    @Inject
    DelegatingGrpcBeansStorage delegatingBeansMapping;

    public List<ServiceDefinitionAndStatus> getInfos() {
        List<GrpcServerRecorder.GrpcServiceDefinition> services = GrpcServerRecorder.getServices();
        ArrayList<ServiceDefinitionAndStatus> infos = new ArrayList<ServiceDefinitionAndStatus>(services.size());
        for (GrpcServerRecorder.GrpcServiceDefinition service : services) {
            infos.add(new ServiceDefinitionAndStatus(service, this.healthStorage.getStatuses().getOrDefault(service.definition.getServiceDescriptor().getName(), HealthOuterClass.HealthCheckResponse.ServingStatus.UNKNOWN)));
        }
        return infos;
    }

    @Override
    public Set<Map.Entry<String, ServiceDefinitionAndStatus>> entrySet() {
        HashSet<Map.Entry<String, ServiceDefinitionAndStatus>> entries = new HashSet<Map.Entry<String, ServiceDefinitionAndStatus>>();
        for (GrpcServerRecorder.GrpcServiceDefinition definition : GrpcServerRecorder.getServices()) {
            entries.add(new ServiceDefinitionAndStatus(definition, this.healthStorage.getStatuses().getOrDefault(definition.definition.getServiceDescriptor().getName(), HealthOuterClass.HealthCheckResponse.ServingStatus.UNKNOWN)));
        }
        return entries;
    }

    public class MethodAndPrototype {
        private final ServerMethodDefinition<?, ?> definition;
        private final String prototype;

        public MethodAndPrototype(ServerMethodDefinition<?, ?> definition, String prototype) {
            this.definition = definition;
            this.prototype = prototype;
        }

        public MethodDescriptor.MethodType getType() {
            return this.definition.getMethodDescriptor().getType();
        }

        public String getBareMethodName() {
            return this.definition.getMethodDescriptor().getBareMethodName();
        }

        public String getFullMethodName() {
            return this.definition.getMethodDescriptor().getFullMethodName();
        }

        public boolean hasPrototype() {
            return this.prototype != null;
        }

        public boolean isTestable() {
            return GrpcServices.this.configuration.server.ssl.certificate.isEmpty() && GrpcServices.this.configuration.server.ssl.keyStore.isEmpty();
        }

        public String getPrototype() {
            return this.prototype;
        }
    }

    public class ServiceDefinitionAndStatus
    implements Map.Entry<String, ServiceDefinitionAndStatus> {
        public final GrpcServerRecorder.GrpcServiceDefinition definition;
        public final HealthOuterClass.HealthCheckResponse.ServingStatus status;

        public ServiceDefinitionAndStatus(GrpcServerRecorder.GrpcServiceDefinition definition, HealthOuterClass.HealthCheckResponse.ServingStatus status) {
            this.definition = definition;
            this.status = status;
        }

        public String getName() {
            return this.definition.definition.getServiceDescriptor().getName();
        }

        public String getServiceClass() {
            String grpcBeanClassName;
            String userClass;
            Class<?> instanceClass = this.definition.service.getClass();
            if (this.definition.service instanceof Subclass) {
                instanceClass = instanceClass.getSuperclass();
            }
            return (userClass = GrpcServices.this.delegatingBeansMapping.getUserClassName(grpcBeanClassName = instanceClass.getName())) != null ? userClass : grpcBeanClassName;
        }

        public Collection<ServerMethodDefinition<?, ?>> getMethods() {
            return this.definition.definition.getMethods();
        }

        public Collection<MethodAndPrototype> getMethodsWithPrototypes() {
            Map prototypes = (Map)DevConsoleManager.getGlobal((String)"io.quarkus.grpc.messagePrototypes");
            ArrayList<MethodAndPrototype> methods = new ArrayList<MethodAndPrototype>();
            for (ServerMethodDefinition<?, ?> method : this.getMethods()) {
                methods.add(new MethodAndPrototype(method, (String)prototypes.get(method.getMethodDescriptor().getFullMethodName() + "_REQUEST")));
            }
            return methods;
        }

        @Override
        public String getKey() {
            return this.getName();
        }

        @Override
        public ServiceDefinitionAndStatus getValue() {
            return this;
        }

        @Override
        public ServiceDefinitionAndStatus setValue(ServiceDefinitionAndStatus value) {
            throw new UnsupportedOperationException();
        }

        public boolean hasTestableMethod() {
            if (GrpcServices.this.configuration.server.ssl.certificate.isPresent() || GrpcServices.this.configuration.server.ssl.keyStore.isPresent()) {
                return false;
            }
            Map prototypes = (Map)DevConsoleManager.getGlobal((String)"io.quarkus.grpc.messagePrototypes");
            for (ServerMethodDefinition<?, ?> method : this.getMethods()) {
                if (method.getMethodDescriptor().getType() == MethodDescriptor.MethodType.UNKNOWN || !prototypes.containsKey(method.getMethodDescriptor().getFullMethodName() + "_REQUEST")) continue;
                return true;
            }
            return false;
        }
    }
}

