/*
 * Decompiled with CFR 0.152.
 */
package com.salesforce.jprotoc;

import com.github.mustachejava.DefaultMustacheFactory;
import com.github.mustachejava.Mustache;
import com.github.mustachejava.MustacheFactory;
import com.google.common.base.Charsets;
import com.google.common.base.Preconditions;
import com.google.protobuf.ByteString;
import com.google.protobuf.compiler.PluginProtos;
import com.salesforce.jprotoc.GeneratorException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Stream;
import javax.annotation.Nonnull;

public abstract class Generator {
    private static final MustacheFactory MUSTACHE_FACTORY = new DefaultMustacheFactory();

    @Deprecated
    public Stream<PluginProtos.CodeGeneratorResponse.File> generate(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        return Stream.empty();
    }

    public List<PluginProtos.CodeGeneratorResponse.File> generateFiles(PluginProtos.CodeGeneratorRequest request) throws GeneratorException {
        return Collections.emptyList();
    }

    protected List<PluginProtos.CodeGeneratorResponse.Feature> supportedFeatures() {
        return Collections.singletonList(PluginProtos.CodeGeneratorResponse.Feature.FEATURE_NONE);
    }

    protected String applyTemplate(@Nonnull String resourcePath, @Nonnull Object generatorContext) {
        Preconditions.checkNotNull(resourcePath, "resourcePath");
        Preconditions.checkNotNull(generatorContext, "generatorContext");
        InputStream resource = MustacheFactory.class.getClassLoader().getResourceAsStream(resourcePath);
        if (resource == null) {
            throw new RuntimeException("Could not find resource " + resourcePath);
        }
        InputStreamReader resourceReader = new InputStreamReader(resource, Charsets.UTF_8);
        Mustache template = MUSTACHE_FACTORY.compile(resourceReader, resourcePath);
        return template.execute((Writer)new StringWriter(), generatorContext).toString();
    }

    protected PluginProtos.CodeGeneratorResponse.File makeFile(String fileName, String fileContent) {
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(fileName).setContent(fileContent).build();
    }

    protected PluginProtos.CodeGeneratorResponse.File makeFile(String fileName, byte[] fileContent) {
        return PluginProtos.CodeGeneratorResponse.File.newBuilder().setName(fileName).setContentBytes(ByteString.copyFrom(fileContent)).build();
    }
}

