/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.grpc;

import io.grpc.ClientInterceptor;
import io.grpc.Metadata;
import io.grpc.stub.AbstractStub;
import io.grpc.stub.MetadataUtils;
import io.quarkus.arc.ClientProxy;
import io.quarkus.grpc.MutinyClient;

public class GrpcClientUtils {
    public static <T> T attachHeaders(T client, Metadata extraHeaders) {
        if (client == null) {
            throw new NullPointerException("Cannot attach headers to a null client");
        }
        if ((client = GrpcClientUtils.getProxiedObject(client)) instanceof AbstractStub) {
            return (T)((AbstractStub)client).withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)extraHeaders)});
        }
        if (client instanceof MutinyClient) {
            MutinyClient mutinyClient = (MutinyClient)client;
            AbstractStub stub = mutinyClient.getStub().withInterceptors(new ClientInterceptor[]{MetadataUtils.newAttachHeadersInterceptor((Metadata)extraHeaders)});
            return (T)((MutinyClient)client).newInstanceWithStub(stub);
        }
        throw new IllegalArgumentException("Unsupported client type " + String.valueOf(client.getClass()));
    }

    public static <T> T getProxiedObject(T client) {
        if (client instanceof ClientProxy) {
            client = ((ClientProxy)client).arc_contextualInstance();
        }
        return client;
    }
}

