/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.flyway.runtime;

import io.agroal.api.AgroalDataSource;
import io.quarkus.agroal.runtime.DataSources;
import io.quarkus.arc.Arc;
import io.quarkus.flyway.runtime.FlywayContainer;
import io.quarkus.flyway.runtime.FlywayContainerProducer;
import io.quarkus.flyway.runtime.QuarkusPathLocationScanner;
import io.quarkus.runtime.annotations.Recorder;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.function.Supplier;
import javax.sql.DataSource;
import org.flywaydb.core.Flyway;
import org.flywaydb.core.api.migration.JavaMigration;
import org.jboss.logging.Logger;

@Recorder
public class FlywayRecorder {
    private static final Logger log = Logger.getLogger(FlywayRecorder.class);
    private final List<FlywayContainer> flywayContainers = new ArrayList<FlywayContainer>(2);

    public void setApplicationMigrationFiles(Collection<String> migrationFiles) {
        log.debugv("Setting the following application migration files: {0}", migrationFiles);
        QuarkusPathLocationScanner.setApplicationMigrationFiles(migrationFiles);
    }

    public void setApplicationMigrationClasses(Collection<Class<? extends JavaMigration>> migrationClasses) {
        log.debugv("Setting the following application migration classes: {0}", migrationClasses);
        QuarkusPathLocationScanner.setApplicationMigrationClasses(migrationClasses);
    }

    public Supplier<Flyway> flywaySupplier(String dataSourceName) {
        AgroalDataSource dataSource = DataSources.fromName((String)dataSourceName);
        FlywayContainerProducer flywayProducer = (FlywayContainerProducer)Arc.container().instance(FlywayContainerProducer.class, new Annotation[0]).get();
        final FlywayContainer flywayContainer = flywayProducer.createFlyway((DataSource)dataSource, dataSourceName);
        this.flywayContainers.add(flywayContainer);
        return new Supplier<Flyway>(){

            @Override
            public Flyway get() {
                return flywayContainer.getFlyway();
            }
        };
    }

    public void doStartActions() {
        for (FlywayContainer flywayContainer : this.flywayContainers) {
            if (flywayContainer.isCleanAtStart()) {
                flywayContainer.getFlyway().clean();
            }
            if (!flywayContainer.isMigrateAtStart()) continue;
            flywayContainer.getFlyway().migrate();
        }
    }
}

