/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

import io.quarkus.devui.spi.AbstractDevUIBuildItem;
import io.quarkus.devui.spi.buildtime.BuildTimeData;
import io.quarkus.devui.spi.page.PageBuilder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public abstract class AbstractPageBuildItem
extends AbstractDevUIBuildItem {
    protected final Map<String, BuildTimeData> buildTimeData = new HashMap<String, BuildTimeData>();
    protected final List<PageBuilder> pageBuilders;
    protected String headlessComponentLink = null;

    public AbstractPageBuildItem() {
        this.pageBuilders = new ArrayList<PageBuilder>();
    }

    public AbstractPageBuildItem(PageBuilder ... pageBuilder) {
        this.pageBuilders = new ArrayList<PageBuilder>(Arrays.asList(pageBuilder));
    }

    public AbstractPageBuildItem(String customIdentifier) {
        super(customIdentifier);
        this.pageBuilders = new ArrayList<PageBuilder>();
    }

    public AbstractPageBuildItem(String customIdentifier, PageBuilder ... pageBuilder) {
        super(customIdentifier);
        this.pageBuilders = new ArrayList<PageBuilder>(Arrays.asList(pageBuilder));
    }

    public void addPage(PageBuilder page) {
        this.pageBuilders.add(page);
    }

    public List<PageBuilder> getPages() {
        return this.pageBuilders;
    }

    public boolean hasPages() {
        return !this.pageBuilders.isEmpty();
    }

    public void addBuildTimeData(String fieldName, Object fieldData) {
        this.addBuildTimeData(fieldName, fieldData, null);
    }

    public void addBuildTimeData(String fieldName, Object fieldData, String description) {
        this.buildTimeData.put(fieldName, new BuildTimeData(fieldData, description));
    }

    public void addBuildTimeData(String fieldName, Object fieldData, String description, boolean mcpEnabledByDefault) {
        this.buildTimeData.put(fieldName, new BuildTimeData(fieldData, description, mcpEnabledByDefault));
    }

    public Map<String, BuildTimeData> getBuildTimeData() {
        return this.buildTimeData;
    }

    public boolean hasBuildTimeData() {
        return this.buildTimeData != null && !this.buildTimeData.isEmpty();
    }

    public void setHeadlessComponentLink(String headlessComponentLink) {
        this.headlessComponentLink = headlessComponentLink;
    }

    public String getHeadlessComponentLink() {
        return this.headlessComponentLink;
    }
}

