/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devui.spi.page;

public class Card {
    private final String componentName;
    private final String componentLink;
    private String namespace;
    private static final String SLASH = "/";
    private static final String DOT = ".";
    private static final String DOT_JS = ".js";

    public Card(String componentLink) {
        this.componentLink = componentLink.endsWith(DOT_JS) ? componentLink : componentLink + DOT_JS;
        this.componentName = this.componentLink.substring(0, this.componentLink.length() - 3);
    }

    public String getComponentRef() {
        if (this.namespace != null) {
            return "./../" + this.namespace + SLASH + this.componentLink;
        }
        throw new RuntimeException("Could not find component reference");
    }

    public void setNamespace(String namespace) {
        this.namespace = namespace;
    }

    public String getNamespace() {
        return this.namespace;
    }

    public String getComponentLink() {
        return this.componentLink;
    }

    public String getComponentName() {
        return this.componentName;
    }

    public String toString() {
        return "Card {\n\tnamespace=" + this.namespace + ", \n\tcomponentLink=" + this.componentLink + "\n}";
    }
}

