/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.JsonPropertyOrder;
import io.quarkus.registry.config.RegistryQuarkusVersionsConfig;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;

@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
@JsonPropertyOrder(value={"recognizedVersionsExpression", "recognizedGroupIds", "exclusiveProvider"})
public class RegistryQuarkusVersionsConfigImpl
implements RegistryQuarkusVersionsConfig {
    private final String recognizedVersionsExpression;
    private final Collection<String> recognizedGroupIds;
    private final boolean exclusiveProvider;

    private RegistryQuarkusVersionsConfigImpl(String recognizedVersionsExpression, Collection<String> recognizedGroupIds, boolean exclusiveProvider) {
        this.exclusiveProvider = exclusiveProvider;
        this.recognizedVersionsExpression = recognizedVersionsExpression;
        this.recognizedGroupIds = recognizedGroupIds;
    }

    @Override
    public String getRecognizedVersionsExpression() {
        return this.recognizedVersionsExpression;
    }

    @Override
    public Collection<String> getRecognizedGroupIds() {
        return this.recognizedGroupIds;
    }

    @Override
    public boolean isExclusiveProvider() {
        return this.exclusiveProvider;
    }

    public boolean equals(Object o) {
        return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigEquals(this, o);
    }

    public int hashCode() {
        int result = Objects.hashCode(this.recognizedVersionsExpression);
        result = 31 * result + Objects.hashCode(this.recognizedGroupIds);
        result = 31 * result + Boolean.hashCode(this.exclusiveProvider);
        return result;
    }

    public String toString() {
        return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigToString(this);
    }

    static boolean quarkusVersionConfigEquals(RegistryQuarkusVersionsConfig v, Object o) {
        if (v == o) {
            return true;
        }
        if (!(o instanceof RegistryQuarkusVersionsConfig)) {
            return false;
        }
        RegistryQuarkusVersionsConfig that = (RegistryQuarkusVersionsConfig)o;
        if (v.isExclusiveProvider() != that.isExclusiveProvider() || !Objects.equals(v.getRecognizedVersionsExpression(), that.getRecognizedVersionsExpression()) || v.getRecognizedGroupIds().size() != that.getRecognizedGroupIds().size()) {
            return false;
        }
        return v.getRecognizedGroupIds().containsAll(that.getRecognizedGroupIds());
    }

    static String quarkusVersionConfigToString(RegistryQuarkusVersionsConfig v) {
        return "RegistryQuarkusVersionsConfig{exclusiveProvider=" + v.isExclusiveProvider() + ", recognizedVersionsExpression='" + v.getRecognizedVersionsExpression() + "', recognizedGroupIds=" + String.valueOf(v.getRecognizedGroupIds()) + "}";
    }

    public static class Builder
    implements RegistryQuarkusVersionsConfig.Mutable {
        protected String recognizedVersionsExpression;
        protected boolean exclusiveProvider;
        protected Collection<String> recognizedGroupIds = new ArrayList<String>(0);

        public Builder() {
        }

        @JsonIgnore
        Builder(RegistryQuarkusVersionsConfig config) {
            this.recognizedVersionsExpression = config.getRecognizedVersionsExpression();
            this.exclusiveProvider = config.isExclusiveProvider();
        }

        @Override
        public RegistryQuarkusVersionsConfigImpl build() {
            return new RegistryQuarkusVersionsConfigImpl(this.recognizedVersionsExpression, this.recognizedGroupIds, this.exclusiveProvider);
        }

        @Override
        public String getRecognizedVersionsExpression() {
            return this.recognizedVersionsExpression;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable setRecognizedVersionsExpression(String recognizedVersionsExpression) {
            this.recognizedVersionsExpression = recognizedVersionsExpression;
            return this;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable addRecognizedGroupId(String recognizedGropuId) {
            this.recognizedGroupIds.add(recognizedGropuId);
            return this;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable setRecognizedGroupIds(Collection<String> recognizedGroupIds) {
            this.recognizedGroupIds = recognizedGroupIds;
            return this;
        }

        @Override
        public Collection<String> getRecognizedGroupIds() {
            return this.recognizedGroupIds;
        }

        @Override
        public boolean isExclusiveProvider() {
            return this.exclusiveProvider;
        }

        @Override
        public RegistryQuarkusVersionsConfig.Mutable setExclusiveProvider(boolean exclusiveProvider) {
            this.exclusiveProvider = exclusiveProvider;
            return this;
        }

        public boolean equals(Object o) {
            return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigEquals(this, o);
        }

        public int hashCode() {
            return Objects.hash(this.exclusiveProvider, this.recognizedVersionsExpression);
        }

        public String toString() {
            return RegistryQuarkusVersionsConfigImpl.quarkusVersionConfigToString(this);
        }
    }
}

