/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry;

import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.registry.RegistryResolutionException;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.Platform;
import io.quarkus.registry.catalog.PlatformCatalog;
import io.quarkus.registry.catalog.PlatformStream;
import io.quarkus.registry.client.RegistryClient;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.util.GlobUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.regex.Pattern;

class RegistryExtensionResolver {
    public static final int VERSION_NOT_RECOGNIZED = -1;
    public static final int VERSION_NOT_CONFIGURED = 0;
    public static final int VERSION_RECOGNIZED = 1;
    public static final int VERSION_EXCLUSIVE_PROVIDER = 2;
    private static final String DASH_SUPPORT = "-support";
    private final RegistryConfig config;
    private final RegistryClient registry;
    private final Pattern recognizedQuarkusVersions;
    private final Collection<String> recognizedGroupIds;
    private final String offeringSupportKey;
    private final Map<String, String[]> recommendStreamsFrom;

    private static <T> T getExtraConfigOption(RegistryConfig config, String name, Class<T> type) {
        Object o = config.getExtra().get(name);
        if (o == null) {
            return null;
        }
        if (type.isInstance(o)) {
            return (T)o;
        }
        throw new IllegalArgumentException("Expected a value of type " + type.getName() + " for option " + name + " but got " + String.valueOf(o) + " of type " + o.getClass().getName());
    }

    private static String getConfiguredOfferingOrNull(RegistryConfig config) {
        String offering = RegistryExtensionResolver.getExtraConfigOption(config, "offering", String.class);
        return offering == null || offering.isBlank() ? null : offering;
    }

    private static Map<String, String[]> getRecommendStreamsFromOrNull(RegistryConfig config) {
        Map recommendStreamsStarting = RegistryExtensionResolver.getExtraConfigOption(config, "recommend-streams-from", Map.class);
        if (recommendStreamsStarting == null) {
            return Map.of();
        }
        HashMap<String, String[]> result = new HashMap<String, String[]>(recommendStreamsStarting.size());
        for (Map.Entry e : recommendStreamsStarting.entrySet()) {
            result.put((String)e.getKey(), ((String)e.getValue()).split("\\."));
        }
        return result;
    }

    private static int compareStreams(String[] streamParts1, String[] streamParts2) {
        int partI = 0;
        while (partI != streamParts1.length) {
            if (partI == streamParts2.length) {
                return 1;
            }
            int result = streamParts1[partI].compareTo(streamParts2[partI]);
            if (result != 0) {
                return result;
            }
            ++partI;
        }
        return partI == streamParts2.length ? 0 : -1;
    }

    RegistryExtensionResolver(RegistryClient registryClient, MessageWriter log) throws RegistryResolutionException {
        this.registry = Objects.requireNonNull(registryClient, "Registry extension resolver is null");
        this.config = registryClient.resolveRegistryConfig();
        String versionExpr = this.config.getQuarkusVersions() == null ? null : this.config.getQuarkusVersions().getRecognizedVersionsExpression();
        this.recognizedQuarkusVersions = versionExpr == null ? null : Pattern.compile(GlobUtil.toRegexPattern((String)versionExpr));
        this.recognizedGroupIds = this.config.getQuarkusVersions() == null ? Collections.emptyList() : this.config.getQuarkusVersions().getRecognizedGroupIds();
        String offering = RegistryExtensionResolver.getConfiguredOfferingOrNull(this.config);
        if (offering != null) {
            log.debug("Registry %s is limited to offerings %s", new Object[]{this.config.getId(), offering});
            this.offeringSupportKey = offering + DASH_SUPPORT;
        } else {
            this.offeringSupportKey = null;
        }
        this.recommendStreamsFrom = RegistryExtensionResolver.getRecommendStreamsFromOrNull(this.config);
        if (!this.recommendStreamsFrom.isEmpty()) {
            log.debug("Streams before %s recommended by %s will be ignored", new Object[]{this.recommendStreamsFrom, this.config.getId()});
        }
    }

    String getId() {
        return this.config.getId();
    }

    int checkQuarkusVersion(String quarkusVersion) {
        if (this.recognizedQuarkusVersions == null) {
            return 0;
        }
        if (quarkusVersion == null) {
            throw new IllegalArgumentException();
        }
        if (!this.recognizedQuarkusVersions.matcher(quarkusVersion).matches()) {
            return -1;
        }
        return this.config.getQuarkusVersions().isExclusiveProvider() ? 2 : 1;
    }

    boolean isExclusiveProviderOf(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) == 2;
    }

    boolean isAcceptsQuarkusVersionQueries(String quarkusVersion) {
        return this.checkQuarkusVersion(quarkusVersion) >= 0;
    }

    int checkPlatform(ArtifactCoords platform) {
        if (!this.recognizedGroupIds.isEmpty() && !this.recognizedGroupIds.contains(platform.getGroupId())) {
            return -1;
        }
        return this.checkQuarkusVersion(platform.getVersion());
    }

    PlatformCatalog.Mutable resolvePlatformCatalog() throws RegistryResolutionException {
        return this.resolvePlatformCatalog(null);
    }

    PlatformCatalog.Mutable resolvePlatformCatalog(String quarkusCoreVersion) throws RegistryResolutionException {
        PlatformCatalog.Mutable platformCatalog = this.registry.resolvePlatforms(quarkusCoreVersion);
        if (!this.recommendStreamsFrom.isEmpty()) {
            Iterator<Platform> platformI = platformCatalog.getPlatforms().iterator();
            boolean allPlatformsIgnored = true;
            while (platformI.hasNext()) {
                Platform platform = platformI.next();
                String[] fromStream = this.recommendStreamsFrom.get(platform.getPlatformKey());
                if (fromStream != null) {
                    Iterator<PlatformStream> streamI = platform.getStreams().iterator();
                    boolean allStreamsIgnored = true;
                    while (streamI.hasNext()) {
                        PlatformStream stream = streamI.next();
                        if (RegistryExtensionResolver.compareStreams(fromStream, stream.getId().split("\\.")) > 0) {
                            streamI.remove();
                            break;
                        }
                        allStreamsIgnored = false;
                    }
                    while (streamI.hasNext()) {
                        streamI.next();
                        streamI.remove();
                    }
                    if (allStreamsIgnored) {
                        platformI.remove();
                        continue;
                    }
                    allPlatformsIgnored = false;
                    continue;
                }
                allPlatformsIgnored = false;
            }
            if (allPlatformsIgnored) {
                return null;
            }
        }
        return platformCatalog;
    }

    Platform resolveRecommendedPlatform() throws RegistryResolutionException {
        return this.resolvePlatformCatalog().getRecommendedPlatform();
    }

    ExtensionCatalog.Mutable resolveNonPlatformExtensions(String quarkusCoreVersion) throws RegistryResolutionException {
        return this.applyOfferingFilter(this.registry.resolveNonPlatformExtensions(quarkusCoreVersion));
    }

    ExtensionCatalog.Mutable resolvePlatformExtensions(ArtifactCoords platform) throws RegistryResolutionException {
        return this.applyOfferingFilter(this.registry.resolvePlatformExtensions(platform));
    }

    private ExtensionCatalog.Mutable applyOfferingFilter(ExtensionCatalog.Mutable catalog) {
        if (catalog == null) {
            return null;
        }
        Collection<Extension> originalCollection = catalog.getExtensions();
        ArrayList<Extension> offeringCollection = this.offeringSupportKey == null ? null : new ArrayList<Extension>(originalCollection.size());
        HashMap<ArtifactKey, ArtifactCoords> allCatalogExtensions = new HashMap<ArtifactKey, ArtifactCoords>(originalCollection.size());
        for (Extension ext : originalCollection) {
            allCatalogExtensions.put(ext.getArtifact().getKey(), ext.getArtifact());
            if (offeringCollection == null) continue;
            if (ext.getMetadata().containsKey(this.offeringSupportKey)) {
                ext.getMetadata().put("registry-client:user-selected-support-key", this.offeringSupportKey);
                offeringCollection.add(ext);
                continue;
            }
            if (!ext.getArtifact().getArtifactId().equals("quarkus-core")) continue;
            offeringCollection.add(ext);
        }
        catalog.getMetadata().put("registry-client:offering-managed-not-supported-keys", allCatalogExtensions);
        if (offeringCollection != null) {
            catalog.setExtensions(offeringCollection);
        }
        return catalog;
    }

    void clearCache() throws RegistryResolutionException {
        this.registry.clearCache();
    }
}

