/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.catalog.selection;

import java.util.Objects;

public class OriginPreference
implements Comparable<OriginPreference> {
    public final int registryPreference;
    public final int platformPreference;
    public final int releasePreference;
    public final int catalogPreference;
    public final int compatibilityCode;

    public OriginPreference(int registryPreference, int platformPreference, int releasePreference, int catalogPreference, int compatiblityCode) {
        this.registryPreference = registryPreference;
        this.platformPreference = platformPreference;
        this.releasePreference = releasePreference;
        this.catalogPreference = catalogPreference;
        this.compatibilityCode = compatiblityCode;
    }

    public boolean canBeCombinedWith(OriginPreference other) {
        return this.compatibilityCode == other.compatibilityCode && (this.registryPreference != other.registryPreference || this.platformPreference != other.platformPreference || this.releasePreference == other.releasePreference);
    }

    @Override
    public int compareTo(OriginPreference o) {
        int i = this.registryPreference - o.registryPreference;
        if (i != 0) {
            return i;
        }
        i = this.platformPreference - o.platformPreference;
        if (i != 0) {
            return i;
        }
        i = this.releasePreference - o.releasePreference;
        if (i != 0) {
            return i;
        }
        i = this.catalogPreference - o.catalogPreference;
        if (i != 0) {
            return i;
        }
        i = this.compatibilityCode - o.compatibilityCode;
        if (i != 0) {
            return i;
        }
        return 0;
    }

    public int hashCode() {
        return Objects.hash(this.releasePreference, this.platformPreference, this.compatibilityCode, this.registryPreference, this.catalogPreference);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        OriginPreference other = (OriginPreference)obj;
        return this.releasePreference == other.releasePreference && this.compatibilityCode == other.compatibilityCode && this.platformPreference == other.platformPreference && this.registryPreference == other.registryPreference && this.catalogPreference == other.catalogPreference;
    }

    public String toString() {
        return "[" + this.registryPreference + "." + this.platformPreference + "." + this.releasePreference + "." + this.catalogPreference + " " + this.compatibilityCode + "]";
    }
}

