/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.registry.config;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.core.JsonStreamContext;
import com.fasterxml.jackson.core.JsonToken;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.fasterxml.jackson.dataformat.yaml.YAMLGenerator;
import io.quarkus.registry.config.ConfigSource;
import io.quarkus.registry.config.RegistriesConfig;
import io.quarkus.registry.config.RegistriesConfigLocator;
import io.quarkus.registry.config.RegistryConfig;
import io.quarkus.registry.config.RegistryConfigImpl;
import io.quarkus.registry.json.JsonBuilder;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;

@JsonSerialize(using=Serializer.class)
@JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
public class RegistriesConfigImpl
implements RegistriesConfig {
    private final boolean debug;
    private final List<RegistryConfig> registries;
    private ConfigSource configSource;

    private RegistriesConfigImpl(Builder builder) {
        this.debug = builder.debug;
        this.configSource = builder.configSource;
        if (builder.registries.isEmpty()) {
            this.registries = Collections.singletonList(RegistryConfigImpl.getDefaultRegistry());
        } else {
            ArrayList<RegistryConfig> builtConfig = new ArrayList<RegistryConfig>(builder.registries.size());
            boolean sawEnabled = false;
            for (RegistryConfig r : builder.registries) {
                sawEnabled |= r.isEnabled();
                builtConfig.add(JsonBuilder.buildIfBuilder(r));
            }
            if (!sawEnabled) {
                builtConfig.add(RegistryConfigImpl.getDefaultRegistry());
            }
            this.registries = Collections.unmodifiableList(builtConfig);
        }
    }

    @Override
    public boolean isDebug() {
        return this.debug;
    }

    @Override
    public List<RegistryConfig> getRegistries() {
        return this.registries;
    }

    @Override
    @JsonIgnore
    public ConfigSource getSource() {
        return this.configSource;
    }

    @JsonIgnore
    RegistriesConfigImpl setSource(ConfigSource configSource) {
        this.configSource = configSource;
        return this;
    }

    @Override
    public void persist() throws IOException {
        RegistriesConfigImpl.persistConfigSource(this);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RegistriesConfigImpl that = (RegistriesConfigImpl)o;
        return this.debug == that.debug && Objects.equals(this.registries, that.registries);
    }

    public int hashCode() {
        return Objects.hash(this.debug, this.registries);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "{debug=" + this.debug + ", registries=" + String.valueOf(this.registries) + ", configSource=" + String.valueOf(this.configSource) + "}";
    }

    static void persistConfigSource(RegistriesConfigImpl config) throws IOException {
        Path targetFile = config.configSource.getFilePath();
        if (config.configSource == ConfigSource.DEFAULT) {
            targetFile = RegistriesConfigLocator.getDefaultConfigYamlLocation();
        } else if (targetFile == null) {
            throw new UnsupportedOperationException(String.format("Can not write configuration as it was read from an alternate source: %s", config.configSource.describe()));
        }
        config.persist(targetFile);
    }

    @JsonDeserialize(using=Deserializer.class)
    public static class Builder
    implements RegistriesConfig.Mutable {
        protected boolean debug;
        protected final List<RegistryConfig> registries;
        protected ConfigSource configSource = ConfigSource.MANUAL;

        public Builder() {
            this.registries = new ArrayList<RegistryConfig>();
        }

        @JsonIgnore
        Builder(RegistriesConfig config) {
            this.debug = config.isDebug();
            this.registries = new ArrayList<RegistryConfig>(config.getRegistries());
            this.configSource = config.getSource();
        }

        @Override
        @JsonIgnore
        public Builder setRegistry(String registryId) {
            this.addRegistry(registryId);
            return this;
        }

        @Override
        @JsonIgnore
        public Builder setRegistry(RegistryConfig config) {
            this.addRegistry(config);
            return this;
        }

        @Override
        public boolean addRegistry(String registryId) {
            return this.addRegistry(RegistryConfig.builder().setId(registryId).build());
        }

        @Override
        public boolean addRegistry(RegistryConfig config) {
            if (this.registries.stream().anyMatch(r -> r.getId().equals(config.getId()))) {
                return false;
            }
            return this.registries.add(config);
        }

        @Override
        public boolean removeRegistry(String registryId) {
            return this.registries.removeIf(r -> r.getId().equals(registryId));
        }

        @Override
        public boolean isDebug() {
            return this.debug;
        }

        @Override
        public Builder setDebug(boolean debug) {
            this.debug = debug;
            return this;
        }

        @Override
        public List<RegistryConfig> getRegistries() {
            return this.registries;
        }

        @Override
        public Builder setRegistries(List<RegistryConfig> registries) {
            this.registries.clear();
            this.registries.addAll(registries);
            return this;
        }

        @Override
        public RegistriesConfigImpl build() {
            return new RegistriesConfigImpl(this);
        }

        @Override
        public void persist() throws IOException {
            RegistriesConfigImpl.persistConfigSource(this.build());
        }

        @Override
        @JsonIgnore
        public ConfigSource getSource() {
            return this.configSource;
        }

        @JsonIgnore
        public Builder setSource(ConfigSource configSource) {
            this.configSource = configSource;
            return this;
        }
    }

    static class Deserializer
    extends JsonDeserializer<Builder> {
        static final RegistryConfigImpl.BuilderDeserializer DESERIALIZER = new RegistryConfigImpl.BuilderDeserializer();

        Deserializer() {
        }

        public Builder deserialize(JsonParser p, DeserializationContext ctxt) throws IOException, JsonProcessingException {
            JsonStreamContext ctx = p.getParsingContext();
            Builder builder = new Builder();
            while (p.nextValue() != null) {
                if ("debug".equals(p.getCurrentName())) {
                    builder.setDebug(p.getBooleanValue());
                    continue;
                }
                if (!"registries".equals(p.getCurrentName())) continue;
                while (p.nextValue() != JsonToken.END_ARRAY) {
                    RegistryConfigImpl.Builder config = DESERIALIZER.deserialize(p, ctxt);
                    if (config == null) continue;
                    builder.addRegistry(config);
                }
                JsonBuilder.ensureNextToken(p, JsonToken.END_OBJECT, ctxt);
            }
            return builder;
        }
    }

    static class Serializer
    extends JsonSerializer<RegistriesConfigImpl> {
        Serializer() {
        }

        public void serialize(RegistriesConfigImpl value, JsonGenerator gen, SerializerProvider serializers) throws IOException {
            boolean isDefaultDebug = !value.debug;
            boolean isDefaultList = RegistryConfigImpl.isDefaultList(value.registries);
            if (isDefaultDebug && isDefaultList) {
                gen.writeNumber("");
            } else {
                gen.writeStartObject();
                if (gen instanceof YAMLGenerator) {
                    if (!isDefaultDebug) {
                        gen.writeObjectField("debug", (Object)true);
                    }
                    if (!isDefaultList) {
                        gen.writeObjectField("registries", value.registries);
                    }
                } else {
                    for (RegistryConfig x : value.registries) {
                        gen.writeObjectFieldStart(x.getId());
                        RegistryConfigImpl.Serializer.writeContents(x, gen);
                        gen.writeEndObject();
                    }
                }
                gen.writeEndObject();
            }
        }
    }
}

