/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.messagewriter;

import io.quarkus.devtools.messagewriter.DefaultMessageWriter;
import java.io.PrintStream;

public interface MessageWriter {
    public static MessageWriter info() {
        return new DefaultMessageWriter();
    }

    public static MessageWriter info(PrintStream out) {
        return new DefaultMessageWriter(out);
    }

    public static MessageWriter debug() {
        return new DefaultMessageWriter(true);
    }

    public static MessageWriter debug(PrintStream out) {
        return new DefaultMessageWriter(out, true);
    }

    default public void info(String format, Object ... args) {
        this.info(String.format(format, args));
    }

    public void info(String var1);

    default public void error(String format, Object ... args) {
        this.error(String.format(format, args));
    }

    public void error(String var1);

    public boolean isDebugEnabled();

    default public void debug(String format, Object ... args) {
        if (!this.isDebugEnabled()) {
            return;
        }
        this.debug(String.format(format, args));
    }

    public void debug(String var1);

    default public void warn(String format, Object ... args) {
        this.warn(String.format(format, args));
    }

    public void warn(String var1);
}

