/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devtools.commands.handlers;

import io.quarkus.devtools.codestarts.CodestartProjectDefinition;
import io.quarkus.devtools.codestarts.CodestartType;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartCatalog;
import io.quarkus.devtools.codestarts.quarkus.QuarkusCodestartProjectInput;
import io.quarkus.devtools.commands.data.QuarkusCommandException;
import io.quarkus.devtools.commands.data.QuarkusCommandInvocation;
import io.quarkus.devtools.commands.data.QuarkusCommandOutcome;
import io.quarkus.devtools.commands.handlers.CreateProjectCodestartDataConverter;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandler;
import io.quarkus.devtools.commands.handlers.QuarkusCommandHandlers;
import io.quarkus.devtools.messagewriter.MessageIcons;
import io.quarkus.devtools.messagewriter.MessageWriter;
import io.quarkus.devtools.project.extensions.Extensions;
import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.platform.catalog.processor.ExtensionProcessor;
import io.quarkus.platform.tools.ToolsUtils;
import io.quarkus.registry.CatalogMergeUtility;
import io.quarkus.registry.catalog.Extension;
import io.quarkus.registry.catalog.ExtensionCatalog;
import io.quarkus.registry.catalog.ExtensionOrigin;
import io.quarkus.registry.catalog.selection.ExtensionOrigins;
import io.quarkus.registry.catalog.selection.OriginCombination;
import io.quarkus.registry.catalog.selection.OriginPreference;
import io.quarkus.registry.catalog.selection.OriginSelector;
import java.io.IOException;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Properties;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.stream.Collectors;

public class CreateProjectCommandHandler
implements QuarkusCommandHandler {
    private static final String MAVEN = "maven";
    private static final String GRADLE = "gradle";
    private static final String QUARKUS_BOM = "quarkus-bom";
    private static final String QUARKUS_CORE = "quarkus-core";

    @Override
    public QuarkusCommandOutcome execute(QuarkusCommandInvocation invocation) throws QuarkusCommandException {
        Set<String> extensionsQuery = invocation.getValue("project.extensions", Set.of());
        String className = invocation.getStringValue("project.resource.class-name");
        String pkgName = invocation.getStringValue("project.package-name");
        String groupId = invocation.getStringValue("project.group-id");
        if (pkgName == null) {
            if (className != null && className.contains(".")) {
                int idx = className.lastIndexOf(46);
                invocation.setValue("project.package-name", className.substring(0, idx));
                invocation.setValue("project.resource.class-name", className.substring(idx + 1));
            } else if (groupId != null) {
                invocation.setValue("project.package-name", groupId.replace('-', '.').replace('_', '.'));
            }
        }
        List<Extension> extensionsToAdd = this.computeRequiredExtensions(invocation.getExtensionsCatalog(), extensionsQuery, invocation.log());
        ExtensionCatalog mainCatalog = invocation.getExtensionsCatalog();
        String javaVersion = invocation.getStringValue("project.java-version");
        this.checkMinimumJavaVersion(javaVersion, extensionsToAdd);
        List<ExtensionCatalog> extensionOrigins = CreateProjectCommandHandler.getExtensionOrigins(mainCatalog, extensionsToAdd);
        ProjectDependencyInfo depInfo = extensionOrigins.isEmpty() ? new ProjectDependencyInfo(mainCatalog, extensionsToAdd) : new ProjectDependencyInfo(extensionOrigins, extensionsToAdd, extensionsQuery);
        mainCatalog = depInfo.getPrimaryPlatformCatalog();
        depInfo.setQuarkusProperties(invocation);
        invocation.setValue("bom.group-id", mainCatalog.getBom().getGroupId());
        invocation.setValue("bom.artifact-id", mainCatalog.getBom().getArtifactId());
        invocation.setValue("bom.version", mainCatalog.getBom().getVersion());
        invocation.setValue("quarkus-version", mainCatalog.getQuarkusCoreVersion());
        try {
            HashMap platformData = new HashMap();
            if (mainCatalog.getMetadata().get(MAVEN) != null) {
                platformData.put(MAVEN, mainCatalog.getMetadata().get(MAVEN));
            }
            if (mainCatalog.getMetadata().get(GRADLE) != null) {
                platformData.put(GRADLE, mainCatalog.getMetadata().get(GRADLE));
            }
            QuarkusCodestartProjectInput input = QuarkusCodestartProjectInput.builder().addPlatforms(depInfo.getBoms()).addExtensions(depInfo.getDependencies()).buildTool(invocation.getQuarkusProject().getBuildTool()).example((String)invocation.getValue("codegen.example")).noCode(invocation.getValue("codegen.no-code", false)).addCodestarts((Collection)invocation.getValue("codegen.extra-codestarts", Set.of())).noBuildToolWrapper(invocation.getValue("codegen.no-buildtool-wrapper", false)).noDockerfiles(invocation.getValue("codegen.no-dockerfiles", false)).addData((Map)depInfo.getPlatformProjectData()).addData((Map)platformData).addData((Map)CreateProjectCodestartDataConverter.toCodestartData(invocation.getValues())).addData(invocation.getValue("data", Map.of())).messageWriter(invocation.log()).defaultCodestart(CreateProjectCommandHandler.getDefaultCodestart(mainCatalog)).build();
            invocation.log().info("-----------");
            if (!depInfo.getDependencies().isEmpty()) {
                invocation.log().info("selected extensions: \n" + depInfo.getDependencies().stream().map(e -> "- " + e.getGroupId() + ":" + e.getArtifactId() + "\n").collect(Collectors.joining()));
            }
            QuarkusCodestartCatalog catalog = QuarkusCodestartCatalog.fromExtensionsCatalog(invocation.getQuarkusProject().getExtensionsCatalog(), invocation.getQuarkusProject().getCodestartResourceLoaders());
            CodestartProjectDefinition projectDefinition = catalog.createProject(input);
            projectDefinition.generate(invocation.getQuarkusProject().getProjectDirPath());
            invocation.log().info("\n-----------\n" + String.valueOf(MessageIcons.SUCCESS_ICON) + " " + projectDefinition.getRequiredCodestart(CodestartType.PROJECT).getName() + " project has been successfully generated in:\n--> " + invocation.getQuarkusProject().getProjectDirPath().toString() + "\n-----------");
        }
        catch (IOException e2) {
            throw new QuarkusCommandException("Failed to create project: " + e2.getMessage(), e2);
        }
        return QuarkusCommandOutcome.success();
    }

    private static void setQuarkusProperties(QuarkusCommandInvocation invocation, ExtensionCatalog catalog) {
        Properties quarkusProps = ToolsUtils.readQuarkusProperties(catalog);
        quarkusProps.forEach((BiConsumer<? super Object, ? super Object>)((BiConsumer<Object, Object>)(k, v) -> {
            String name = k.toString();
            if (!invocation.hasValue(name)) {
                invocation.setValue(name, v.toString());
            }
        }));
    }

    private List<Extension> computeRequiredExtensions(ExtensionCatalog catalog, Set<String> extensionsQuery, MessageWriter log) throws QuarkusCommandException {
        List<Extension> extensionsToAdd = QuarkusCommandHandlers.computeExtensionsFromQuery(catalog, extensionsQuery, log);
        if (extensionsToAdd == null) {
            throw new QuarkusCommandException("Failed to create project because of invalid extensions");
        }
        return extensionsToAdd;
    }

    private static List<ExtensionCatalog> getExtensionOrigins(ExtensionCatalog extensionCatalog, List<Extension> extensionsToAdd) throws QuarkusCommandException {
        if (extensionsToAdd.isEmpty() && extensionCatalog.isPlatform()) {
            return List.of(extensionCatalog);
        }
        Extension quarkusCore = CreateProjectCommandHandler.findQuarkusCore(extensionCatalog);
        if (extensionsToAdd.isEmpty()) {
            Object object;
            if (quarkusCore.getOrigins().size() == 1 && (object = quarkusCore.getOrigins().get(0)) instanceof ExtensionCatalog) {
                ExtensionCatalog originCatalog = (ExtensionCatalog)object;
                return List.of(originCatalog);
            }
            extensionsToAdd = List.of(quarkusCore);
        }
        ArrayList<ExtensionOrigins> originsWithPreferences = new ArrayList<ExtensionOrigins>();
        for (Extension e : extensionsToAdd) {
            CreateProjectCommandHandler.addOriginsWithPreferences(originsWithPreferences, e);
        }
        if (!originsWithPreferences.isEmpty()) {
            return CreateProjectCommandHandler.getRecommendedOrigins(extensionsToAdd, quarkusCore, originsWithPreferences);
        }
        if (extensionCatalog.isPlatform()) {
            return List.of(extensionCatalog);
        }
        LinkedHashMap<String, ExtensionCatalog> catalogMap = new LinkedHashMap<String, ExtensionCatalog>();
        for (Extension e : extensionsToAdd) {
            Object e2;
            List origins = e.getOrigins();
            if (origins.isEmpty() || !((e2 = origins.get(0)) instanceof ExtensionCatalog)) continue;
            ExtensionCatalog originCatalog = (ExtensionCatalog)e2;
            catalogMap.putIfAbsent(originCatalog.getId(), originCatalog);
        }
        return List.copyOf(catalogMap.values());
    }

    private static List<ExtensionCatalog> getRecommendedOrigins(List<Extension> extensionsToAdd, Extension quarkusCore, List<ExtensionOrigins> extOrigins) throws QuarkusCommandException {
        OriginCombination recommendedCombination = OriginSelector.of(extOrigins).calculateRecommendedCombination();
        if (recommendedCombination == null) {
            throw new QuarkusCommandException(CreateProjectCommandHandler.noCompatibleQuarkusCoreVersion(extensionsToAdd));
        }
        List<ExtensionCatalog> sortedCatalogs = recommendedCombination.getUniqueSortedCatalogs();
        if (!CreateProjectCommandHandler.containsQuarkusCore(extensionsToAdd) && (sortedCatalogs = CreateProjectCommandHandler.ensureQuarkusCorePresent(sortedCatalogs, quarkusCore)).isEmpty()) {
            throw new QuarkusCommandException(CreateProjectCommandHandler.noCompatibleQuarkusCoreVersion(extensionsToAdd));
        }
        if (sortedCatalogs.size() < 2) {
            return sortedCatalogs;
        }
        ArrayList<ArtifactKey> extDeps = new ArrayList<ArtifactKey>(extensionsToAdd.size());
        for (Extension e : extensionsToAdd) {
            extDeps.add(e.getArtifact().getKey());
        }
        ArrayList<ExtensionCatalog> reducedCatalogs = null;
        for (int i = 0; i < sortedCatalogs.size(); ++i) {
            Object o;
            ExtensionCatalog catalog = sortedCatalogs.get(i);
            if (reducedCatalogs != null) {
                reducedCatalogs.add(catalog);
            }
            if (!catalog.isPlatform() || !((o = catalog.getMetadata().get("registry-client:offering-managed-not-supported-keys")) instanceof Map)) continue;
            Map allManagedExtensionKeys = (Map)o;
            if (!extDeps.removeIf(allManagedExtensionKeys::containsKey)) continue;
            if (reducedCatalogs == null) {
                if (i == sortedCatalogs.size() - 1) break;
                reducedCatalogs = new ArrayList<ExtensionCatalog>(sortedCatalogs.size());
                for (int j = 0; j <= i; ++j) {
                    reducedCatalogs.add(sortedCatalogs.get(j));
                }
            }
            if (extDeps.isEmpty()) break;
        }
        return reducedCatalogs == null ? sortedCatalogs : reducedCatalogs;
    }

    private static List<ExtensionCatalog> ensureQuarkusCorePresent(List<ExtensionCatalog> catalogs, Extension quarkusCore) {
        Map<String, ExtensionCatalog> allCoreOrigins = null;
        ExtensionCatalog matchingQuarkusCoreOrigin = null;
        int catalogContainingCoreIndex = -1;
        for (int i = 0; i < catalogs.size(); ++i) {
            Map allCatalogExtensions;
            ArtifactCoords managedQuarkusCore;
            Object v;
            ExtensionCatalog catalog = catalogs.get(i);
            if (catalog.isPlatform() && (v = catalog.getMetadata().get("registry-client:offering-managed-not-supported-keys")) instanceof Map && (managedQuarkusCore = (ArtifactCoords)(allCatalogExtensions = (Map)v).get(quarkusCore.getArtifact().getKey())) != null) {
                if (i == 0) {
                    return catalogs;
                }
                catalogContainingCoreIndex = i;
                matchingQuarkusCoreOrigin = catalog;
                break;
            }
            if (matchingQuarkusCoreOrigin != null) continue;
            if (allCoreOrigins == null) {
                allCoreOrigins = CreateProjectCommandHandler.getOriginCatalogsByQuarkusCore(quarkusCore.getOrigins());
            }
            matchingQuarkusCoreOrigin = allCoreOrigins.get(catalog.getQuarkusCoreVersion());
        }
        if (matchingQuarkusCoreOrigin == null) {
            return List.of();
        }
        if (catalogContainingCoreIndex >= 0) {
            ArrayList<ExtensionCatalog> result = new ArrayList<ExtensionCatalog>(catalogs);
            Collections.swap(result, 0, catalogContainingCoreIndex);
            return result;
        }
        ArrayList<ExtensionCatalog> result = new ArrayList<ExtensionCatalog>(catalogs.size() + 1);
        result.add(matchingQuarkusCoreOrigin);
        result.addAll(catalogs);
        return result;
    }

    private static String noCompatibleQuarkusCoreVersion(List<Extension> extensionsToAdd) {
        StringBuilder buf = new StringBuilder();
        buf.append("Failed to determine a compatible Quarkus version for the requested extensions: ");
        buf.append(extensionsToAdd.get(0).getArtifact().getKey().toGacString());
        for (int i = 1; i < extensionsToAdd.size(); ++i) {
            buf.append(", ").append(extensionsToAdd.get(i).getArtifact().getKey().toGacString());
        }
        return buf.toString();
    }

    private static Map<String, ExtensionCatalog> getOriginCatalogsByQuarkusCore(List<ExtensionOrigin> origins) {
        HashMap<String, ExtensionCatalog> result = new HashMap<String, ExtensionCatalog>(origins.size());
        for (ExtensionOrigin origin : origins) {
            if (!(origin instanceof ExtensionCatalog)) continue;
            ExtensionCatalog catalog = (ExtensionCatalog)origin;
            result.putIfAbsent(catalog.getQuarkusCoreVersion(), catalog);
        }
        return result;
    }

    private static boolean containsQuarkusCore(List<Extension> extensions) {
        for (Extension e : extensions) {
            if (!e.getArtifact().getArtifactId().equals(QUARKUS_CORE)) continue;
            return true;
        }
        return false;
    }

    private static Extension findQuarkusCore(ExtensionCatalog extensionCatalog) throws QuarkusCommandException {
        Optional<Extension> quarkusCore = extensionCatalog.getExtensions().stream().filter(e -> e.getArtifact().getArtifactId().equals(QUARKUS_CORE)).findFirst();
        if (quarkusCore.isEmpty()) {
            throw new QuarkusCommandException("Failed to locate quarkus-core in the extension catalog");
        }
        return quarkusCore.get();
    }

    private static void addOriginsWithPreferences(List<ExtensionOrigins> extOrigins, Extension e) {
        ExtensionOrigins.Builder eoBuilder = null;
        for (ExtensionOrigin c : e.getOrigins()) {
            if (!(c instanceof ExtensionCatalog)) continue;
            ExtensionCatalog catalog = (ExtensionCatalog)c;
            OriginPreference op = (OriginPreference)c.getMetadata().get("registry-client:origin-preference");
            if (op == null) continue;
            if (eoBuilder == null) {
                eoBuilder = ExtensionOrigins.builder((ArtifactKey)e.getArtifact().getKey());
            }
            eoBuilder.addOrigin(catalog, op);
        }
        if (eoBuilder != null) {
            extOrigins.add(eoBuilder.build());
        }
    }

    private void checkMinimumJavaVersion(String javaVersionString, List<Extension> extensions) throws QuarkusCommandException {
        ArrayList<Extension> incompatibleExtensions = new ArrayList<Extension>();
        int javaVersion = javaVersionString == null ? 17 : Integer.parseInt(javaVersionString);
        for (Extension extension : extensions) {
            Integer extMinJavaVersion = ExtensionProcessor.getMinimumJavaVersion(extension);
            if (extMinJavaVersion == null || javaVersion >= extMinJavaVersion) continue;
            incompatibleExtensions.add(extension);
        }
        if (!incompatibleExtensions.isEmpty()) {
            String list = incompatibleExtensions.stream().map(e -> String.format("- %s (min: %s)", e.managementKey(), ExtensionProcessor.getMinimumJavaVersion(e))).collect(Collectors.joining("\n  "));
            throw new QuarkusCommandException(String.format("Some extensions are not compatible with the selected Java version (%s):\n %s", javaVersion, list));
        }
    }

    private static String getDefaultCodestart(ExtensionCatalog catalog) {
        Object defaultCodestart;
        Object projectMetadata;
        Map map = catalog.getMetadata();
        if (map != null && !map.isEmpty() && (projectMetadata = map.get("project")) instanceof Map && (defaultCodestart = ((Map)projectMetadata).get("default-codestart")) != null && defaultCodestart instanceof String) {
            return defaultCodestart.toString();
        }
        return "resteasy-reactive";
    }

    private static class ProjectDependencyInfo {
        private final ExtensionCatalog primaryCatalog;
        private final ExtensionCatalog dataCatalog;
        private final List<ArtifactCoords> platformBoms;
        private final List<ArtifactCoords> extensionDeps;

        ProjectDependencyInfo(ExtensionCatalog primaryCatalog, List<Extension> selectedExtensions) {
            this.primaryCatalog = primaryCatalog;
            this.dataCatalog = primaryCatalog;
            this.platformBoms = List.of(primaryCatalog.getBom());
            this.extensionDeps = new ArrayList<ArtifactCoords>(selectedExtensions.size());
            for (Extension e : selectedExtensions) {
                ArtifactCoords coords = e.getArtifact();
                for (ExtensionOrigin origin : e.getOrigins()) {
                    if (!origin.isPlatform() || origin.getBom() == null || !this.platformBoms.contains(origin.getBom())) continue;
                    coords = Extensions.stripVersion(coords);
                    break;
                }
                this.extensionDeps.add(coords);
            }
        }

        ProjectDependencyInfo(List<ExtensionCatalog> extensionOrigins, List<Extension> selectedExtensions, Collection<String> extensionsQuery) {
            LinkedHashMap<ArtifactKey, ArtifactCoords> extensionDeps = new LinkedHashMap<ArtifactKey, ArtifactCoords>(selectedExtensions.size());
            Map<ArtifactKey, ArtifactCoords> userProvidedCoords = ProjectDependencyInfo.collectArtifactCoords(extensionsQuery);
            ArrayDeque<Extension> extensionDeque = new ArrayDeque<Extension>(selectedExtensions);
            this.dataCatalog = CatalogMergeUtility.merge(extensionOrigins);
            ExtensionCatalog primaryCatalog = null;
            this.platformBoms = new ArrayList<ArtifactCoords>(extensionOrigins.size());
            for (ExtensionCatalog c : extensionOrigins) {
                if (c.isPlatform()) {
                    if (primaryCatalog == null || !primaryCatalog.getBom().getArtifactId().equals(CreateProjectCommandHandler.QUARKUS_BOM) && c.getBom().getArtifactId().equals(CreateProjectCommandHandler.QUARKUS_BOM)) {
                        primaryCatalog = c;
                    }
                    this.platformBoms.add(c.getBom());
                }
                Map<ArtifactKey, ArtifactCoords> allCatalogExtensions = ProjectDependencyInfo.getCatalogExtensions(c);
                Iterator<Extension> i = extensionDeque.iterator();
                while (i.hasNext()) {
                    ArtifactKey extKey = i.next().getArtifact().getKey();
                    ArtifactCoords addedCoords = userProvidedCoords.get(extKey);
                    if (addedCoords != null) {
                        extensionDeps.put(extKey, addedCoords);
                        i.remove();
                        continue;
                    }
                    ArtifactCoords mappedCoords = (ArtifactCoords)extensionDeps.get(extKey);
                    if (mappedCoords != null && !c.isPlatform() || (addedCoords = allCatalogExtensions.get(extKey)) == null) continue;
                    if (c.isPlatform()) {
                        addedCoords = Extensions.stripVersion(addedCoords);
                        i.remove();
                    }
                    extensionDeps.put(extKey, addedCoords);
                }
            }
            this.primaryCatalog = Objects.requireNonNull(primaryCatalog, "primary catalog is null");
            this.extensionDeps = List.copyOf(extensionDeps.values());
        }

        private static Map<ArtifactKey, ArtifactCoords> getCatalogExtensions(ExtensionCatalog catalog) {
            Object v = catalog.getMetadata().get("registry-client:offering-managed-not-supported-keys");
            if (v instanceof Map) {
                Map allCatalogExtensions = (Map)v;
                return allCatalogExtensions;
            }
            Collection extensions = catalog.getExtensions();
            HashMap<ArtifactKey, ArtifactCoords> result = new HashMap<ArtifactKey, ArtifactCoords>(extensions.size());
            for (Extension e : extensions) {
                result.put(e.getArtifact().getKey(), e.getArtifact());
            }
            return result;
        }

        private static Map<ArtifactKey, ArtifactCoords> collectArtifactCoords(Collection<String> extensionsQuery) {
            Map<ArtifactKey, ArtifactCoords> result = Map.of();
            for (String extensionExpr : extensionsQuery) {
                if (ToolsUtils.countOf(extensionExpr, 58) <= 1) continue;
                if (result.isEmpty()) {
                    result = new HashMap<ArtifactKey, ArtifactCoords>();
                }
                ArtifactCoords coords = ArtifactCoords.fromString((String)extensionExpr);
                result.put(coords.getKey(), coords);
            }
            return result;
        }

        ExtensionCatalog getPrimaryPlatformCatalog() {
            return this.primaryCatalog;
        }

        List<ArtifactCoords> getBoms() {
            return this.platformBoms;
        }

        List<ArtifactCoords> getDependencies() {
            return this.extensionDeps;
        }

        Map<String, Object> getPlatformProjectData() {
            return ToolsUtils.readProjectData(this.dataCatalog);
        }

        void setQuarkusProperties(QuarkusCommandInvocation invocation) {
            CreateProjectCommandHandler.setQuarkusProperties(invocation, this.dataCatalog);
        }
    }
}

