/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.devservices.postgresql.deployment;

import io.quarkus.deployment.builditem.DevServicesLauncherConfigResultBuildItem;
import java.net.URI;
import java.net.URISyntaxException;
import org.aesh.command.Command;
import org.aesh.command.CommandDefinition;
import org.aesh.command.CommandException;
import org.aesh.command.CommandResult;
import org.aesh.command.invocation.CommandInvocation;

@CommandDefinition(name="print-command", description="Outputs the psql command to connect to the database")
public class PsqlCommand
implements Command {
    private final DevServicesLauncherConfigResultBuildItem devServicesLauncherConfigResultBuildItem;

    public PsqlCommand(DevServicesLauncherConfigResultBuildItem devServicesLauncherConfigResultBuildItem) {
        this.devServicesLauncherConfigResultBuildItem = devServicesLauncherConfigResultBuildItem;
    }

    public CommandResult execute(CommandInvocation commandInvocation) throws CommandException, InterruptedException {
        try {
            URI url = new URI(((String)this.devServicesLauncherConfigResultBuildItem.getConfig().get("quarkus.datasource.jdbc.url")).substring(5));
            int port = url.getPort();
            String host = url.getHost();
            String pw = (String)this.devServicesLauncherConfigResultBuildItem.getConfig().get("quarkus.datasource.password");
            commandInvocation.println("PGPASSWORD=" + pw + " psql --host=" + host + " --port=" + port + " --username=" + (String)this.devServicesLauncherConfigResultBuildItem.getConfig().get("quarkus.datasource.username") + " " + url.getPath().substring(1));
            return CommandResult.SUCCESS;
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }
}

