/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

import io.quarkus.registry.ValueRegistry;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import io.smallrye.config.common.AbstractConfigSource;
import java.util.Set;
import org.eclipse.microprofile.config.spi.ConfigSource;

public class ValueRegistryConfigSource
extends AbstractConfigSource {
    private final ValueRegistry valueRegistry;

    ValueRegistryConfigSource(ValueRegistry valueRegistry) {
        super(ValueRegistryConfigSource.class.getSimpleName(), 0x7FFFFFF5);
        this.valueRegistry = valueRegistry;
    }

    public Set<String> getPropertyNames() {
        return Set.of();
    }

    public String getValue(String propertyName) {
        ValueRegistry.RuntimeInfo value = this.valueRegistry.get(propertyName);
        return value != null ? value.get(this.valueRegistry).toString() : null;
    }

    public static SmallRyeConfigBuilderCustomizer customizer(final ValueRegistry valueRegistry) {
        return new SmallRyeConfigBuilderCustomizer(){

            public void configBuilder(SmallRyeConfigBuilder builder) {
                builder.withSources(new ConfigSource[]{new ValueRegistryConfigSource(valueRegistry)});
            }
        };
    }
}

