/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.ImageMode;
import io.quarkus.runtime.configuration.NameIterator;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.common.utils.StringUtil;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NotDirectoryException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.CopyOnWriteArraySet;
import java.util.function.Consumer;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.jboss.logging.Logger;

public final class ConfigDiagnostic {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.config");
    private static final List<String> errorsMessages = new CopyOnWriteArrayList<String>();
    private static final Set<String> errorKeys = new CopyOnWriteArraySet<String>();
    private static final String APPLICATION = "application";
    private static final int APPLICATION_LENGTH = "application".length();
    private static final DirectoryStream.Filter<Path> CONFIG_FILES_FILTER = new DirectoryStream.Filter<Path>(){

        @Override
        public boolean accept(Path entry) {
            String filename = entry.getFileName().toString();
            return Files.isRegularFile(entry, new LinkOption[0]) && filename.length() > APPLICATION_LENGTH && filename.startsWith(ConfigDiagnostic.APPLICATION) && (filename.charAt(APPLICATION_LENGTH) == '.' || filename.charAt(APPLICATION_LENGTH) == '-');
        }
    };

    private ConfigDiagnostic() {
    }

    public static void invalidValue(String name, IllegalArgumentException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("An invalid value was given for configuration key \"%s\"", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void missingValue(String name, NoSuchElementException ex) {
        String message = ex.getMessage();
        String loggedMessage = message != null ? message : String.format("Configuration key \"%s\" is required, but its value is empty/missing", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void duplicate(String name) {
        String loggedMessage = String.format("Configuration key \"%s\" was specified more than once", name);
        errorsMessages.add(loggedMessage);
        errorKeys.add(name);
    }

    public static void deprecatedProperties(Map<String, String> deprecatedProperties) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        for (Map.Entry<String, String> entry : deprecatedProperties.entrySet()) {
            String propertyName = entry.getKey();
            ConfigValue configValue = config.getConfigValue(propertyName);
            if (configValue.getValue() == null || "DefaultValuesConfigSource".equals(configValue.getConfigSourceName())) continue;
            ConfigDiagnostic.deprecated(propertyName, entry.getValue());
        }
    }

    public static void deprecated(String name, String javadoc) {
        if (javadoc != null) {
            log.warnf("The \"%s\" config property is deprecated and should not be used anymore. Deprecated message: %s", (Object)name, (Object)javadoc);
        } else {
            log.warnf("The \"%s\" config property is deprecated and should not be used anymore.", (Object)name);
        }
    }

    public static void unknown(String name) {
        log.warnf("Unrecognized configuration key \"%s\" was provided; it will be ignored; verify that the dependency extension for this configuration is set or that you did not make a typo", (Object)name);
    }

    public static void unknown(NameIterator name) {
        ConfigDiagnostic.unknown(name.getName());
    }

    public static void unknownProperties(Set<String> properties) {
        if (properties.isEmpty()) {
            return;
        }
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        HashSet<String> usedProperties = new HashSet<String>();
        StringBuilder tmp = null;
        for (String property : config.getPropertyNames()) {
            if (properties.contains(property)) continue;
            if (tmp == null) {
                tmp = new StringBuilder(property.length());
            } else {
                tmp.setLength(0);
            }
            String usedProperty = StringUtil.replaceNonAlphanumericByUnderscores((String)property, (StringBuilder)tmp);
            if (properties.contains(usedProperty)) continue;
            usedProperties.add(usedProperty);
        }
        for (String property : properties) {
            ConfigValue configValue;
            if (property.indexOf(91) != -1 && property.indexOf(93) != -1) continue;
            boolean found = false;
            if (!usedProperties.isEmpty()) {
                if (tmp == null) {
                    tmp = new StringBuilder(property.length());
                } else {
                    tmp.setLength(0);
                }
                String propertyWithUnderscores = StringUtil.replaceNonAlphanumericByUnderscores((String)property, (StringBuilder)tmp);
                for (String usedProperty : usedProperties) {
                    if (!usedProperty.equalsIgnoreCase(propertyWithUnderscores)) continue;
                    found = true;
                    break;
                }
            }
            if (found || !property.equals((configValue = config.getConfigValue(property)).getName())) continue;
            ConfigDiagnostic.unknown(property);
        }
    }

    public static void reportUnknown(Set<String> properties) {
        if (ImageMode.current() == ImageMode.NATIVE_BUILD) {
            ConfigDiagnostic.unknownProperties(properties);
        }
    }

    public static void reportUnknownRuntime(Set<String> properties) {
        ConfigDiagnostic.unknownProperties(properties);
    }

    public static boolean isError() {
        return !errorsMessages.isEmpty();
    }

    public static void resetError() {
        errorKeys.clear();
        errorsMessages.clear();
    }

    public static String getNiceErrorMessage() {
        StringBuilder b = new StringBuilder();
        for (String errorsMessage : errorsMessages) {
            b.append("  - ");
            b.append(errorsMessage);
            b.append(System.lineSeparator());
        }
        return b.toString();
    }

    public static Set<String> getErrorKeys() {
        return new HashSet<String>(errorKeys);
    }

    public static Set<Path> configFiles(Path configFilesLocation) throws IOException {
        if (!Files.exists(configFilesLocation, new LinkOption[0])) {
            return Collections.emptySet();
        }
        HashSet<Path> configFiles = new HashSet<Path>();
        try (DirectoryStream<Path> candidates = Files.newDirectoryStream(configFilesLocation, CONFIG_FILES_FILTER);){
            for (Path candidate : candidates) {
                configFiles.add(candidate);
            }
        }
        catch (NotDirectoryException ignored) {
            log.debugf("File %s is not a directory", (Object)configFilesLocation.toAbsolutePath());
            return Collections.emptySet();
        }
        return configFiles;
    }

    public static Set<Path> configFilesFromLocations() throws Exception {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        final HashSet<Path> configFiles = new HashSet<Path>();
        configFiles.addAll(ConfigDiagnostic.configFiles(Paths.get(System.getProperty("user.dir"), "config")));
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(new Consumer<List<URI>>(){

            @Override
            public void accept(List<URI> locations) {
                for (URI location : locations) {
                    Path path = location.getScheme() != null && location.getScheme().equals("file") ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                    if (!Files.isDirectory(path, new LinkOption[0])) continue;
                    try {
                        configFiles.addAll(ConfigDiagnostic.configFiles(path));
                    }
                    catch (IOException iOException) {}
                }
            }
        });
        return configFiles;
    }

    public static void unknownConfigFiles(Set<Path> configFiles) throws Exception {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        HashSet<String> configNames = new HashSet<String>();
        for (ConfigSource configSource : config.getConfigSources()) {
            if (configSource.getName() == null || !configSource.getName().contains(APPLICATION)) continue;
            configNames.add(configSource.getName());
        }
        for (Path configFile : configFiles) {
            boolean found = false;
            for (String configName : configNames) {
                if (!configName.contains(configFile.toUri().toURL().toString())) continue;
                found = true;
                break;
            }
            if (found) continue;
            String filename = configFile.getFileName().toString();
            if (filename.charAt(APPLICATION_LENGTH) == '-' && filename.lastIndexOf(46) != -1) {
                String unprofiledConfigFile = "application." + filename.substring(filename.lastIndexOf(46) + 1);
                String profile = filename.substring(APPLICATION_LENGTH + 1, filename.lastIndexOf(46));
                if (!config.getProfiles().contains(profile) || Files.exists(Path.of(configFile.getParent().toString(), unprofiledConfigFile), new LinkOption[0])) continue;
                log.warnf("Profiled configuration file %s is ignored; a main %s configuration file must exist in the same location to load %s", (Object)configFile, (Object)unprofiledConfigFile, (Object)filename);
                continue;
            }
            log.warnf("Unrecognized configuration file %s found; Please, check if your are providing the proper extension to load the file", (Object)configFile);
        }
    }
}

