/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.logging;

import io.quarkus.runtime.Application;
import org.jboss.logging.Logger;

public final class Log {
    private static final StackWalker stackWalker = StackWalker.getInstance(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private static final boolean shouldFail = Log.shouldFail();

    private static boolean shouldFail() {
        if (Application.currentApplication() != null) {
            return true;
        }
        try {
            Class.forName("org.junit.jupiter.api.Assertions");
            return false;
        }
        catch (ClassNotFoundException ignored) {
            return true;
        }
    }

    public static boolean isEnabled(Logger.Level level) {
        if (shouldFail) {
            throw Log.fail();
        }
        return Logger.getLogger(stackWalker.getCallerClass()).isEnabled(level);
    }

    public static boolean isTraceEnabled() {
        if (shouldFail) {
            throw Log.fail();
        }
        return Logger.getLogger(stackWalker.getCallerClass()).isTraceEnabled();
    }

    public static void trace(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).trace(message);
    }

    public static void trace(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).trace(message, t);
    }

    public static void trace(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).trace(loggerFqcn, message, t);
    }

    public static void trace(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).trace(loggerFqcn, message, params, t);
    }

    public static void tracev(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(format, params);
    }

    public static void tracev(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(format, param1);
    }

    public static void tracev(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(format, param1, param2);
    }

    public static void tracev(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(format, param1, param2, param3);
    }

    public static void tracev(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(t, format, params);
    }

    public static void tracev(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(t, format, param1);
    }

    public static void tracev(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(t, format, param1, param2);
    }

    public static void tracev(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracev(t, format, param1, param2, param3);
    }

    public static void tracef(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, params);
    }

    public static void tracef(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, param1);
    }

    public static void tracef(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, param1, param2);
    }

    public static void tracef(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, param1, param2, param3);
    }

    public static void tracef(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, params);
    }

    public static void tracef(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, param1);
    }

    public static void tracef(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, param1, param2);
    }

    public static void tracef(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, param1, param2, param3);
    }

    public static void tracef(String format, int arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg);
    }

    public static void tracef(String format, int arg1, int arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2);
    }

    public static void tracef(String format, int arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2);
    }

    public static void tracef(String format, int arg1, int arg2, int arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(String format, int arg1, int arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(String format, int arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, int arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg);
    }

    public static void tracef(Throwable t, String format, int arg1, int arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2);
    }

    public static void tracef(Throwable t, String format, int arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2);
    }

    public static void tracef(Throwable t, String format, int arg1, int arg2, int arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, int arg1, int arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, int arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static void tracef(String format, long arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg);
    }

    public static void tracef(String format, long arg1, long arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2);
    }

    public static void tracef(String format, long arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2);
    }

    public static void tracef(String format, long arg1, long arg2, long arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(String format, long arg1, long arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(String format, long arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, long arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg);
    }

    public static void tracef(Throwable t, String format, long arg1, long arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2);
    }

    public static void tracef(Throwable t, String format, long arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2);
    }

    public static void tracef(Throwable t, String format, long arg1, long arg2, long arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, long arg1, long arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static void tracef(Throwable t, String format, long arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).tracef(t, format, arg1, arg2, arg3);
    }

    public static boolean isDebugEnabled() {
        if (shouldFail) {
            throw Log.fail();
        }
        return Logger.getLogger(stackWalker.getCallerClass()).isDebugEnabled();
    }

    public static void debug(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debug(message);
    }

    public static void debug(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debug(message, t);
    }

    public static void debug(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debug(loggerFqcn, message, t);
    }

    public static void debug(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debug(loggerFqcn, message, params, t);
    }

    public static void debugv(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(format, params);
    }

    public static void debugv(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(format, param1);
    }

    public static void debugv(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(format, param1, param2);
    }

    public static void debugv(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(format, param1, param2, param3);
    }

    public static void debugv(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(t, format, params);
    }

    public static void debugv(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(t, format, param1);
    }

    public static void debugv(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(t, format, param1, param2);
    }

    public static void debugv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugv(t, format, param1, param2, param3);
    }

    public static void debugf(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, params);
    }

    public static void debugf(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, param1);
    }

    public static void debugf(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, param1, param2);
    }

    public static void debugf(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, param1, param2, param3);
    }

    public static void debugf(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, params);
    }

    public static void debugf(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, param1);
    }

    public static void debugf(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, param1, param2);
    }

    public static void debugf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, param1, param2, param3);
    }

    public static void debugf(String format, int arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg);
    }

    public static void debugf(String format, int arg1, int arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2);
    }

    public static void debugf(String format, int arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2);
    }

    public static void debugf(String format, int arg1, int arg2, int arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(String format, int arg1, int arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(String format, int arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, int arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg);
    }

    public static void debugf(Throwable t, String format, int arg1, int arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2);
    }

    public static void debugf(Throwable t, String format, int arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2);
    }

    public static void debugf(Throwable t, String format, int arg1, int arg2, int arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, int arg1, int arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, int arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static void debugf(String format, long arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg);
    }

    public static void debugf(String format, long arg1, long arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2);
    }

    public static void debugf(String format, long arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2);
    }

    public static void debugf(String format, long arg1, long arg2, long arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(String format, long arg1, long arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(String format, long arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, long arg) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg);
    }

    public static void debugf(Throwable t, String format, long arg1, long arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2);
    }

    public static void debugf(Throwable t, String format, long arg1, Object arg2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2);
    }

    public static void debugf(Throwable t, String format, long arg1, long arg2, long arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, long arg1, long arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static void debugf(Throwable t, String format, long arg1, Object arg2, Object arg3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).debugf(t, format, arg1, arg2, arg3);
    }

    public static boolean isInfoEnabled() {
        if (shouldFail) {
            throw Log.fail();
        }
        return Logger.getLogger(stackWalker.getCallerClass()).isInfoEnabled();
    }

    public static void info(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).info(message);
    }

    public static void info(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).info(message, t);
    }

    public static void info(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).info(loggerFqcn, message, t);
    }

    public static void info(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).info(loggerFqcn, message, params, t);
    }

    public static void infov(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(format, params);
    }

    public static void infov(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(format, param1);
    }

    public static void infov(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(format, param1, param2);
    }

    public static void infov(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(format, param1, param2, param3);
    }

    public static void infov(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(t, format, params);
    }

    public static void infov(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(t, format, param1);
    }

    public static void infov(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(t, format, param1, param2);
    }

    public static void infov(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infov(t, format, param1, param2, param3);
    }

    public static void infof(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(format, params);
    }

    public static void infof(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(format, param1);
    }

    public static void infof(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(format, param1, param2);
    }

    public static void infof(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(format, param1, param2, param3);
    }

    public static void infof(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(t, format, params);
    }

    public static void infof(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(t, format, param1);
    }

    public static void infof(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(t, format, param1, param2);
    }

    public static void infof(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).infof(t, format, param1, param2, param3);
    }

    public static void warn(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warn(message);
    }

    public static void warn(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warn(message, t);
    }

    public static void warn(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warn(loggerFqcn, message, t);
    }

    public static void warn(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warn(loggerFqcn, message, params, t);
    }

    public static void warnv(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(format, params);
    }

    public static void warnv(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(format, param1);
    }

    public static void warnv(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(format, param1, param2);
    }

    public static void warnv(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(format, param1, param2, param3);
    }

    public static void warnv(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(t, format, params);
    }

    public static void warnv(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(t, format, param1);
    }

    public static void warnv(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(t, format, param1, param2);
    }

    public static void warnv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnv(t, format, param1, param2, param3);
    }

    public static void warnf(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(format, params);
    }

    public static void warnf(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(format, param1);
    }

    public static void warnf(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(format, param1, param2);
    }

    public static void warnf(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(format, param1, param2, param3);
    }

    public static void warnf(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(t, format, params);
    }

    public static void warnf(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(t, format, param1);
    }

    public static void warnf(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(t, format, param1, param2);
    }

    public static void warnf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).warnf(t, format, param1, param2, param3);
    }

    public static void error(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).error(message);
    }

    public static void error(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).error(message, t);
    }

    public static void error(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).error(loggerFqcn, message, t);
    }

    public static void error(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).error(loggerFqcn, message, params, t);
    }

    public static void errorv(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(format, params);
    }

    public static void errorv(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(format, param1);
    }

    public static void errorv(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(format, param1, param2);
    }

    public static void errorv(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(format, param1, param2, param3);
    }

    public static void errorv(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(t, format, params);
    }

    public static void errorv(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(t, format, param1);
    }

    public static void errorv(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(t, format, param1, param2);
    }

    public static void errorv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorv(t, format, param1, param2, param3);
    }

    public static void errorf(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(format, params);
    }

    public static void errorf(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(format, param1);
    }

    public static void errorf(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(format, param1, param2);
    }

    public static void errorf(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(format, param1, param2, param3);
    }

    public static void errorf(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(t, format, params);
    }

    public static void errorf(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(t, format, param1);
    }

    public static void errorf(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(t, format, param1, param2);
    }

    public static void errorf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).errorf(t, format, param1, param2, param3);
    }

    public static void fatal(Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatal(message);
    }

    public static void fatal(Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatal(message, t);
    }

    public static void fatal(String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatal(loggerFqcn, message, t);
    }

    public static void fatal(String loggerFqcn, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatal(loggerFqcn, message, params, t);
    }

    public static void fatalv(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(format, params);
    }

    public static void fatalv(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(format, param1);
    }

    public static void fatalv(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(format, param1, param2);
    }

    public static void fatalv(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(format, param1, param2, param3);
    }

    public static void fatalv(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(t, format, params);
    }

    public static void fatalv(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(t, format, param1);
    }

    public static void fatalv(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(t, format, param1, param2);
    }

    public static void fatalv(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalv(t, format, param1, param2, param3);
    }

    public static void fatalf(String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(format, params);
    }

    public static void fatalf(String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(format, param1);
    }

    public static void fatalf(String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(format, param1, param2);
    }

    public static void fatalf(String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(format, param1, param2, param3);
    }

    public static void fatalf(Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(t, format, params);
    }

    public static void fatalf(Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(t, format, param1);
    }

    public static void fatalf(Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(t, format, param1, param2);
    }

    public static void fatalf(Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).fatalf(t, format, param1, param2, param3);
    }

    public static void log(Logger.Level level, Object message) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).log(level, message);
    }

    public static void log(Logger.Level level, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).log(level, message, t);
    }

    public static void log(Logger.Level level, String loggerFqcn, Object message, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).log(level, loggerFqcn, message, t);
    }

    public static void log(String loggerFqcn, Logger.Level level, Object message, Object[] params, Throwable t) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).log(loggerFqcn, level, message, params, t);
    }

    public static void logv(Logger.Level level, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, format, params);
    }

    public static void logv(Logger.Level level, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, format, param1);
    }

    public static void logv(Logger.Level level, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, format, param1, param2);
    }

    public static void logv(Logger.Level level, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, format, param1, param2, param3);
    }

    public static void logv(Logger.Level level, Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, t, format, params);
    }

    public static void logv(Logger.Level level, Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, t, format, param1);
    }

    public static void logv(Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, t, format, param1, param2);
    }

    public static void logv(Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(level, t, format, param1, param2, param3);
    }

    public static void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(loggerFqcn, level, t, format, params);
    }

    public static void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(loggerFqcn, level, t, format, param1);
    }

    public static void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(loggerFqcn, level, t, format, param1, param2);
    }

    public static void logv(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logv(loggerFqcn, level, t, format, param1, param2, param3);
    }

    public static void logf(Logger.Level level, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, format, params);
    }

    public static void logf(Logger.Level level, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, format, param1);
    }

    public static void logf(Logger.Level level, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, format, param1, param2);
    }

    public static void logf(Logger.Level level, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, format, param1, param2, param3);
    }

    public static void logf(Logger.Level level, Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, t, format, params);
    }

    public static void logf(Logger.Level level, Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, t, format, param1);
    }

    public static void logf(Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, t, format, param1, param2);
    }

    public static void logf(Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(level, t, format, param1, param2, param3);
    }

    public static void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(loggerFqcn, level, t, format, param1);
    }

    public static void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(loggerFqcn, level, t, format, param1, param2);
    }

    public static void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object param1, Object param2, Object param3) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(loggerFqcn, level, t, format, param1, param2, param3);
    }

    public static void logf(String loggerFqcn, Logger.Level level, Throwable t, String format, Object ... params) {
        if (shouldFail) {
            throw Log.fail();
        }
        Logger.getLogger(stackWalker.getCallerClass()).logf(loggerFqcn, level, t, format, params);
    }

    private static UnsupportedOperationException fail() {
        return new UnsupportedOperationException("Using io.quarkus.logging.Log is only possible with Quarkus bytecode transformation; make sure the archive is indexed, for example by including a beans.xml file");
    }
}

