/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime;

public enum LaunchMode {
    NORMAL("prod", "quarkus.profile"),
    DEVELOPMENT("dev", "quarkus.profile"),
    TEST("test", "quarkus.test.profile");

    private final String defaultProfile;
    private final String profileKey;
    private static volatile LaunchMode launchMode;

    public boolean isDevOrTest() {
        return this != NORMAL;
    }

    public static boolean isDev() {
        return LaunchMode.current() == DEVELOPMENT;
    }

    public static boolean isRemoteDev() {
        return LaunchMode.current() == DEVELOPMENT && "true".equals(System.getenv("QUARKUS_LAUNCH_DEVMODE"));
    }

    private LaunchMode(String defaultProfile, String profileKey) {
        this.defaultProfile = defaultProfile;
        this.profileKey = profileKey;
    }

    public String getDefaultProfile() {
        return this.defaultProfile;
    }

    public String getProfileKey() {
        return this.profileKey;
    }

    public static void set(LaunchMode mode) {
        launchMode = mode;
    }

    public static LaunchMode current() {
        return launchMode;
    }

    static {
        launchMode = NORMAL;
    }
}

