/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.graal;

import io.quarkus.logging.Log;
import java.util.Arrays;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public final class GraalVM {

    public static enum Distribution {
        GRAALVM,
        LIBERICA,
        MANDREL;

    }

    public static class Version
    implements Comparable<Version> {
        public static final Version VERSION_23_0_0 = new Version("GraalVM 23.0.0", "23.0.0", "17", Distribution.GRAALVM);
        public static final Version VERSION_23_1_0 = new Version("GraalVM 23.1.0", "23.1.0", "21", Distribution.GRAALVM);
        protected static final Map<String, String> GRAAL_MAPPING = Map.of("21", "23.1", "22", "24.0", "23", "24.1", "24", "24.2", "25", "25.0");
        public static final Version MINIMUM = VERSION_23_0_0;
        public static final Version CURRENT;
        public static final Version MINIMUM_SUPPORTED;
        protected final String fullVersion;
        public final Runtime.Version javaVersion;
        protected final Distribution distribution;
        private int[] versions;
        private String suffix;

        Version(String fullVersion, String version, Distribution distro) {
            this(fullVersion, version, "21", distro);
        }

        Version(String fullVersion, String version, String javaVersion, Distribution distro) {
            this(fullVersion, version, Runtime.Version.parse(javaVersion), distro);
        }

        protected Version(String fullVersion, String version, Runtime.Version javaVersion, Distribution distro) {
            this.fullVersion = fullVersion;
            this.breakdownVersion(version);
            this.javaVersion = javaVersion;
            this.distribution = distro;
        }

        private void breakdownVersion(String version) {
            int dash = version.indexOf(45);
            if (dash != -1) {
                this.suffix = version.substring(dash + 1);
                version = version.substring(0, dash);
            }
            this.versions = Arrays.stream(version.split("\\.")).mapToInt(Integer::parseInt).toArray();
        }

        @Override
        public int compareTo(Version o) {
            return this.compareTo(o.versions);
        }

        @Override
        public int compareTo(int[] versions) {
            int i;
            for (i = 0; i < this.versions.length; ++i) {
                if (i >= versions.length) {
                    if (this.versions[i] == 0) continue;
                    return 1;
                }
                if (this.versions[i] == versions[i]) continue;
                return this.versions[i] - versions[i];
            }
            while (i < versions.length) {
                if (versions[i] != 0) {
                    return -1;
                }
                ++i;
            }
            return 0;
        }

        public String getVersionAsString() {
            String version = Arrays.stream(this.versions).mapToObj(Integer::toString).collect(Collectors.joining("."));
            if (this.suffix != null) {
                return version + "-" + this.suffix;
            }
            return version;
        }

        public String getMajorMinorAsString() {
            if (this.versions.length >= 2) {
                return this.versions[0] + "." + this.versions[1];
            }
            return this.versions[0] + ".0";
        }

        public String toString() {
            return "Version{version=" + this.getVersionAsString() + ", fullVersion=" + this.fullVersion + ", distribution=" + String.valueOf((Object)this.distribution) + ", javaVersion=" + String.valueOf(this.javaVersion) + "}";
        }

        public static Version getCurrent() {
            String vendorVersion = System.getProperty("org.graalvm.vendorversion");
            return VersionParseHelper.parse(vendorVersion);
        }

        static {
            MINIMUM_SUPPORTED = CURRENT = VERSION_23_1_0;
        }
    }

    static final class VersionParseHelper {
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)(?:(?:-(?<PRE>[a-zA-Z0-9]+))?\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String GRAALVM_CE_VERS_PREFIX = "GraalVM CE ";
        private static final String LIBERICA_NIK_VERS_PREFIX = "Liberica-NIK-";
        private static final String MANDREL_VERS_PREFIX = "Mandrel-";
        private static final String ORACLE_GRAALVM_VERS_PREFIX = "Oracle GraalVM ";
        private static final String VENDOR_PREFIX_GROUP = "VENDORPREFIX";
        private static final String VENDOR_PREFIX = "(?<VENDORPREFIX>GraalVM CE |Liberica-NIK-|Mandrel-|Oracle GraalVM )";
        private static final Pattern VENDOR_VERS_PATTERN = Pattern.compile("(?<VENDORPREFIX>GraalVM CE |Liberica-NIK-|Mandrel-|Oracle GraalVM )(?<VNUM>[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)(?:(?:-(?<PRE>[a-zA-Z0-9]+))?\\+(?<BUILD>0|[1-9][0-9]*(?:\\.(?:0|[1-9][0-9]*))*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?");
        private static final String VERSION_GROUP = "VNUM";
        private static final Version UNKNOWN_VERSION = null;

        VersionParseHelper() {
        }

        static Version parse(String value) {
            Matcher versionMatcher = VENDOR_VERS_PATTERN.matcher(value);
            if (versionMatcher.find()) {
                String vendor = versionMatcher.group(VENDOR_PREFIX_GROUP);
                if (GRAALVM_CE_VERS_PREFIX.equals(vendor) || ORACLE_GRAALVM_VERS_PREFIX.equals(vendor)) {
                    String version = versionMatcher.group(VERSION_GROUP);
                    String jdkFeature = version.split("\\.", 2)[0];
                    return new Version(value, Version.GRAAL_MAPPING.get(jdkFeature), Distribution.GRAALVM);
                }
                if (LIBERICA_NIK_VERS_PREFIX.equals(vendor)) {
                    return new Version(value, versionMatcher.group(VERSION_GROUP), Distribution.LIBERICA);
                }
                if (MANDREL_VERS_PREFIX.equals(vendor)) {
                    return new Version(value, versionMatcher.group(VERSION_GROUP), Distribution.MANDREL);
                }
            }
            Log.warnf("Failed to parse GraalVM version from: %s. Defaulting to currently supported version %s ", (Object)value, (Object)Version.CURRENT);
            return Version.CURRENT;
        }
    }
}

