/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.runtime.configuration;

import io.quarkus.runtime.configuration.AbstractDelegatingConfigSource;
import io.quarkus.runtime.configuration.ConfigExpander;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.UnaryOperator;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.wildfly.common.Assert;
import org.wildfly.common.expression.Expression;

public class ExpandingConfigSource
extends AbstractDelegatingConfigSource {
    private static final ThreadLocal<Boolean> NO_EXPAND = new ThreadLocal();
    private final Cache cache;

    public static UnaryOperator<ConfigSource> wrapper(Cache cache) {
        return configSource -> new ExpandingConfigSource((ConfigSource)configSource, cache);
    }

    public ExpandingConfigSource(ConfigSource delegate, Cache cache) {
        super(delegate);
        Assert.checkNotNullParam((String)"cache", (Object)cache);
        this.cache = cache;
    }

    @Override
    public Set<String> getPropertyNames() {
        return this.delegate.getPropertyNames();
    }

    public String getValue(String propertyName) {
        String delegateValue = this.delegate.getValue(propertyName);
        return ExpandingConfigSource.isExpanding() ? this.expand(delegateValue) : delegateValue;
    }

    String expand(String value) {
        return ExpandingConfigSource.expandValue(value, this.cache);
    }

    public void flush() {
        this.cache.flush();
    }

    private static boolean isExpanding() {
        return NO_EXPAND.get() != Boolean.TRUE;
    }

    public static boolean setExpanding(boolean newValue) {
        try {
            boolean bl = NO_EXPAND.get() != Boolean.TRUE;
            return bl;
        }
        finally {
            if (newValue) {
                NO_EXPAND.remove();
            } else {
                NO_EXPAND.set(Boolean.TRUE);
            }
        }
    }

    public static String expandValue(String value, Cache cache) {
        if (value == null) {
            return null;
        }
        Expression compiled = cache.exprCache.computeIfAbsent(value, str -> Expression.compile((String)str, (Expression.Flag[])new Expression.Flag[]{Expression.Flag.LENIENT_SYNTAX, Expression.Flag.NO_TRIM}));
        return compiled.evaluate((BiConsumer)ConfigExpander.INSTANCE);
    }

    public static final class Cache {
        final ConcurrentHashMap<String, Expression> exprCache = new ConcurrentHashMap();

        public void flush() {
            this.exprCache.clear();
        }
    }
}

