/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import io.quarkus.fs.util.ZipUtils;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.time.Instant;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;

class ZipFileSystemArchiveCreator
implements ArchiveCreator {
    private static final Set<String> MANIFESTS = Set.of("META-INF/MANIFEST.MF", "META-INF\\MANIFEST.MF");
    private final FileSystem zipFileSystem;
    private final Map<String, String> addedFiles = new HashMap<String, String>();

    public ZipFileSystemArchiveCreator(Path archivePath, boolean compressed, Instant entryTimestamp) {
        try {
            this.zipFileSystem = compressed ? ZipUtils.createNewReproducibleZipFileSystem((Path)archivePath, (Instant)entryTimestamp) : ZipUtils.createNewReproducibleZipFileSystem((Path)archivePath, Map.of("compressionMethod", "STORED"), (Instant)entryTimestamp);
        }
        catch (IOException e) {
            throw new RuntimeException("Unable to initialize ZipFileSystem: " + String.valueOf(archivePath), e);
        }
    }

    @Override
    public void addManifest(Manifest manifest) throws IOException {
        Path manifestInFsPath = this.zipFileSystem.getPath("META-INF", "MANIFEST.MF");
        this.handleParentDirectories(manifestInFsPath, "Current application");
        try (OutputStream os = Files.newOutputStream(manifestInFsPath, new OpenOption[0]);){
            manifest.write(os);
        }
    }

    @Override
    public void addDirectory(String directory, String source) throws IOException {
        block3: {
            if (this.addedFiles.putIfAbsent(directory, source) != null) {
                return;
            }
            Path targetInFsPath = this.zipFileSystem.getPath(directory, new String[0]);
            try {
                this.handleParentDirectories(targetInFsPath, source);
                Files.createDirectory(targetInFsPath, new FileAttribute[0]);
            }
            catch (FileAlreadyExistsException e) {
                if (Files.isDirectory(targetInFsPath, new LinkOption[0])) break block3;
                throw e;
            }
        }
    }

    @Override
    public void addFile(Path origin, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.putIfAbsent(target, source) != null) {
            return;
        }
        Path targetInFsPath = this.zipFileSystem.getPath(target, new String[0]);
        this.handleParentDirectories(targetInFsPath, source);
        Files.copy(origin, targetInFsPath, StandardCopyOption.REPLACE_EXISTING);
    }

    @Override
    public void addFile(byte[] bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        Path targetInFsPath = this.zipFileSystem.getPath(target, new String[0]);
        this.handleParentDirectories(targetInFsPath, source);
        Files.write(targetInFsPath, bytes, new OpenOption[0]);
        this.addedFiles.put(target, source);
    }

    @Override
    public void addFileIfNotExists(Path origin, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.containsKey(target)) {
            return;
        }
        this.addFile(origin, target, source);
    }

    @Override
    public void addFileIfNotExists(byte[] bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        if (this.addedFiles.containsKey(target)) {
            return;
        }
        this.addFile(bytes, target, source);
    }

    @Override
    public void addFile(List<byte[]> bytes, String target, String source) throws IOException {
        if (MANIFESTS.contains(target)) {
            return;
        }
        this.addFile(ZipFileSystemArchiveCreator.joinWithNewlines(bytes), target, source);
    }

    @Override
    public boolean isMultiVersion() {
        return Files.isDirectory(this.zipFileSystem.getPath("META-INF", "versions"), new LinkOption[0]);
    }

    @Override
    public void makeMultiVersion() throws IOException {
        Path manifestPath = this.zipFileSystem.getPath("META-INF", "MANIFEST.MF");
        Manifest manifest = new Manifest();
        try (InputStream is = Files.newInputStream(manifestPath, new OpenOption[0]);){
            manifest.read(is);
        }
        manifest.getMainAttributes().put(Attributes.Name.MULTI_RELEASE, "true");
        try (OutputStream os = Files.newOutputStream(manifestPath, new OpenOption[0]);){
            manifest.write(os);
        }
    }

    private void handleParentDirectories(Path targetInFsPath, String source) throws IOException {
        if (targetInFsPath.getParent() != null) {
            Files.createDirectories(targetInFsPath.getParent(), new FileAttribute[0]);
        }
    }

    private static byte[] joinWithNewlines(List<byte[]> lines) {
        Object object;
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        try {
            for (byte[] line : lines) {
                out.write(line);
                out.write(10);
            }
            object = out.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    out.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw new RuntimeException("Error joining byte arrays", e);
            }
        }
        out.close();
        return object;
    }

    @Override
    public void close() {
        try {
            this.zipFileSystem.close();
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

