/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import io.quarkus.builder.item.BuildItem;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.ApplicationInfoBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.GeneratedResourceBuildItem;
import io.quarkus.deployment.builditem.MainClassBuildItem;
import io.quarkus.deployment.builditem.TransformedClassesBuildItem;
import io.quarkus.deployment.jvm.ResolvedJVMRequirements;
import io.quarkus.deployment.pkg.JarUnsigner;
import io.quarkus.deployment.pkg.PackageConfig;
import io.quarkus.deployment.pkg.builditem.CurateOutcomeBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.jar.AbstractJarBuilder;
import io.quarkus.deployment.pkg.jar.ArchiveCreator;
import io.quarkus.deployment.pkg.jar.ParallelCommonsCompressArchiveCreator;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.maven.dependency.ResolvedDependency;
import java.io.IOException;
import java.nio.file.FileVisitOption;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ExecutorService;
import java.util.function.Predicate;

public abstract class AbstractLegacyThinJarBuilder<T extends BuildItem>
extends AbstractJarBuilder<T> {
    public AbstractLegacyThinJarBuilder(CurateOutcomeBuildItem curateOutcome, OutputTargetBuildItem outputTarget, ApplicationInfoBuildItem applicationInfo, PackageConfig packageConfig, MainClassBuildItem mainClass, ApplicationArchivesBuildItem applicationArchives, TransformedClassesBuildItem transformedClasses, List<GeneratedClassBuildItem> generatedClasses, List<GeneratedResourceBuildItem> generatedResources, Set<ArtifactKey> removedArtifactKeys, ExecutorService executorService, ResolvedJVMRequirements jvmRequirements) {
        super(curateOutcome, outputTarget, applicationInfo, packageConfig, mainClass, applicationArchives, transformedClasses, generatedClasses, generatedResources, removedArtifactKeys, executorService, jvmRequirements);
    }

    @Override
    public abstract T build() throws IOException;

    protected void doBuild(Path runnerJar, Path libDir) throws IOException {
        try (ParallelCommonsCompressArchiveCreator archiveCreator = new ParallelCommonsCompressArchiveCreator(runnerJar, this.packageConfig.jar().compress(), this.packageConfig.outputTimestamp().orElse(null), this.executorService);){
            HashMap seen = new HashMap();
            StringBuilder classPath = new StringBuilder();
            HashMap<String, List<byte[]>> services = new HashMap<String, List<byte[]>>();
            Collection appDeps = this.curateOutcome.getApplicationModel().getRuntimeDependencies();
            Predicate<String> ignoredEntriesPredicate = AbstractLegacyThinJarBuilder.getThinJarIgnoredEntriesPredicate(this.packageConfig);
            AbstractLegacyThinJarBuilder.copyLibraryJars(archiveCreator, this.outputTarget, this.transformedClasses, libDir, classPath, appDeps, services, ignoredEntriesPredicate, this.removedArtifactKeys);
            ResolvedDependency appArtifact = this.curateOutcome.getApplicationModel().getAppArtifact();
            AbstractLegacyThinJarBuilder.generateManifest(archiveCreator, classPath.toString(), this.packageConfig, appArtifact, this.jvmRequirements, this.mainClass.getClassName(), this.applicationInfo);
            this.copyCommonContent(archiveCreator, services, ignoredEntriesPredicate);
        }
        runnerJar.toFile().setReadable(true, false);
    }

    private static void copyLibraryJars(final ArchiveCreator archiveCreator, OutputTargetBuildItem outputTargetBuildItem, TransformedClassesBuildItem transformedClasses, Path libDir, StringBuilder classPath, Collection<ResolvedDependency> appDeps, final Map<String, List<byte[]>> services, final Predicate<String> ignoredEntriesPredicate, Set<ArtifactKey> removedDependencies) throws IOException {
        for (ResolvedDependency appDep : appDeps) {
            if (!AbstractLegacyThinJarBuilder.includeAppDependency(appDep, outputTargetBuildItem.getIncludedOptionalDependencies(), removedDependencies)) continue;
            for (final Path resolvedDep : appDep.getResolvedPaths()) {
                if (!Files.isDirectory(resolvedDep, new LinkOption[0])) {
                    Path targetPath;
                    String fileName;
                    Set<String> transformedFromThisArchive = transformedClasses.getTransformedFilesByJar().get(resolvedDep);
                    if (transformedFromThisArchive == null || transformedFromThisArchive.isEmpty()) {
                        fileName = appDep.getGroupId() + "." + String.valueOf(resolvedDep.getFileName());
                        targetPath = libDir.resolve(fileName);
                        JarUnsigner.unsignJar(resolvedDep, targetPath);
                        classPath.append(" lib/").append(fileName);
                        continue;
                    }
                    fileName = "modified-" + appDep.getGroupId() + "." + String.valueOf(resolvedDep.getFileName());
                    targetPath = libDir.resolve(fileName);
                    classPath.append(" lib/").append(fileName);
                    JarUnsigner.unsignJar(resolvedDep, targetPath, Predicate.not(transformedFromThisArchive::contains));
                    continue;
                }
                Files.walkFileTree(resolvedDep, EnumSet.of(FileVisitOption.FOLLOW_LINKS), Integer.MAX_VALUE, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                    @Override
                    public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) throws IOException {
                        Path relativePath = resolvedDep.relativize(file);
                        String relativeUri = AbstractJarBuilder.toUri(relativePath);
                        if (ignoredEntriesPredicate.test(relativeUri)) {
                            return FileVisitResult.CONTINUE;
                        }
                        if (relativeUri.startsWith("META-INF/services/") && relativeUri.length() > 18) {
                            services.computeIfAbsent(relativeUri, u -> new ArrayList()).add(Files.readAllBytes(file));
                        } else if (file.getFileName().toString().endsWith(".class")) {
                            archiveCreator.addFile(file, relativePath.toString());
                        }
                        return FileVisitResult.CONTINUE;
                    }
                });
            }
        }
    }

    private static Predicate<String> getThinJarIgnoredEntriesPredicate(PackageConfig packageConfig) {
        return packageConfig.jar().userConfiguredIgnoredEntries().map(Set::copyOf).orElse(Set.of())::contains;
    }
}

