/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.index;

import io.quarkus.deployment.util.IoUtil;
import io.quarkus.paths.OpenPathTree;
import io.quarkus.paths.PathVisit;
import io.quarkus.paths.PathVisitor;
import io.smallrye.common.io.jar.JarFiles;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.ClassSummary;
import org.jboss.jandex.DotName;
import org.jboss.jandex.Index;
import org.jboss.jandex.IndexReader;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Indexer;
import org.jboss.jandex.UnsupportedVersion;
import org.jboss.logging.Logger;

public class IndexingUtil {
    private static final Logger log = Logger.getLogger((String)"io.quarkus.deployment.index");
    public static final DotName OBJECT = DotName.createSimple((String)Object.class.getName());
    public static final String JANDEX_INDEX = "META-INF/jandex.idx";
    private static final String META_INF_VERSIONS = "META-INF/versions/";
    private static final int JAVA_VERSION = Runtime.version().feature();
    private static final int REQUIRED_INDEX_VERSION = 11;

    public static Index indexJar(Path path) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), Collections.emptySet());
    }

    public static Index indexJar(File file) throws IOException {
        return IndexingUtil.indexJar(file, Collections.emptySet());
    }

    public static Index indexJar(Path path, Set<String> removed) throws IOException {
        return IndexingUtil.indexJar(path.toFile(), removed);
    }

    public static Index indexTree(OpenPathTree tree, Set<String> removed) throws IOException {
        Index i;
        if (removed == null && (i = (Index)tree.apply(JANDEX_INDEX, (Function)new MetaInfJandexReader(tree.toString()))) != null) {
            return i;
        }
        Indexer indexer = new Indexer();
        PathTreeIndexer treeIndexer = new PathTreeIndexer(indexer, removed);
        tree.walk((PathVisitor)treeIndexer);
        return indexer.complete();
    }

    /*
     * Exception decompiling
     */
    public static Index indexJar(File file, Set<String> removed) throws IOException {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private static Index indexJar(JarFile file, Set<String> removed) throws IOException {
        Indexer indexer = new Indexer();
        Enumeration<JarEntry> e = file.entries();
        boolean multiRelease = JarFiles.isMultiRelease((JarFile)file);
        while (e.hasMoreElements()) {
            JarEntry entry = e.nextElement();
            if (removed != null && removed.contains(entry.getName()) || !entry.getName().endsWith(".class")) continue;
            if (multiRelease && entry.getName().startsWith(META_INF_VERSIONS)) {
                String part = entry.getName().substring(META_INF_VERSIONS.length());
                int slash = part.indexOf("/");
                if (slash == -1) continue;
                try {
                    int ver = Integer.parseInt(part.substring(0, slash));
                    if (ver > JAVA_VERSION) continue;
                    try (InputStream inputStream = file.getInputStream(entry);){
                        indexer.index(inputStream);
                    }
                }
                catch (NumberFormatException ex) {
                    log.debug((Object)"Failed to parse META-INF/versions entry", (Throwable)ex);
                }
                continue;
            }
            InputStream inputStream = file.getInputStream(entry);
            try {
                indexer.index(inputStream);
            }
            finally {
                if (inputStream == null) continue;
                inputStream.close();
            }
        }
        return indexer.complete();
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader) {
        IndexingUtil.indexClass(className, indexer, quarkusIndex, additionalIndex, new HashSet<DotName>(), classLoader);
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, Set<DotName> knownMissingClasses, ClassLoader classLoader) {
        Set annotationNames;
        DotName superclassName;
        block21: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            ClassInfo classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (InputStream stream = IoUtil.readClass(classLoader, className);){
                    if (stream == null) {
                        throw new IllegalStateException("Failed to index: " + className + ", class not present in class loader: " + String.valueOf(classLoader));
                    }
                    ClassSummary summary = indexer.indexWithSummary(stream);
                    additionalIndex.add(summary.name());
                    superclassName = summary.superclassName();
                    annotationNames = summary.annotations();
                    break block21;
                }
                catch (Exception e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
            superclassName = classInfo.superName();
            annotationNames = classInfo.annotationsMap().keySet();
        }
        for (DotName annotationName : annotationNames) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        knownMissingClasses.add(annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    IndexingUtil.indexClass(annotationName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
        if (superclassName != null && !superclassName.equals((Object)OBJECT)) {
            IndexingUtil.indexClass(superclassName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
        }
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, ClassLoader classLoader, byte[] beanData) {
        IndexingUtil.indexClass(className, indexer, quarkusIndex, additionalIndex, new HashSet<DotName>(), classLoader, beanData);
    }

    public static void indexClass(String className, Indexer indexer, IndexView quarkusIndex, Set<DotName> additionalIndex, Set<DotName> knownMissingClasses, ClassLoader classLoader, byte[] beanData) {
        Set annotationNames;
        block18: {
            DotName classDotName = DotName.createSimple((String)className);
            if (additionalIndex.contains(classDotName)) {
                return;
            }
            ClassInfo classInfo = quarkusIndex.getClassByName(classDotName);
            if (classInfo == null) {
                log.debugf("Index class: %s", (Object)className);
                try (ByteArrayInputStream stream = new ByteArrayInputStream(beanData);){
                    ClassSummary summary = indexer.indexWithSummary((InputStream)stream);
                    additionalIndex.add(summary.name());
                    annotationNames = summary.annotations();
                    break block18;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Failed to index: " + className, e);
                }
            }
            additionalIndex.add(classDotName);
            annotationNames = classInfo.annotationsMap().keySet();
        }
        for (DotName annotationName : annotationNames) {
            if (additionalIndex.contains(annotationName) || quarkusIndex.getClassByName(annotationName) != null) continue;
            try {
                InputStream annotationStream = IoUtil.readClass(classLoader, annotationName.toString());
                try {
                    if (annotationStream == null) {
                        log.debugf("Could not index annotation: %s (missing class or dependency)", (Object)annotationName);
                        knownMissingClasses.add(annotationName);
                        continue;
                    }
                    log.debugf("Index annotation: %s", (Object)annotationName);
                    IndexingUtil.indexClass(annotationName.toString(), indexer, quarkusIndex, additionalIndex, knownMissingClasses, classLoader);
                    additionalIndex.add(annotationName);
                }
                finally {
                    if (annotationStream == null) continue;
                    annotationStream.close();
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("Failed to index: " + className, e);
            }
        }
    }

    private static class MetaInfJandexReader
    implements Function<PathVisit, Index> {
        private final String treeDescription;

        MetaInfJandexReader(String treeDescription) {
            this.treeDescription = treeDescription;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public Index apply(PathVisit visit) {
            if (visit == null) {
                return null;
            }
            try (InputStream in = Files.newInputStream(visit.getPath(), new OpenOption[0]);){
                IndexReader reader = new IndexReader(in);
                try {
                    int indexVersion = reader.getIndexVersion();
                    if (indexVersion < 11) {
                        log.warnf("Reindexing %s, at least Jandex 3.0 must be used to index an application dependency (index version is %s)", (Object)this.treeDescription, (Object)indexVersion);
                        Index index = null;
                        return index;
                    }
                }
                catch (UnsupportedVersion e) {
                    log.warnf("Reindexing %s, the index format is too new for the Jandex version used by your application. Please report it to the author of this JAR (%s)", (Object)this.treeDescription, (Object)e.getMessage());
                    Index index = null;
                    return index;
                }
                Index index = reader.read();
                return index;
            }
            catch (IOException e) {
                throw new UncheckedIOException("Can't read Jandex index from " + this.treeDescription, e);
            }
        }
    }

    private static class PathTreeIndexer
    implements PathVisitor {
        final Indexer indexer;
        final Set<String> removed;

        PathTreeIndexer(Indexer indexer, Set<String> removed) {
            this.indexer = indexer;
            this.removed = removed;
        }

        public void visitPath(PathVisit visit) {
            Path fileName = visit.getPath().getFileName();
            if (fileName == null || !fileName.toString().endsWith(".class") || Files.isDirectory(visit.getPath(), new LinkOption[0]) || this.removed != null && this.removed.contains(visit.getRelativePath("/"))) {
                return;
            }
            try (InputStream inputStream = Files.newInputStream(visit.getPath(), new OpenOption[0]);){
                this.indexer.index(inputStream);
            }
            catch (IOException e) {
                throw new UncheckedIOException(e);
            }
        }
    }
}

