/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.builditem.nativeimage.NativeMinimalJavaVersionBuildItem;
import io.quarkus.runtime.graal.GraalVM;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public final class GraalVM {

    public static final class Version
    extends GraalVM.Version {
        private static final Map<String, String> GRAAL_MAPPING = GraalVM.Version.GRAAL_MAPPING;
        public static final Version VERSION_23_1_0 = new Version("GraalVM 23.1.0", "23.1.0", "21", GraalVM.Distribution.GRAALVM);
        public static final Version VERSION_24_0_0 = new Version("GraalVM 24.0.0", "24.0.0", "22", GraalVM.Distribution.GRAALVM);
        public static final Version VERSION_24_0_999 = new Version("GraalVM 24.0.999", "24.0.999", "22", GraalVM.Distribution.GRAALVM);
        public static final Version VERSION_24_1_0 = new Version("GraalVM 24.1.0", "24.1.0", "23", GraalVM.Distribution.GRAALVM);
        public static final Version VERSION_24_1_999 = new Version("GraalVM 24.1.999", "24.1.999", "23", GraalVM.Distribution.GRAALVM);
        public static final Version VERSION_24_2_0 = new Version("GraalVM 24.2.0", "24.2.0", "24", GraalVM.Distribution.GRAALVM);
        private static final Version VERSION_25_0_0 = new Version("GraalVM 25.0.0", "25.0.0", "25", GraalVM.Distribution.GRAALVM);
        @Deprecated
        public static final Version MINIMUM = VERSION_23_1_0;
        @Deprecated
        public static final Version CURRENT = VERSION_25_0_0;
        @Deprecated
        public static final Version MINIMUM_SUPPORTED = MINIMUM;

        Version(String fullVersion, String version, GraalVM.Distribution distro) {
            this(fullVersion, version, "11", distro);
        }

        Version(String fullVersion, String version, String javaVersion, GraalVM.Distribution distro) {
            this(fullVersion, version, Runtime.Version.parse(javaVersion), distro);
        }

        Version(String fullVersion, String version, Runtime.Version javaVersion, GraalVM.Distribution distro) {
            super(fullVersion, version, javaVersion, distro);
        }

        public int compareTo(Version o) {
            return this.compareTo(o);
        }

        GraalVM.Distribution getDistribution() {
            return this.distribution;
        }

        String getFullVersion() {
            return this.fullVersion;
        }

        boolean isObsolete() {
            return this.compareTo(GraalVM.Version.MINIMUM) < 0;
        }

        boolean isSupported() {
            return this.compareTo(GraalVM.Version.MINIMUM_SUPPORTED) >= 0;
        }

        boolean isNewerThan(Version version) {
            return this.compareTo(version) > 0;
        }

        boolean isOlderThan(Version version) {
            return this.compareTo(version) < 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(NativeMinimalJavaVersionBuildItem javaVersionBuildItem) {
            return this.javaVersion.compareToIgnoreOptional(javaVersionBuildItem.minVersion) >= 0;
        }

        public boolean jdkVersionGreaterOrEqualTo(String version) {
            return this.javaVersion.compareToIgnoreOptional(Runtime.Version.parse(version)) >= 0;
        }

        public static Version of(Stream<String> output) {
            Version parsedVersion;
            String stringOutput = output.collect(Collectors.joining("\n"));
            List<String> lines = stringOutput.lines().dropWhile(l -> !l.startsWith("GraalVM") && !l.startsWith("native-image")).toList();
            if (lines.size() == 3 && (parsedVersion = VersionParseHelper.parse(lines)) != VersionParseHelper.UNKNOWN_VERSION) {
                return parsedVersion;
            }
            throw new IllegalArgumentException("Cannot parse version from output: \n" + stringOutput);
        }

        public boolean isJava17() {
            return this.javaVersion.feature() == 17;
        }
    }

    static final class VersionParseHelper {
        private static final String EA_BUILD_PREFIX = "-ea";
        private static final String JVMCI_BUILD_PREFIX = "jvmci-";
        private static final String MANDREL_VERS_PREFIX = "Mandrel-";
        private static final String GRAALVM_VERS_PREFIX = "GraalVM CE ";
        private static final String LIBERICA_NIK_VERS_PREFIX = "Liberica-NIK-";
        private static final String VNUM = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)";
        private static final String PRE = "(?:-(?<PRE>[a-zA-Z0-9]+))?";
        private static final String BUILD = "(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?";
        private static final String OPT = "(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VSTR_FORMAT = "(?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))?";
        private static final String VENDOR_VERSION_GROUP = "VENDOR";
        private static final String BUILD_INFO_GROUP = "BUILDINFO";
        private static final String VENDOR_VERS = "(?<VENDOR>.*)";
        private static final String JDK_DEBUG = "[^\\)]*";
        private static final String RUNTIME_NAME = "(?<RUNTIME>(?:.*) Runtime Environment) ";
        private static final String BUILD_INFO = "(?<BUILDINFO>.*)";
        private static final String VM_NAME = "(?<VM>(?:.*) VM) ";
        private static final String FIRST_LINE_PATTERN = "native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$";
        private static final String SECOND_LINE_PATTERN = "(?<RUNTIME>(?:.*) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$";
        private static final String THIRD_LINE_PATTERN = "(?<VM>(?:.*) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$";
        private static final Pattern FIRST_PATTERN = Pattern.compile("native-image (?<VNUM>[1-9][0-9]*(?:(?:\\.0)*\\.[1-9][0-9]*)*)(?:-(?<PRE>[a-zA-Z0-9]+))?(?:(?<PLUS>\\+)(?<BUILD>0|[1-9][0-9]*)?)?(?:-(?<OPT>[-a-zA-Z0-9.]+))? .*$");
        private static final Pattern SECOND_PATTERN = Pattern.compile("(?<RUNTIME>(?:.*) Runtime Environment) (?<VENDOR>.*) \\([^\\)]*build (?<BUILDINFO>.*)\\)$");
        private static final Pattern THIRD_PATTERN = Pattern.compile("(?<VM>(?:.*) VM) (?<VENDOR>.*) \\([^\\)]*build .*\\)$");
        private static final String VERS_FORMAT = "(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)";
        private static final String VERSION_GROUP = "VERSION";
        private static final Pattern VERSION_PATTERN = Pattern.compile("(?<VERSION>[1-9][0-9]*(\\.[0-9]+)+(-dev\\p{XDigit}*)?)");
        private static final Version UNKNOWN_VERSION = null;

        VersionParseHelper() {
        }

        static Version parse(List<String> lines) {
            Matcher firstMatcher = FIRST_PATTERN.matcher(lines.get(0));
            Matcher secondMatcher = SECOND_PATTERN.matcher(lines.get(1));
            Matcher thirdMatcher = THIRD_PATTERN.matcher(lines.get(2));
            if (firstMatcher.find() && secondMatcher.find() && thirdMatcher.find()) {
                Object versNum;
                GraalVM.Distribution dist;
                Runtime.Version v;
                String javaVersion = secondMatcher.group(BUILD_INFO_GROUP);
                try {
                    v = Runtime.Version.parse(javaVersion);
                }
                catch (IllegalArgumentException e) {
                    return UNKNOWN_VERSION;
                }
                String vendorVersion = secondMatcher.group(VENDOR_VERSION_GROUP);
                Object graalVersion = VersionParseHelper.graalVersion(javaVersion, v, vendorVersion);
                if (vendorVersion.contains("-dev")) {
                    graalVersion = (String)graalVersion + "-dev";
                }
                if (VersionParseHelper.isMandrel(vendorVersion)) {
                    dist = GraalVM.Distribution.MANDREL;
                    versNum = VersionParseHelper.mandrelVersion(vendorVersion);
                } else if (VersionParseHelper.isLiberica(vendorVersion)) {
                    dist = GraalVM.Distribution.LIBERICA;
                    versNum = VersionParseHelper.libericaVersion(vendorVersion);
                } else {
                    dist = GraalVM.Distribution.GRAALVM;
                    versNum = graalVersion;
                }
                if (versNum == null) {
                    return UNKNOWN_VERSION;
                }
                return new Version(String.join((CharSequence)"\n", lines), (String)versNum, v, dist);
            }
            return UNKNOWN_VERSION;
        }

        private static boolean isLiberica(String vendorVersion) {
            if (vendorVersion == null) {
                return false;
            }
            return !vendorVersion.isBlank() && vendorVersion.startsWith(LIBERICA_NIK_VERS_PREFIX);
        }

        private static String libericaVersion(String vendorVersion) {
            if (vendorVersion == null) {
                return null;
            }
            String version = VersionParseHelper.buildVersion(vendorVersion, LIBERICA_NIK_VERS_PREFIX);
            if (version == null) {
                return null;
            }
            return VersionParseHelper.matchVersion(version);
        }

        private static boolean isMandrel(String vendorVersion) {
            if (vendorVersion == null) {
                return false;
            }
            return !vendorVersion.isBlank() && vendorVersion.startsWith(MANDREL_VERS_PREFIX);
        }

        private static String mandrelVersion(String vendorVersion) {
            if (vendorVersion == null) {
                return null;
            }
            String version = VersionParseHelper.buildVersion(vendorVersion, MANDREL_VERS_PREFIX);
            if (version == null) {
                return null;
            }
            return VersionParseHelper.matchVersion(version);
        }

        private static String matchVersion(String version) {
            Matcher versMatcher = VERSION_PATTERN.matcher(version);
            if (versMatcher.find()) {
                return versMatcher.group(VERSION_GROUP);
            }
            return null;
        }

        private static String graalVersion(String buildInfo, Runtime.Version v, String vendorVersion) {
            Matcher versMatcher;
            if (v.feature() >= 25 && vendorVersion != null && !vendorVersion.isBlank() && vendorVersion.startsWith(GRAALVM_VERS_PREFIX)) {
                String versFromVendor = vendorVersion.substring(GRAALVM_VERS_PREFIX.length());
                versFromVendor = versFromVendor.substring(0, versFromVendor.indexOf("+"));
                if (String.valueOf(v.feature()).equals(versFromVendor)) {
                    versFromVendor = String.format("%d.0.0", v.feature());
                }
                if (versFromVendor.endsWith("-dev")) {
                    versFromVendor = versFromVendor.substring(0, versFromVendor.length() - 4);
                }
                if ((versMatcher = VERSION_PATTERN.matcher(versFromVendor)).find()) {
                    return VersionParseHelper.matchVersion(versFromVendor);
                }
            }
            if (buildInfo == null) {
                return null;
            }
            String version = VersionParseHelper.buildVersion(buildInfo, JVMCI_BUILD_PREFIX);
            if (version == null && (version = VersionParseHelper.buildVersion(buildInfo, EA_BUILD_PREFIX)) == null) {
                return null;
            }
            versMatcher = VERSION_PATTERN.matcher(version);
            if (versMatcher.find()) {
                return VersionParseHelper.matchVersion(version);
            }
            String fullJDKVersion = String.format("%d.%d.%d", v.feature(), v.interim(), v.update());
            return Version.GRAAL_MAPPING.getOrDefault(Integer.toString(v.feature()), fullJDKVersion);
        }

        private static String buildVersion(String buildInfo, String buildPrefix) {
            int idx = buildInfo.indexOf(buildPrefix);
            if (idx < 0) {
                return null;
            }
            return buildInfo.substring(idx + buildPrefix.length());
        }
    }
}

