/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.IsProduction;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceBuildItem;
import io.quarkus.deployment.builditem.GeneratedFileSystemResourceHandledBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.RuntimeInitializedPackageBuildItem;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.OutputTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeImageFutureDefault;
import io.quarkus.runtime.LaunchMode;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.List;

public class FileSystemResourcesBuildStep {
    @BuildStep(onlyIfNot={IsProduction.class})
    public void notNormalMode(OutputTargetBuildItem outputTargetBuildItem, LaunchModeBuildItem launchMode, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources, BuildProducer<GeneratedFileSystemResourceHandledBuildItem> producer) {
        if (launchMode.getLaunchMode() == LaunchMode.DEVELOPMENT) {
            this.write(generatedFileSystemResources, outputTargetBuildItem.getOutputDirectory());
        }
        producer.produce(new GeneratedFileSystemResourceHandledBuildItem());
    }

    @BuildStep(onlyIf={NativeImageFutureDefault.RunTimeInitializeFileSystemProvider.class})
    RuntimeInitializedPackageBuildItem runtimeInitialized() {
        return new RuntimeInitializedPackageBuildItem("io.quarkus.fs.util");
    }

    @BuildStep(onlyIf={NativeImageFutureDefault.RunTimeInitializeFileSystemProvider.class})
    ReflectiveClassBuildItem setupReflectionClasses() {
        return ReflectiveClassBuildItem.builder("jdk.nio.zipfs.ZipFileSystemProvider").build();
    }

    @BuildStep(onlyIf={IsProduction.class})
    public void normalMode(OutputTargetBuildItem outputTargetBuildItem, List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources, BuildProducer<ArtifactResultBuildItem> dummy) {
        this.write(generatedFileSystemResources, outputTargetBuildItem.getOutputDirectory());
    }

    private void write(List<GeneratedFileSystemResourceBuildItem> generatedFileSystemResources, Path outputDirectory) {
        try {
            for (GeneratedFileSystemResourceBuildItem generatedFileSystemResource : generatedFileSystemResources) {
                Path outputPath = outputDirectory.resolve(generatedFileSystemResource.getName());
                Files.createDirectories(outputPath.getParent(), new FileAttribute[0]);
                OutputStream out = Files.newOutputStream(outputPath, new OpenOption[0]);
                try {
                    out.write(generatedFileSystemResource.getData());
                }
                finally {
                    if (out == null) continue;
                    out.close();
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }
}

