/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.jar;

import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.jar.Manifest;

public interface ArchiveCreator
extends AutoCloseable {
    public static final String UNKNOWN_SOURCE = "Unknown source";
    public static final String CURRENT_APPLICATION = "Current application";

    public void addManifest(Manifest var1) throws IOException;

    public void addDirectory(String var1, String var2) throws IOException;

    public void addFile(Path var1, String var2, String var3) throws IOException;

    public void addFile(byte[] var1, String var2, String var3) throws IOException;

    public void addFileIfNotExists(Path var1, String var2, String var3) throws IOException;

    public void addFileIfNotExists(byte[] var1, String var2, String var3) throws IOException;

    public void addFile(List<byte[]> var1, String var2, String var3) throws IOException;

    default public void addDirectory(String directory) throws IOException {
        this.addDirectory(directory, UNKNOWN_SOURCE);
    }

    default public void addFile(Path origin, String target) throws IOException {
        this.addFile(origin, target, UNKNOWN_SOURCE);
    }

    default public void addFile(byte[] bytes, String target) throws IOException {
        this.addFile(bytes, target, UNKNOWN_SOURCE);
    }

    default public void addFileIfNotExists(Path origin, String target) throws IOException {
        this.addFileIfNotExists(origin, target, UNKNOWN_SOURCE);
    }

    default public void addFileIfNotExists(byte[] bytes, String target) throws IOException {
        this.addFileIfNotExists(bytes, target, UNKNOWN_SOURCE);
    }

    default public void addFile(List<byte[]> bytes, String target) throws IOException {
        this.addFile(bytes, target, UNKNOWN_SOURCE);
    }

    public boolean isMultiVersion();

    public void makeMultiVersion() throws IOException;

    @Override
    public void close();
}

