/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.configuration;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveMethodBuildItem;
import io.quarkus.deployment.util.ReflectUtil;
import io.quarkus.hibernate.validator.spi.AdditionalConstrainedClassBuildItem;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.ConfigMappingInterface;
import io.smallrye.config.ConfigMappingLoader;
import io.smallrye.config.ConfigMappings;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import org.jboss.jandex.AnnotationInstance;
import org.jboss.jandex.AnnotationTarget;
import org.jboss.jandex.AnnotationValue;
import org.jboss.jandex.ClassInfo;
import org.jboss.jandex.DotName;
import org.jboss.jandex.IndexView;
import org.jboss.jandex.Type;

public class ConfigMappingUtils {
    public static final DotName CONFIG_MAPPING_NAME = DotName.createSimple((String)ConfigMapping.class.getName());

    private ConfigMappingUtils() {
        throw new UnsupportedOperationException();
    }

    public static void processConfigClasses(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, Map<String, GeneratedClassBuildItem> generatedConfigClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses, DotName configAnnotation) {
        for (AnnotationInstance instance : combinedIndex.getIndex().getAnnotations(configAnnotation)) {
            AnnotationTarget target = instance.target();
            AnnotationValue annotationPrefix = instance.value("prefix");
            if (!target.kind().equals((Object)AnnotationTarget.Kind.CLASS)) continue;
            ConfigMappings.ConfigClass configClass = ConfigMappings.ConfigClass.configClass(ConfigMappingUtils.toClass(target.asClass().name()), (String)Optional.ofNullable(annotationPrefix).map(AnnotationValue::asString).orElse(""));
            if (configItem.getReadResult().getAllMappingsByClass().containsKey(configClass.getType())) continue;
            ConfigClassBuildItem.Kind configClassKind = ConfigMappingUtils.getConfigClassType(instance);
            ConfigMappingUtils.processConfigClass(configClass, configClassKind, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
        }
    }

    public static void processConfigMapping(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, Map<String, GeneratedClassBuildItem> generatedConfigClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses) {
        ConfigMappingUtils.processConfigClasses(configItem, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses, CONFIG_MAPPING_NAME);
    }

    public static void processExtensionConfigMapping(ConfigMappings.ConfigClass configClass, CombinedIndexBuildItem combinedIndex, Map<String, GeneratedClassBuildItem> generatedConfigClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses) {
        ConfigMappingUtils.processConfigClass(configClass, ConfigClassBuildItem.Kind.MAPPING, combinedIndex, generatedConfigClasses, reflectiveClasses, reflectiveMethods, configClasses, additionalConstrainedClasses);
    }

    private static void processConfigClass(ConfigMappings.ConfigClass configClassWithPrefix, ConfigClassBuildItem.Kind configClassKind, CombinedIndexBuildItem combinedIndex, Map<String, GeneratedClassBuildItem> generatedConfigClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ReflectiveMethodBuildItem> reflectiveMethods, BuildProducer<ConfigClassBuildItem> configClasses, BuildProducer<AdditionalConstrainedClassBuildItem> additionalConstrainedClasses) {
        Class configClass = configClassWithPrefix.getType();
        String prefix = configClassWithPrefix.getPrefix();
        List configMappingsMetadata = ConfigMappingLoader.getConfigMappingsMetadata((Class)configClass);
        HashSet<String> generatedClassesNames = new HashSet<String>();
        HashSet configComponentInterfaces = new HashSet();
        configMappingsMetadata.forEach(mappingMetadata -> {
            generatedClassesNames.add(mappingMetadata.getClassName());
            byte[] classBytes = mappingMetadata.getClassBytes();
            generatedConfigClasses.put(mappingMetadata.getClassName(), new GeneratedClassBuildItem(QuarkusClassLoader.isApplicationClass((String)configClass.getName()), mappingMetadata.getClassName(), classBytes));
            additionalConstrainedClasses.produce(AdditionalConstrainedClassBuildItem.of((String)mappingMetadata.getClassName(), (byte[])classBytes));
            reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mappingMetadata.getClassName()).reason(ConfigMappingUtils.class.getName()).build());
            reflectiveMethods.produce(new ReflectiveMethodBuildItem(ConfigMappingUtils.class.getName(), mappingMetadata.getClassName(), "getProperties", new String[0]));
            reflectiveMethods.produce(new ReflectiveMethodBuildItem(ConfigMappingUtils.class.getName(), mappingMetadata.getClassName(), "getSecrets", new String[0]));
            configComponentInterfaces.add(mappingMetadata.getInterfaceType());
            ConfigMappingUtils.processProperties(mappingMetadata.getInterfaceType(), reflectiveClasses);
        });
        configClasses.produce(new ConfigClassBuildItem(configClass, configComponentInterfaces, ConfigMappingUtils.collectTypes(combinedIndex, configClass), generatedClassesNames, prefix, configClassKind));
    }

    private static void processProperties(Class<?> configClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        ConfigMappingInterface mapping = ConfigMappingLoader.getConfigMapping(configClass);
        for (ConfigMappingInterface.Property property : mapping.getProperties()) {
            String reason = ConfigMappingUtils.class.getSimpleName() + " Required to process property " + property.getPropertyName();
            if (property.hasConvertWith()) {
                Class convertWith = property.isLeaf() ? property.asLeaf().getConvertWith() : property.asPrimitive().getConvertWith();
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(convertWith).reason(reason).build());
            }
            ConfigMappingUtils.registerImplicitConverter(property, reason, reflectiveClasses);
            if (!property.isMap()) continue;
            ConfigMappingInterface.MapProperty mapProperty = property.asMap();
            if (mapProperty.hasKeyConvertWith()) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mapProperty.getKeyConvertWith()).reason(reason).build());
            } else {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(mapProperty.getKeyRawType()).reason(reason).build());
            }
            ConfigMappingUtils.registerImplicitConverter(mapProperty.getValueProperty(), reason, reflectiveClasses);
        }
    }

    private static void registerImplicitConverter(ConfigMappingInterface.Property property, String reason, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses) {
        if (property.isLeaf() && !property.isOptional()) {
            ConfigMappingInterface.LeafProperty leafProperty = property.asLeaf();
            if (leafProperty.hasConvertWith()) {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(leafProperty.getConvertWith()).reason(reason).build());
            } else {
                reflectiveClasses.produce(ReflectiveClassBuildItem.builder(leafProperty.getValueRawType()).reason(reason).methods().build());
            }
        } else if (property.isOptional()) {
            ConfigMappingUtils.registerImplicitConverter((ConfigMappingInterface.Property)property.asOptional().getNestedProperty(), reason, reflectiveClasses);
        } else if (property.isCollection()) {
            ConfigMappingUtils.registerImplicitConverter(property.asCollection().getElement(), reason, reflectiveClasses);
        }
    }

    @Deprecated(forRemoval=true, since="3.25")
    public static Object newInstance(Class<?> configClass) {
        if (configClass.isAnnotationPresent(ConfigMapping.class)) {
            return ReflectUtil.newInstance(ConfigMappingLoader.ensureLoaded(configClass).implementation());
        }
        return ReflectUtil.newInstance(configClass);
    }

    private static Class<?> toClass(DotName dotName) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        try {
            return classLoader.loadClass(dotName.toString());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("The class (" + String.valueOf(dotName) + ") cannot be created during deployment.", e);
        }
    }

    private static ConfigClassBuildItem.Kind getConfigClassType(AnnotationInstance instance) {
        if (instance.name().equals((Object)CONFIG_MAPPING_NAME)) {
            return ConfigClassBuildItem.Kind.MAPPING;
        }
        return ConfigClassBuildItem.Kind.PROPERTIES;
    }

    private static Set<Type> collectTypes(CombinedIndexBuildItem combinedIndex, Class<?> configClass) {
        DotName configIfaceName;
        IndexView index = combinedIndex.getIndex();
        ClassInfo configIfaceInfo = index.getClassByName(configIfaceName = DotName.createSimple((String)configClass.getName()));
        if (configIfaceInfo == null || configIfaceInfo.interfaceNames().isEmpty()) {
            return Set.of(Type.create((DotName)configIfaceName, (Type.Kind)Type.Kind.CLASS));
        }
        HashSet<DotName> allIfaces = new HashSet<DotName>();
        allIfaces.add(configIfaceName);
        ConfigMappingUtils.collectInterfacesRec(configIfaceInfo, index, allIfaces);
        HashSet<Type> result = new HashSet<Type>(allIfaces.size());
        for (DotName iface : allIfaces) {
            result.add(Type.create((DotName)iface, (Type.Kind)Type.Kind.CLASS));
        }
        return result;
    }

    private static void collectInterfacesRec(ClassInfo current, IndexView index, Set<DotName> result) {
        List interfaces = current.interfaceNames();
        if (interfaces.isEmpty()) {
            return;
        }
        for (DotName iface : interfaces) {
            ClassInfo classByName = index.getClassByName(iface);
            if (classByName == null) continue;
            result.add(iface);
            ConfigMappingUtils.collectInterfacesRec(classByName, index, result);
        }
    }
}

