/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg;

import io.quarkus.maven.dependency.GACT;
import io.quarkus.runtime.annotations.ConfigDocDefault;
import io.quarkus.runtime.annotations.ConfigDocMapKey;
import io.quarkus.runtime.annotations.ConfigGroup;
import io.quarkus.runtime.annotations.ConfigRoot;
import io.smallrye.config.ConfigMapping;
import io.smallrye.config.WithDefault;
import java.nio.file.Path;
import java.time.Instant;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;

@ConfigMapping(prefix="quarkus.package")
@ConfigRoot
public interface PackageConfig {
    public JarConfig jar();

    public Optional<String> mainClass();

    public Optional<Path> outputDirectory();

    public Optional<String> outputName();

    public Optional<Instant> outputTimestamp();

    @WithDefault(value="false")
    public boolean writeTransformedBytecodeToBuildOutput();

    @WithDefault(value="-runner")
    public String runnerSuffix();

    default public String computedRunnerSuffix() {
        return this.jar().addRunnerSuffix() ? this.runnerSuffix() : "";
    }

    @ConfigGroup
    public static interface JarConfig {
        @WithDefault(value="true")
        public boolean enabled();

        @WithDefault(value="fast-jar")
        public JarType type();

        @ConfigDocDefault(value="true")
        @WithDefault(value="true")
        public boolean compress();

        public ManifestConfig manifest();

        public Optional<List<String>> userConfiguredIgnoredEntries();

        public Optional<Set<GACT>> includedOptionalDependencies();

        @WithDefault(value="false")
        public boolean filterOptionalDependencies();

        @WithDefault(value="true")
        public boolean addRunnerSuffix();

        public AppcdsConfig appcds();

        public Optional<String> userProvidersDirectory();

        @WithDefault(value="true")
        public boolean includeDependencyList();

        public DecompilerConfig decompiler();

        public static enum JarType {
            FAST_JAR("fast-jar", "jar"),
            UBER_JAR("uber-jar"),
            MUTABLE_JAR("mutable-jar"),
            LEGACY_JAR("legacy-jar", "legacy");

            public static final List<JarType> values;
            private static final Map<String, JarType> byName;
            private final List<String> names;

            private JarType(List<String> names) {
                this.names = names;
            }

            private JarType(String ... names) {
                this(List.of(names));
            }

            private JarType(String name) {
                this(List.of(name));
            }

            public List<String> names() {
                return this.names;
            }

            public String toString() {
                return this.names.get(0);
            }

            public static JarType fromString(String value) {
                JarType jarOutputType = byName.get(value);
                if (jarOutputType == null) {
                    throw new IllegalArgumentException("Unknown JAR package type '" + value + "'");
                }
                return jarOutputType;
            }

            static {
                values = List.of(JarType.values());
                byName = values.stream().flatMap(item -> item.names.stream().map(name -> Map.entry(name, item))).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
            }
        }

        @ConfigGroup
        public static interface ManifestConfig {
            @WithDefault(value="true")
            public boolean addImplementationEntries();

            @ConfigDocMapKey(value="attribute-name")
            public Map<String, String> attributes();

            @ConfigDocMapKey(value="section-name")
            public Map<String, Map<String, String>> sections();
        }

        @ConfigGroup
        public static interface AppcdsConfig {
            @WithDefault(value="false")
            public boolean enabled();

            public Optional<String> builderImage();

            @WithDefault(value="true")
            public boolean useContainer();

            @WithDefault(value="false")
            public boolean useAot();
        }
    }

    @ConfigGroup
    public static interface DecompilerConfig {
        @WithDefault(value="false")
        public boolean enabled();

        @WithDefault(value="decompiler")
        public String outputDirectory();

        @WithDefault(value="${user.home}/.quarkus")
        public String jarDirectory();
    }
}

