/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.builder.item.SimpleBuildItem;
import java.util.HashSet;
import java.util.Set;

public final class Capabilities
extends SimpleBuildItem {
    private final Set<String> capabilities;
    private final Set<String> capabilityPrefixes;

    public Capabilities(Set<String> capabilities) {
        this.capabilities = capabilities;
        this.capabilityPrefixes = new HashSet<String>();
        for (String c : capabilities) {
            int i = 0;
            while (i >= 0) {
                if ((i = c.indexOf(46, i + 1)) <= 0) continue;
                this.capabilityPrefixes.add(c.substring(0, i));
            }
            this.capabilityPrefixes.add(c);
        }
    }

    public Set<String> getCapabilities() {
        return this.capabilities;
    }

    public boolean isPresent(String capability) {
        return this.capabilities.contains(capability);
    }

    public boolean isMissing(String capability) {
        return !this.isPresent(capability);
    }

    public boolean isCapabilityWithPrefixPresent(String capabilityPrefix) {
        return this.capabilityPrefixes.contains(capabilityPrefix);
    }

    public boolean isCapabilityWithPrefixMissing(String capabilityPrefix) {
        return !this.isCapabilityWithPrefixPresent(capabilityPrefix);
    }
}

