/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.types;

import io.quarkus.runtime.types.GenericArrayTypeImpl;
import io.quarkus.runtime.types.ParameterizedTypeImpl;
import io.quarkus.runtime.types.WildcardTypeImpl;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Objects;

public class TypeParser {
    private final String str;
    private int pos = 0;

    public static Type parse(String str) {
        return new TypeParser(str).parse();
    }

    private TypeParser(String str) {
        this.str = Objects.requireNonNull(str);
    }

    private Type parse() {
        String token = this.nextToken();
        if (token.isEmpty()) {
            throw this.unexpected(token);
        }
        Type result = token.equals("void") ? Void.TYPE : (this.isPrimitiveType(token) && this.peekToken().isEmpty() ? this.parsePrimitiveType(token) : this.parseReferenceType(token));
        this.expect("");
        return result;
    }

    private Type parseReferenceType(String token) {
        if (this.isPrimitiveType(token)) {
            Type primitive = this.parsePrimitiveType(token);
            return this.parseArrayType(primitive);
        }
        if (this.isClassType(token)) {
            Type result = this.parseClassType(token);
            if (this.peekToken().equals("<")) {
                this.expect("<");
                ArrayList<Type> typeArguments = new ArrayList<Type>();
                typeArguments.add(this.parseTypeArgument());
                while (this.peekToken().equals(",")) {
                    this.expect(",");
                    typeArguments.add(this.parseTypeArgument());
                }
                this.expect(">");
                result = new ParameterizedTypeImpl(result, (Type[])typeArguments.toArray(Type[]::new));
            }
            if (this.peekToken().equals("[")) {
                return this.parseArrayType(result);
            }
            return result;
        }
        throw this.unexpected(token);
    }

    private Type parseArrayType(Type elementType) {
        this.expect("[");
        this.expect("]");
        int dimensions = 1;
        while (this.peekToken().equals("[")) {
            this.expect("[");
            this.expect("]");
            ++dimensions;
        }
        if (elementType instanceof Class) {
            Class clazz = (Class)elementType;
            return this.parseClassType("[".repeat(dimensions) + (String)(clazz.isPrimitive() ? clazz.descriptorString() : "L" + clazz.getName() + ";"));
        }
        Type result = elementType;
        for (int i = 0; i < dimensions; ++i) {
            result = new GenericArrayTypeImpl(result);
        }
        return result;
    }

    private Type parseTypeArgument() {
        String token = this.nextToken();
        if (token.equals("?")) {
            if (this.peekToken().equals("extends")) {
                this.expect("extends");
                Type bound = this.parseReferenceType(this.nextToken());
                return WildcardTypeImpl.withUpperBound((Type)bound);
            }
            if (this.peekToken().equals("super")) {
                this.expect("super");
                Type bound = this.parseReferenceType(this.nextToken());
                return WildcardTypeImpl.withLowerBound((Type)bound);
            }
            return WildcardTypeImpl.defaultInstance();
        }
        return this.parseReferenceType(token);
    }

    private boolean isPrimitiveType(String token) {
        return token.equals("boolean") || token.equals("byte") || token.equals("short") || token.equals("int") || token.equals("long") || token.equals("float") || token.equals("double") || token.equals("char");
    }

    private Type parsePrimitiveType(String token) {
        return switch (token) {
            case "boolean" -> Boolean.TYPE;
            case "byte" -> Byte.TYPE;
            case "short" -> Short.TYPE;
            case "int" -> Integer.TYPE;
            case "long" -> Long.TYPE;
            case "float" -> Float.TYPE;
            case "double" -> Double.TYPE;
            case "char" -> Character.TYPE;
            default -> throw this.unexpected(token);
        };
    }

    private boolean isClassType(String token) {
        return !token.isEmpty() && Character.isJavaIdentifierStart(token.charAt(0));
    }

    private Type parseClassType(String token) {
        try {
            return Class.forName(token, true, Thread.currentThread().getContextClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw new IllegalArgumentException("Unknown class: " + token, e);
        }
    }

    private void expect(String expected) {
        String token = this.nextToken();
        if (!expected.equals(token)) {
            throw this.unexpected(token);
        }
    }

    private IllegalArgumentException unexpected(String token) {
        if (token.isEmpty()) {
            throw new IllegalArgumentException("Unexpected end of input: " + this.str);
        }
        return new IllegalArgumentException("Unexpected token '" + token + "' at position " + (this.pos - token.length()) + ": " + this.str);
    }

    private String peekToken() {
        while (this.pos < this.str.length() && Character.isWhitespace(this.str.charAt(this.pos))) {
            ++this.pos;
        }
        if (this.pos == this.str.length()) {
            return "";
        }
        int pos = this.pos;
        if (this.isSpecial(this.str.charAt(pos))) {
            return this.str.substring(pos, pos + 1);
        }
        int begin = pos;
        while (pos < this.str.length() && Character.isJavaIdentifierStart(this.str.charAt(pos))) {
            while (++pos < this.str.length() && Character.isJavaIdentifierPart(this.str.charAt(pos))) {
            }
            if (pos < this.str.length() && this.str.charAt(pos) == '.') {
                ++pos;
                continue;
            }
            return this.str.substring(begin, pos);
        }
        if (pos == this.str.length()) {
            throw new IllegalArgumentException("Unexpected end of input: " + this.str);
        }
        throw new IllegalArgumentException("Unexpected character '" + this.str.charAt(pos) + "' at position " + pos + ": " + this.str);
    }

    private String nextToken() {
        String result = this.peekToken();
        this.pos += result.length();
        return result;
    }

    private boolean isSpecial(char c) {
        return c == ',' || c == '?' || c == '<' || c == '>' || c == '[' || c == ']';
    }
}

