/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.util;

import io.quarkus.maven.dependency.ArtifactCoords;
import io.quarkus.maven.dependency.ArtifactCoordsPattern;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import io.quarkus.paths.PathVisit;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;

public final class ArtifactResourceResolver {
    private final Collection<ResolvedDependency> artifacts;

    public static ArtifactResourceResolver of(Collection<ResolvedDependency> dependencies, ArtifactCoords artifactCoordinates) {
        return new ArtifactResourceResolver(dependencies, List.of(artifactCoordinates));
    }

    public static ArtifactResourceResolver of(Collection<ResolvedDependency> dependencies, Collection<ArtifactCoords> artifactCoordinatesCollection) {
        return new ArtifactResourceResolver(dependencies, artifactCoordinatesCollection);
    }

    private ArtifactResourceResolver(Collection<ResolvedDependency> dependencies, Collection<ArtifactCoords> artifactCoordinates) {
        List patterns = ArtifactCoordsPattern.toPatterns(artifactCoordinates);
        this.artifacts = patterns.stream().map(p -> ArtifactResourceResolver.findArtifact(dependencies, p)).collect(Collectors.toSet());
    }

    private static ResolvedDependency findArtifact(Collection<ResolvedDependency> dependencies, ArtifactCoordsPattern pattern) {
        return dependencies.stream().filter(arg_0 -> ((ArtifactCoordsPattern)pattern).matches(arg_0)).findFirst().orElseThrow(() -> new IllegalArgumentException("%s artifact not found".formatted(pattern.toString())));
    }

    public Collection<Path> resourcePathList(PathFilter pathFilter) {
        return this.artifacts.stream().map(a -> this.pathsForArtifact((ResolvedDependency)a, pathFilter)).flatMap(Collection::stream).toList();
    }

    private Collection<Path> pathsForArtifact(ResolvedDependency artifact, PathFilter pathFilter) {
        ArrayList<Path> pathList = new ArrayList<Path>();
        PathTree pathTree = artifact.getContentTree(pathFilter);
        pathTree.walk(visit -> pathList.add(this.relativePath(visit)));
        return pathList;
    }

    private Path relativePath(PathVisit visit) {
        Path path = visit.getPath();
        return path.getRoot().relativize(path);
    }

    public List<String> resourceList(PathFilter pathFilter) {
        return this.resourcePathList(pathFilter).stream().map(Path::toString).toList();
    }
}

