package io.quarkus.deployment.builditem.nativeimage;

import io.quarkus.builder.item.SimpleBuildItem;
import io.quarkus.deployment.pkg.NativeConfig;

/**
 * Native configuration generated by native image agent can be integrated
 * directly into subsequence native build steps,
 * if the user enables {@link NativeConfig#agentConfigurationApply()}.
 * This build item is used to transfer the native configuration folder path
 * onto the {@link io.quarkus.deployment.pkg.steps.NativeImageBuildStep}.
 * If the build item is passed,
 * the directory is added to the native image build execution.
 */
public final class NativeImageAgentConfigDirectoryBuildItem extends SimpleBuildItem {
    private final String directory;

    public NativeImageAgentConfigDirectoryBuildItem(String directory) {
        this.directory = directory;
    }

    public String getDirectory() {
        return directory;
    }
}
