/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.pkg.steps;

import io.quarkus.deployment.pkg.NativeConfig;
import io.quarkus.deployment.pkg.steps.LinuxIDUtil;
import io.quarkus.deployment.pkg.steps.NativeImageBuildContainerRunner;
import io.quarkus.deployment.util.ContainerRuntimeUtil;
import io.quarkus.deployment.util.FileUtil;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.commons.lang3.SystemUtils;

public class NativeImageBuildLocalContainerRunner
extends NativeImageBuildContainerRunner {
    public NativeImageBuildLocalContainerRunner(NativeConfig nativeConfig) {
        super(nativeConfig);
        ArrayList<String> containerRuntimeArgs = new ArrayList<String>(Arrays.asList(this.baseContainerRuntimeArgs));
        if (SystemUtils.IS_OS_LINUX && this.containerRuntime.isInWindowsWSL()) {
            containerRuntimeArgs.add("--interactive");
        }
        containerRuntimeArgs.addAll(NativeImageBuildLocalContainerRunner.getVolumeAccessArguments(this.containerRuntime));
        this.baseContainerRuntimeArgs = containerRuntimeArgs.toArray(this.baseContainerRuntimeArgs);
    }

    public static List<String> getVolumeAccessArguments(ContainerRuntimeUtil.ContainerRuntime containerRuntime) {
        ArrayList<String> result = new ArrayList<String>();
        if (SystemUtils.IS_OS_LINUX || SystemUtils.IS_OS_MAC) {
            if (containerRuntime.isDocker() && containerRuntime.isRootless()) {
                Collections.addAll(result, "--user", String.valueOf(0));
            } else {
                String uid = LinuxIDUtil.getLinuxID("-ur");
                String gid = LinuxIDUtil.getLinuxID("-gr");
                if (uid != null && gid != null && !uid.isEmpty() && !gid.isEmpty()) {
                    Collections.addAll(result, "--user", uid + ":" + gid);
                    if (containerRuntime.isPodman() && containerRuntime.isRootless()) {
                        result.add("--userns=keep-id");
                    }
                }
            }
        }
        return result;
    }

    @Override
    protected List<String> getContainerRuntimeBuildArgs(Path outputDir) {
        List<String> containerRuntimeArgs = super.getContainerRuntimeBuildArgs(outputDir);
        String volumeOutputPath = outputDir.toAbsolutePath().toString();
        NativeImageBuildLocalContainerRunner.addVolumeParameter(volumeOutputPath, "/project", containerRuntimeArgs, this.containerRuntime);
        return containerRuntimeArgs;
    }

    public static void addVolumeParameter(String localPath, String remotePath, List<String> args, ContainerRuntimeUtil.ContainerRuntime containerRuntime) {
        if (SystemUtils.IS_OS_WINDOWS) {
            localPath = FileUtil.translateToVolumePath(localPath);
        }
        String selinuxBindOption = SystemUtils.IS_OS_MAC && containerRuntime.isPodman() ? "" : ":z";
        args.add("-v");
        args.add(localPath + ":" + remotePath + selinuxBindOption);
    }
}

