/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.steps;

import io.quarkus.bootstrap.classloading.QuarkusClassLoader;
import io.quarkus.deployment.GeneratedClassGizmoAdaptor;
import io.quarkus.deployment.IsNormal;
import io.quarkus.deployment.annotations.BuildProducer;
import io.quarkus.deployment.annotations.BuildStep;
import io.quarkus.deployment.annotations.ExecutionTime;
import io.quarkus.deployment.annotations.Record;
import io.quarkus.deployment.builditem.ApplicationArchivesBuildItem;
import io.quarkus.deployment.builditem.CombinedIndexBuildItem;
import io.quarkus.deployment.builditem.ConfigClassBuildItem;
import io.quarkus.deployment.builditem.ConfigMappingBuildItem;
import io.quarkus.deployment.builditem.ConfigurationBuildItem;
import io.quarkus.deployment.builditem.ConfigurationTypeBuildItem;
import io.quarkus.deployment.builditem.GeneratedClassBuildItem;
import io.quarkus.deployment.builditem.HotDeploymentWatchedFileBuildItem;
import io.quarkus.deployment.builditem.LaunchModeBuildItem;
import io.quarkus.deployment.builditem.LiveReloadBuildItem;
import io.quarkus.deployment.builditem.QuarkusBuildCloseablesBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.RunTimeConfigurationDefaultBuildItem;
import io.quarkus.deployment.builditem.ShutdownContextBuildItem;
import io.quarkus.deployment.builditem.StaticInitConfigBuilderBuildItem;
import io.quarkus.deployment.builditem.SuppressNonRuntimeConfigChangedWarningBuildItem;
import io.quarkus.deployment.builditem.nativeimage.ReflectiveClassBuildItem;
import io.quarkus.deployment.configuration.BuildTimeConfigurationReader;
import io.quarkus.deployment.configuration.ConfigMappingUtils;
import io.quarkus.deployment.configuration.RunTimeConfigurationGenerator;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingConfig;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingInterceptor;
import io.quarkus.deployment.configuration.tracker.ConfigTrackingWriter;
import io.quarkus.deployment.pkg.builditem.ArtifactResultBuildItem;
import io.quarkus.deployment.pkg.builditem.BuildSystemTargetBuildItem;
import io.quarkus.deployment.pkg.steps.NativeOrNativeSourcesBuild;
import io.quarkus.deployment.recording.RecorderContext;
import io.quarkus.deployment.util.ServiceUtil;
import io.quarkus.gizmo.ClassCreator;
import io.quarkus.gizmo.ClassOutput;
import io.quarkus.gizmo.FieldDescriptor;
import io.quarkus.gizmo.MethodCreator;
import io.quarkus.gizmo.MethodDescriptor;
import io.quarkus.gizmo.ResultHandle;
import io.quarkus.paths.PathCollection;
import io.quarkus.runtime.LaunchMode;
import io.quarkus.runtime.ShutdownContext;
import io.quarkus.runtime.annotations.StaticInitSafe;
import io.quarkus.runtime.configuration.AbstractConfigBuilder;
import io.quarkus.runtime.configuration.ConfigBuilder;
import io.quarkus.runtime.configuration.ConfigDiagnostic;
import io.quarkus.runtime.configuration.ConfigRecorder;
import io.quarkus.runtime.configuration.DisableableConfigSource;
import io.quarkus.runtime.configuration.QuarkusConfigValue;
import io.quarkus.runtime.configuration.RuntimeConfigBuilder;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSource;
import io.quarkus.runtime.configuration.RuntimeOverrideConfigSourceBuilder;
import io.quarkus.runtime.configuration.StaticInitConfigBuilder;
import io.smallrye.config.ConfigMappings;
import io.smallrye.config.ConfigSourceFactory;
import io.smallrye.config.ConfigSourceInterceptor;
import io.smallrye.config.ConfigSourceInterceptorFactory;
import io.smallrye.config.ConfigValue;
import io.smallrye.config.DefaultValuesConfigSource;
import io.smallrye.config.ProfileConfigSourceInterceptor;
import io.smallrye.config.SecretKeysHandler;
import io.smallrye.config.SecretKeysHandlerFactory;
import io.smallrye.config.SmallRyeConfig;
import io.smallrye.config.SmallRyeConfigBuilder;
import io.smallrye.config.SmallRyeConfigBuilderCustomizer;
import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.eclipse.microprofile.config.Config;
import org.eclipse.microprofile.config.ConfigProvider;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;
import org.eclipse.microprofile.config.spi.Converter;

public class ConfigGenerationBuildStep {
    private static final MethodDescriptor CONFIG_BUILDER = MethodDescriptor.ofMethod(ConfigBuilder.class, (String)"configBuilder", SmallRyeConfigBuilder.class, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_SOURCES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withSources", SmallRyeConfigBuilder.class, (Class[])new Class[]{ConfigSource[].class});
    private static final MethodDescriptor MAP_PUT = MethodDescriptor.ofMethod(HashMap.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
    private static final MethodDescriptor SET_ADD = MethodDescriptor.ofMethod(HashSet.class, (String)"add", Boolean.TYPE, (Class[])new Class[]{Object.class});
    private static final MethodDescriptor BUILDER_CUSTOMIZER = MethodDescriptor.ofMethod(SmallRyeConfigBuilderCustomizer.class, (String)"configBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class});
    private static final MethodDescriptor WITH_DEFAULT = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withDefaultValue", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, String.class});
    private static final MethodDescriptor WITH_CONVERTER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withConverter", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, Converter.class});
    private static final MethodDescriptor WITH_INTERCEPTOR = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptor", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptor.class});
    private static final MethodDescriptor WITH_INTERCEPTOR_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withInterceptorFactory", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceInterceptorFactory.class});
    private static final MethodDescriptor WITH_SOURCE = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSource.class});
    private static final MethodDescriptor WITH_SOURCE_PROVIDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceProvider.class});
    private static final MethodDescriptor WITH_SOURCE_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSource", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigSourceFactory.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandler.class});
    private static final MethodDescriptor WITH_SECRET_HANDLER_FACTORY = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withSecretKeyHandler", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SecretKeysHandlerFactory.class});
    private static final MethodDescriptor WITH_MAPPING = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withMapping", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, String.class, String.class});
    private static final MethodDescriptor WITH_CUSTOMIZER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withCustomizer", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, SmallRyeConfigBuilderCustomizer.class});
    private static final MethodDescriptor WITH_BUILDER = MethodDescriptor.ofMethod(AbstractConfigBuilder.class, (String)"withBuilder", Void.TYPE, (Class[])new Class[]{SmallRyeConfigBuilder.class, ConfigBuilder.class});
    private static final MethodDescriptor WITH_NAMES = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withMappingNames", SmallRyeConfigBuilder.class, (Class[])new Class[]{Map.class});
    private static final MethodDescriptor WITH_KEYS = MethodDescriptor.ofMethod(SmallRyeConfigBuilder.class, (String)"withMappingKeys", SmallRyeConfigBuilder.class, (Class[])new Class[]{Set.class});

    @BuildStep
    void buildTimeRunTimeConfig(ConfigurationBuildItem configItem, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        String builderClassName = "io.quarkus.runtime.generated.BuildTimeRunTimeFixedConfigSourceBuilder";
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(builderClassName).interfaces(new Class[]{ConfigBuilder.class}).setFinal(true).build();){
            FieldDescriptor source = FieldDescriptor.of((String)classCreator.getClassName(), (String)"source", ConfigSource.class);
            classCreator.getFieldCreator(source).setModifiers(24);
            MethodCreator clinit = classCreator.getMethodCreator("<clinit>", Void.TYPE, new Class[0]);
            clinit.setModifiers(8);
            ResultHandle map = clinit.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[0]), new ResultHandle[0]);
            MethodDescriptor put = MethodDescriptor.ofMethod(Map.class, (String)"put", Object.class, (Class[])new Class[]{Object.class, Object.class});
            for (Map.Entry<String, String> entry : configItem.getReadResult().getBuildTimeRunTimeValues().entrySet()) {
                clinit.invokeInterfaceMethod(put, map, new ResultHandle[]{clinit.load(entry.getKey()), clinit.load(entry.getValue())});
            }
            ResultHandle defaultValuesSource = clinit.newInstance(MethodDescriptor.ofConstructor(DefaultValuesConfigSource.class, (Class[])new Class[]{Map.class, String.class, Integer.TYPE}), new ResultHandle[]{map, clinit.load("BuildTime RunTime Fixed"), clinit.load(Integer.MAX_VALUE)});
            ResultHandle disableableConfigSource = clinit.newInstance(MethodDescriptor.ofConstructor(DisableableConfigSource.class, (Class[])new Class[]{ConfigSource.class}), new ResultHandle[]{defaultValuesSource});
            clinit.writeStaticField(source, disableableConfigSource);
            clinit.returnVoid();
            MethodCreator method = classCreator.getMethodCreator(CONFIG_BUILDER);
            ResultHandle configBuilder = method.getMethodParam(0);
            ResultHandle configSources = method.newArray(ConfigSource.class, 1);
            method.writeArrayValue(configSources, 0, method.readStaticField(source));
            method.invokeVirtualMethod(WITH_SOURCES, configBuilder, new ResultHandle[]{configSources});
            method.returnValue(configBuilder);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(builderClassName).build());
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(builderClassName));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(builderClassName));
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    void runtimeOverrideConfig(BuildProducer<StaticInitConfigBuilderBuildItem> staticInitConfigBuilder, BuildProducer<RunTimeConfigBuilderBuildItem> runTimeConfigBuilder) {
        staticInitConfigBuilder.produce(new StaticInitConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
        runTimeConfigBuilder.produce(new RunTimeConfigBuilderBuildItem(RuntimeOverrideConfigSourceBuilder.class.getName()));
    }

    @BuildStep
    void generateMappings(ConfigurationBuildItem configItem, CombinedIndexBuildItem combinedIndex, BuildProducer<GeneratedClassBuildItem> generatedClasses, BuildProducer<ReflectiveClassBuildItem> reflectiveClasses, BuildProducer<ConfigClassBuildItem> configClasses) {
        ConfigMappingUtils.processConfigMapping(combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        List<ConfigMappings.ConfigClassWithPrefix> buildTimeRunTimeMappings = configItem.getReadResult().getBuildTimeRunTimeMappings();
        for (ConfigMappings.ConfigClassWithPrefix buildTimeRunTimeMapping : buildTimeRunTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(buildTimeRunTimeMapping, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
        List<ConfigMappings.ConfigClassWithPrefix> runTimeMappings = configItem.getReadResult().getRunTimeMappings();
        for (ConfigMappings.ConfigClassWithPrefix runTimeMapping : runTimeMappings) {
            ConfigMappingUtils.processExtensionConfigMapping(runTimeMapping, combinedIndex, generatedClasses, reflectiveClasses, configClasses);
        }
    }

    @BuildStep
    void generateBuilders(ConfigurationBuildItem configItem, List<ConfigMappingBuildItem> configMappings, List<RunTimeConfigurationDefaultBuildItem> runTimeDefaults, List<StaticInitConfigBuilderBuildItem> staticInitConfigBuilders, List<RunTimeConfigBuilderBuildItem> runTimeConfigBuilders, BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws Exception {
        HashMap<String, String> defaultValues = new HashMap<String, String>();
        for (ConfigMappings.ConfigClassWithPrefix configClassWithPrefix : configItem.getReadResult().getRunTimeMappings()) {
            defaultValues.putAll(ConfigMappings.getDefaults((ConfigMappings.ConfigClassWithPrefix)configClassWithPrefix));
        }
        for (ConfigMappingBuildItem configMappingBuildItem : configMappings) {
            defaultValues.putAll(ConfigMappings.getDefaults((ConfigMappings.ConfigClassWithPrefix)configMappingBuildItem.toConfigClassWithPrefix()));
        }
        defaultValues.putAll(configItem.getReadResult().getRunTimeDefaultValues());
        for (RunTimeConfigurationDefaultBuildItem runTimeConfigurationDefaultBuildItem : runTimeDefaults) {
            defaultValues.put(runTimeConfigurationDefaultBuildItem.getKey(), runTimeConfigurationDefaultBuildItem.getValue());
        }
        String[] profiles = (String[])((SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class)).getProfiles().toArray(String[]::new);
        for (Map.Entry<String, String> entry : configItem.getReadResult().getRunTimeValues().entrySet()) {
            String activeName = ProfileConfigSourceInterceptor.activeName((String)entry.getKey(), (String[])profiles);
            defaultValues.remove(activeName);
            defaultValues.put(entry.getKey(), entry.getValue());
        }
        defaultValues.putAll(configItem.getReadResult().getRunTimeValues());
        Set<String> set = ConfigGenerationBuildStep.discoverService(Converter.class, reflectiveClass);
        Set<String> set2 = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptor.class, reflectiveClass);
        Set<String> interceptorFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceInterceptorFactory.class, reflectiveClass);
        Set<String> configSources = ConfigGenerationBuildStep.discoverService(ConfigSource.class, reflectiveClass);
        Set<String> configSourceProviders = ConfigGenerationBuildStep.discoverService(ConfigSourceProvider.class, reflectiveClass);
        Set<String> configSourceFactories = ConfigGenerationBuildStep.discoverService(ConfigSourceFactory.class, reflectiveClass);
        Set<String> secretKeyHandlers = ConfigGenerationBuildStep.discoverService(SecretKeysHandler.class, reflectiveClass);
        Set<String> secretKeyHandlerFactories = ConfigGenerationBuildStep.discoverService(SecretKeysHandlerFactory.class, reflectiveClass);
        Set<String> configCustomizers = ConfigGenerationBuildStep.discoverService(SmallRyeConfigBuilderCustomizer.class, reflectiveClass);
        HashSet<ConfigMappings.ConfigClassWithPrefix> staticMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        staticMappings.addAll(ConfigGenerationBuildStep.staticSafeConfigMappings(configMappings));
        staticMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        HashSet<String> staticCustomizers = new HashSet<String>(ConfigGenerationBuildStep.staticSafeServices(configCustomizers));
        staticCustomizers.add(StaticInitConfigBuilder.class.getName());
        String staticMappingsInfoClassName = "io.quarkus.runtime.generated.StaticInitMappingsInfo";
        ConfigGenerationBuildStep.generateMappingsInfo(generatedClass, reflectiveClass, staticMappingsInfoClassName, staticMappings);
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.StaticInitConfig", defaultValues, set, set2, ConfigGenerationBuildStep.staticSafeServices(interceptorFactories), ConfigGenerationBuildStep.staticSafeServices(configSources), ConfigGenerationBuildStep.staticSafeServices(configSourceProviders), ConfigGenerationBuildStep.staticSafeServices(configSourceFactories), secretKeyHandlers, ConfigGenerationBuildStep.staticSafeServices(secretKeyHandlerFactories), staticMappingsInfoClassName, staticMappings, staticCustomizers, staticInitConfigBuilders.stream().map(StaticInitConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.StaticInitConfig").build());
        HashSet<ConfigMappings.ConfigClassWithPrefix> runTimeMappings = new HashSet<ConfigMappings.ConfigClassWithPrefix>();
        runTimeMappings.addAll(ConfigGenerationBuildStep.runtimeConfigMappings(configMappings));
        runTimeMappings.addAll(configItem.getReadResult().getBuildTimeRunTimeMappings());
        runTimeMappings.addAll(configItem.getReadResult().getRunTimeMappings());
        HashSet<String> runtimeCustomizers = new HashSet<String>(configCustomizers);
        runtimeCustomizers.add(RuntimeConfigBuilder.class.getName());
        String runtimeMappingsInfoClassName = "io.quarkus.runtime.generated.RunTimeMappingsInfo";
        ConfigGenerationBuildStep.generateMappingsInfo(generatedClass, reflectiveClass, runtimeMappingsInfoClassName, runTimeMappings);
        ConfigGenerationBuildStep.generateConfigBuilder(generatedClass, reflectiveClass, "io.quarkus.runtime.generated.RunTimeConfig", defaultValues, set, set2, interceptorFactories, configSources, configSourceProviders, configSourceFactories, secretKeyHandlers, secretKeyHandlerFactories, runtimeMappingsInfoClassName, runTimeMappings, runtimeCustomizers, runTimeConfigBuilders.stream().map(RunTimeConfigBuilderBuildItem::getBuilderClassName).collect(Collectors.toSet()));
        reflectiveClass.produce(ReflectiveClassBuildItem.builder("io.quarkus.runtime.generated.RunTimeConfig").build());
    }

    @BuildStep
    void generateConfigClass(ConfigurationBuildItem configItem, List<ConfigurationTypeBuildItem> typeItems, LaunchModeBuildItem launchModeBuildItem, BuildProducer<GeneratedClassBuildItem> generatedClass, LiveReloadBuildItem liveReloadBuildItem) {
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            ConfigDiagnostic.unknownProperties(configItem.getReadResult().getUnknownBuildProperties());
        }
        if (liveReloadBuildItem.isLiveReload()) {
            return;
        }
        RunTimeConfigurationGenerator.GenerateOperation.builder().setBuildTimeReadResult(configItem.getReadResult()).setClassOutput(new GeneratedClassGizmoAdaptor(generatedClass, false)).setLaunchMode(launchModeBuildItem.getLaunchMode()).setLiveReloadPossible(launchModeBuildItem.getLaunchMode() == LaunchMode.DEVELOPMENT || launchModeBuildItem.isAuxiliaryApplication()).setAdditionalTypes(typeItems.stream().map(ConfigurationTypeBuildItem::getValueType).collect(Collectors.toList())).build().run();
    }

    @BuildStep
    public void suppressNonRuntimeConfigChanged(BuildProducer<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChanged) {
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.profile"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.uuid"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.default-locale"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.locales"));
        suppressNonRuntimeConfigChanged.produce(new SuppressNonRuntimeConfigChangedWarningBuildItem("quarkus.test.arg-line"));
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void releaseConfigOnShutdown(ShutdownContextBuildItem shutdownContext, ConfigRecorder recorder) {
        recorder.releaseConfig((ShutdownContext)shutdownContext);
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    public void checkForBuildTimeConfigChange(RecorderContext recorderContext, ConfigRecorder recorder, ConfigurationBuildItem configItem, List<SuppressNonRuntimeConfigChangedWarningBuildItem> suppressNonRuntimeConfigChangedWarningItems) {
        recorderContext.registerSubstitution(ConfigValue.class, QuarkusConfigValue.class, QuarkusConfigValue.Substitution.class);
        BuildTimeConfigurationReader.ReadResult readResult = configItem.getReadResult();
        Config config = ConfigProvider.getConfig();
        HashSet<String> excludedConfigKeys = new HashSet<String>(suppressNonRuntimeConfigChangedWarningItems.size());
        for (SuppressNonRuntimeConfigChangedWarningBuildItem item : suppressNonRuntimeConfigChangedWarningItems) {
            excludedConfigKeys.add(item.getConfigKey());
        }
        HashMap<String, org.eclipse.microprofile.config.ConfigValue> values = new HashMap<String, org.eclipse.microprofile.config.ConfigValue>();
        for (Map.Entry<String, String> entry : readResult.getAllBuildTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.putIfAbsent(entry.getKey(), config.getConfigValue(entry.getKey()));
        }
        for (Map.Entry<String, String> entry : readResult.getBuildTimeRunTimeValues().entrySet()) {
            if (excludedConfigKeys.contains(entry.getKey())) continue;
            values.put(entry.getKey(), config.getConfigValue(entry.getKey()));
        }
        recorder.handleConfigChange(values);
    }

    @BuildStep(onlyIfNot={IsNormal.class})
    public void setupConfigOverride(BuildProducer<GeneratedClassBuildItem> generatedClassBuildItemBuildProducer) {
        GeneratedClassGizmoAdaptor classOutput = new GeneratedClassGizmoAdaptor(generatedClassBuildItemBuildProducer, true);
        try (ClassCreator clazz = ClassCreator.builder().classOutput((ClassOutput)classOutput).className(RuntimeOverrideConfigSource.GENERATED_CLASS_NAME).build();){
            clazz.getFieldCreator("CONFIG", Map.class).setModifiers(73);
        }
    }

    @BuildStep
    public void watchConfigFiles(BuildProducer<HotDeploymentWatchedFileBuildItem> watchedFiles) {
        ArrayList<String> configWatchedFiles = new ArrayList<String>();
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        String userDir = System.getProperty("user.dir");
        configWatchedFiles.add("application.properties");
        configWatchedFiles.add("META-INF/microprofile-config.properties");
        configWatchedFiles.add(Paths.get(userDir, ".env").toAbsolutePath().toString());
        configWatchedFiles.add(Paths.get(userDir, "config", "application.properties").toAbsolutePath().toString());
        for (String profile : config.getProfiles()) {
            configWatchedFiles.add(String.format("application-%s.properties", profile));
            configWatchedFiles.add(String.format("META-INF/microprofile-config-%s.properties", profile));
            configWatchedFiles.add(Paths.get(userDir, String.format(".env-%s", profile)).toAbsolutePath().toString());
            configWatchedFiles.add(Paths.get(userDir, "config", String.format("application-%s.properties", profile)).toAbsolutePath().toString());
        }
        Optional optionalLocations = config.getOptionalValues("smallrye.config.locations", URI.class);
        optionalLocations.ifPresent(locations -> {
            for (URI location : locations) {
                Path path;
                Path path2 = path = location.getScheme() != null && location.getScheme().equals("file") ? Paths.get(location) : Paths.get(location.getPath(), new String[0]);
                if (Files.isRegularFile(path, new LinkOption[0])) {
                    configWatchedFiles.add(path.toAbsolutePath().toString());
                    for (String profile : config.getProfiles()) {
                        configWatchedFiles.add(this.appendProfileToFilename(path.toAbsolutePath(), profile));
                    }
                    continue;
                }
                if (!Files.isDirectory(path, new LinkOption[0])) continue;
                try {
                    DirectoryStream<Path> files = Files.newDirectoryStream(path, x$0 -> Files.isRegularFile(x$0, new LinkOption[0]));
                    try {
                        for (Path file : files) {
                            configWatchedFiles.add(file.toAbsolutePath().toString());
                        }
                    }
                    finally {
                        if (files == null) continue;
                        files.close();
                    }
                }
                catch (IOException iOException) {
                }
            }
        });
        for (String configWatchedFile : configWatchedFiles) {
            watchedFiles.produce(new HotDeploymentWatchedFileBuildItem(configWatchedFile));
        }
    }

    @BuildStep
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void unknownConfigFiles(ApplicationArchivesBuildItem applicationArchives, LaunchModeBuildItem launchModeBuildItem, ConfigRecorder configRecorder) throws Exception {
        PathCollection rootDirectories = applicationArchives.getRootArchive().getRootDirectories();
        if (!rootDirectories.isSinglePath()) {
            return;
        }
        HashSet buildTimeFiles = new HashSet();
        buildTimeFiles.addAll(ConfigDiagnostic.configFiles((Path)rootDirectories.getSinglePath()));
        buildTimeFiles.addAll(ConfigDiagnostic.configFilesFromLocations());
        ConfigDiagnostic.unknownConfigFiles(buildTimeFiles);
        if (!launchModeBuildItem.getLaunchMode().isDevOrTest()) {
            configRecorder.unknownConfigFiles();
        }
    }

    @BuildStep(onlyIf={NativeOrNativeSourcesBuild.class})
    @Record(value=ExecutionTime.RUNTIME_INIT)
    void warnDifferentProfileUsedBetweenBuildAndRunTime(ConfigRecorder configRecorder) {
        SmallRyeConfig config = (SmallRyeConfig)ConfigProvider.getConfig().unwrap(SmallRyeConfig.class);
        configRecorder.handleNativeProfileChange(config.getProfiles());
    }

    @BuildStep(onlyIf={IsNormal.class})
    void persistReadConfigOptions(BuildProducer<ArtifactResultBuildItem> dummy, QuarkusBuildCloseablesBuildItem closeables, final LaunchModeBuildItem launchModeBuildItem, final BuildSystemTargetBuildItem buildSystemTargetBuildItem, final ConfigurationBuildItem configBuildItem, final ConfigTrackingConfig configTrackingConfig) {
        final ConfigTrackingInterceptor.ReadOptionsProvider readOptionsProvider = configBuildItem.getReadResult().getReadOptionsProvider();
        if (readOptionsProvider != null) {
            closeables.add(new Closeable(){

                @Override
                public void close() throws IOException {
                    ConfigTrackingWriter.write(readOptionsProvider.getReadOptions(), configTrackingConfig, configBuildItem.getReadResult(), launchModeBuildItem.getLaunchMode(), buildSystemTargetBuildItem.getOutputDirectory());
                }
            });
        }
    }

    private String appendProfileToFilename(Path path, String activeProfile) {
        String pathWithoutExtension = ConfigGenerationBuildStep.getPathWithoutExtension(path);
        return String.format("%s-%s.%s", pathWithoutExtension, activeProfile, ConfigGenerationBuildStep.getFileExtension(path));
    }

    private static String getFileExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.getFileName().toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? "" : fileName.substring(dotIndex + 1);
    }

    private static String getPathWithoutExtension(Path path) {
        Objects.requireNonNull(path, "path should not be null");
        String fileName = path.toString();
        int dotIndex = fileName.lastIndexOf(46);
        return dotIndex == -1 ? fileName : fileName.substring(0, dotIndex);
    }

    private static void generateMappingsInfo(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, String className, Set<ConfigMappings.ConfigClassWithPrefix> mappings) {
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).setFinal(true).build();){
            for (ConfigMappings.ConfigClassWithPrefix mapping : mappings) {
                ConfigGenerationBuildStep.generateMappingNames(classCreator, mapping);
            }
            MethodCreator keys = classCreator.getMethodCreator("keys", Set.class, new Class[0]);
            keys.setModifiers(9);
            ResultHandle set = keys.checkCast(keys.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[0]), new ResultHandle[0]), Set.class);
            for (ConfigMappings.ConfigClassWithPrefix mapping : mappings) {
                for (String key : ConfigMappings.getKeys((ConfigMappings.ConfigClassWithPrefix)mapping)) {
                    keys.invokeVirtualMethod(SET_ADD, set, new ResultHandle[]{keys.load(key)});
                }
            }
            keys.returnValue(set);
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static void generateMappingNames(ClassCreator classCreator, ConfigMappings.ConfigClassWithPrefix mapping) {
        MethodCreator method = classCreator.getMethodCreator(mapping.getKlass().getName().replaceAll("\\.", "_") + "_" + mapping.getPrefix().hashCode(), Map.class, new Class[0]);
        method.setModifiers(9);
        Map properties = ConfigMappings.getNames((ConfigMappings.ConfigClassWithPrefix)mapping);
        ResultHandle map = method.checkCast(method.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(properties.size())}), Map.class);
        for (Map.Entry entry : properties.entrySet()) {
            ResultHandle groups = method.checkCast(method.newInstance(MethodDescriptor.ofConstructor(HashMap.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Map)entry.getValue()).size())}), Map.class);
            for (Map.Entry group : ((Map)entry.getValue()).entrySet()) {
                ResultHandle names = method.checkCast(method.newInstance(MethodDescriptor.ofConstructor(HashSet.class, (Class[])new Class[]{Integer.TYPE}), new ResultHandle[]{method.load(((Set)group.getValue()).size())}), Set.class);
                for (String name : (Set)group.getValue()) {
                    method.invokeVirtualMethod(SET_ADD, names, new ResultHandle[]{method.load(name)});
                }
                method.invokeVirtualMethod(MAP_PUT, groups, new ResultHandle[]{method.load((String)group.getKey()), names});
            }
            method.invokeVirtualMethod(MAP_PUT, map, new ResultHandle[]{method.load((String)entry.getKey()), groups});
        }
        method.returnValue(map);
    }

    private static void generateConfigBuilder(BuildProducer<GeneratedClassBuildItem> generatedClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass, String className, Map<String, String> defaultValues, Set<String> converters, Set<String> interceptors, Set<String> interceptorFactories, Set<String> configSources, Set<String> configSourceProviders, Set<String> configSourceFactories, Set<String> secretKeyHandlers, Set<String> secretKeyHandlerFactories, String mappingsInfoClassName, Set<ConfigMappings.ConfigClassWithPrefix> mappings, Set<String> configCustomizers, Set<String> configBuilders) {
        ResultHandle configBuilder;
        MethodCreator method;
        try (ClassCreator classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className + "Customizer").superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();){
            method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            configBuilder = method.getMethodParam(0);
            for (Map.Entry<String, String> entry : defaultValues.entrySet()) {
                method.invokeStaticMethod(WITH_DEFAULT, new ResultHandle[]{configBuilder, method.load(entry.getKey()), method.load(entry.getValue())});
            }
            for (String converter : converters) {
                method.invokeStaticMethod(WITH_CONVERTER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)converter, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String interceptor : interceptors) {
                method.invokeStaticMethod(WITH_INTERCEPTOR, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptor, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String interceptorFactory : interceptorFactories) {
                method.invokeStaticMethod(WITH_INTERCEPTOR_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)interceptorFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSource : configSources) {
                method.invokeStaticMethod(WITH_SOURCE, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSource, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceProvider : configSourceProviders) {
                method.invokeStaticMethod(WITH_SOURCE_PROVIDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceProvider, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String configSourceFactory : configSourceFactories) {
                method.invokeStaticMethod(WITH_SOURCE_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configSourceFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandler : secretKeyHandlers) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandler, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String secretKeyHandlerFactory : secretKeyHandlerFactories) {
                method.invokeStaticMethod(WITH_SECRET_HANDLER_FACTORY, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)secretKeyHandlerFactory, (String[])new String[0]), new ResultHandle[0])});
            }
            for (ConfigMappings.ConfigClassWithPrefix mapping : mappings) {
                method.invokeStaticMethod(WITH_MAPPING, new ResultHandle[]{configBuilder, method.load(mapping.getKlass().getName()), method.load(mapping.getPrefix())});
                ResultHandle names = method.invokeStaticMethod(MethodDescriptor.ofMethod((Object)mappingsInfoClassName, (String)(mapping.getKlass().getName().replaceAll("\\.", "_") + "_" + mapping.getPrefix().hashCode()), Map.class, (Object[])new Object[0]), new ResultHandle[0]);
                method.invokeVirtualMethod(WITH_NAMES, configBuilder, new ResultHandle[]{names});
            }
            ResultHandle keys = method.invokeStaticMethod(MethodDescriptor.ofMethod((Object)mappingsInfoClassName, (String)"keys", Set.class, (Object[])new Object[0]), new ResultHandle[0]);
            method.invokeVirtualMethod(WITH_KEYS, configBuilder, new ResultHandle[]{keys});
            method.returnVoid();
        }
        configCustomizers.add(className + "Customizer");
        classCreator = ClassCreator.builder().classOutput((ClassOutput)new GeneratedClassGizmoAdaptor(generatedClass, true)).className(className).superClass(AbstractConfigBuilder.class).interfaces(new Class[]{SmallRyeConfigBuilderCustomizer.class}).setFinal(true).build();
        try {
            method = classCreator.getMethodCreator(BUILDER_CUSTOMIZER);
            configBuilder = method.getMethodParam(0);
            for (String configCustomizer : configCustomizers) {
                method.invokeStaticMethod(WITH_CUSTOMIZER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)configCustomizer, (String[])new String[0]), new ResultHandle[0])});
            }
            for (String builder : configBuilders) {
                method.invokeStaticMethod(WITH_BUILDER, new ResultHandle[]{configBuilder, method.newInstance(MethodDescriptor.ofConstructor((String)builder, (String[])new String[0]), new ResultHandle[0])});
            }
            method.returnVoid();
        }
        finally {
            if (classCreator != null) {
                classCreator.close();
            }
        }
        reflectiveClass.produce(ReflectiveClassBuildItem.builder(className).build());
    }

    private static Set<String> discoverService(Class<?> serviceClass, BuildProducer<ReflectiveClassBuildItem> reflectiveClass) throws IOException {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        HashSet<String> services = new HashSet<String>();
        for (String service : ServiceUtil.classNamesNamedIn(classLoader, "META-INF/services/" + serviceClass.getName())) {
            if (!QuarkusClassLoader.isClassPresentAtRuntime((String)service)) continue;
            services.add(service);
            reflectiveClass.produce(ReflectiveClassBuildItem.builder(service).build());
        }
        return services;
    }

    private static Set<String> staticSafeServices(Set<String> services) {
        ClassLoader classloader = Thread.currentThread().getContextClassLoader();
        HashSet<String> staticSafe = new HashSet<String>();
        for (String service : services) {
            if (service.startsWith("io.smallrye.config.")) {
                staticSafe.add(service);
                continue;
            }
            try {
                Class<?> serviceClass = classloader.loadClass(service);
                if (!serviceClass.isAnnotationPresent(StaticInitSafe.class)) continue;
                staticSafe.add(service);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return staticSafe;
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> staticSafeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().filter(ConfigMappingBuildItem::isStaticInitSafe).map(ConfigMappingBuildItem::toConfigClassWithPrefix).collect(Collectors.toSet());
    }

    private static Set<ConfigMappings.ConfigClassWithPrefix> runtimeConfigMappings(List<ConfigMappingBuildItem> configMappings) {
        return configMappings.stream().map(ConfigMappingBuildItem::toConfigClassWithPrefix).collect(Collectors.toSet());
    }
}

