/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment.dev;

import io.quarkus.bootstrap.app.AugmentAction;
import io.quarkus.bootstrap.app.CuratedApplication;
import io.quarkus.bootstrap.runner.Timing;
import io.quarkus.deployment.builditem.ConsoleFormatterBannerBuildItem;
import io.quarkus.deployment.dev.ClassScanResult;
import io.quarkus.deployment.dev.CompilationProvider;
import io.quarkus.deployment.dev.DevModeContext;
import io.quarkus.deployment.dev.DevModeMain;
import io.quarkus.deployment.dev.IsolatedDevModeMain;
import io.quarkus.deployment.dev.QuarkusCompiler;
import io.quarkus.deployment.dev.RuntimeUpdatesProcessor;
import io.quarkus.deployment.dev.testing.TestHandler;
import io.quarkus.deployment.dev.testing.TestSetupBuildItem;
import io.quarkus.deployment.dev.testing.TestSupport;
import io.quarkus.deployment.logging.LoggingSetupBuildItem;
import io.quarkus.deployment.steps.ClassTransformingBuildStep;
import io.quarkus.dev.spi.DevModeType;
import io.quarkus.dev.spi.HotReplacementContext;
import io.quarkus.dev.spi.HotReplacementSetup;
import io.quarkus.runner.bootstrap.AugmentActionImpl;
import io.quarkus.runtime.Quarkus;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;

public class IsolatedTestModeMain
extends IsolatedDevModeMain {
    private volatile DevModeContext context;
    private final List<HotReplacementSetup> hotReplacementSetups = new ArrayList<HotReplacementSetup>();
    static volatile Throwable deploymentProblem;
    private static volatile CuratedApplication curatedApplication;
    private static volatile AugmentAction augmentAction;

    private RuntimeUpdatesProcessor setupRuntimeCompilation(DevModeContext context, Path applicationRoot) throws Exception {
        System.setProperty("quarkus.test.display-test-output", "true");
        if (!context.getAllModules().isEmpty()) {
            QuarkusCompiler compiler;
            ServiceLoader<CompilationProvider> serviceLoader = ServiceLoader.load(CompilationProvider.class);
            ArrayList<CompilationProvider> compilationProviders = new ArrayList<CompilationProvider>();
            for (CompilationProvider provider : serviceLoader) {
                compilationProviders.add(provider);
                context.getAllModules().forEach(moduleInfo -> moduleInfo.addSourcePaths(provider.handledSourcePaths()));
            }
            try {
                compiler = new QuarkusCompiler(curatedApplication, compilationProviders, context);
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to create compiler", e);
            }
            TestSupport testSupport = new TestSupport(curatedApplication, compilationProviders, context, DevModeType.TEST_ONLY);
            RuntimeUpdatesProcessor processor = new RuntimeUpdatesProcessor(applicationRoot, context, compiler, DevModeType.TEST_ONLY, this::regenerateApplication, new BiConsumer<DevModeContext.ModuleInfo, String>(){

                @Override
                public void accept(DevModeContext.ModuleInfo moduleInfo, String s) {
                }
            }, new BiFunction<String, byte[], byte[]>(){

                @Override
                public byte[] apply(String s, byte[] bytes) {
                    return ClassTransformingBuildStep.transform(s, bytes);
                }
            }, testSupport);
            for (HotReplacementSetup service : ServiceLoader.load(HotReplacementSetup.class, (ClassLoader)curatedApplication.getBaseRuntimeClassLoader())) {
                this.hotReplacementSetups.add(service);
                service.setupHotDeployment((HotReplacementContext)processor);
                processor.addHotReplacementSetup(service);
            }
            return processor;
        }
        return null;
    }

    void regenerateApplication(Set<String> ignore, ClassScanResult ignore2) {
    }

    @Override
    public void close() {
        try {
            try {
                RuntimeUpdatesProcessor.INSTANCE.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            for (HotReplacementSetup i : this.hotReplacementSetups) {
                i.close();
            }
        }
        finally {
            curatedApplication.close();
        }
    }

    @Override
    public void accept(CuratedApplication o, Map<String, Object> params) {
        System.setProperty("java.nio.channels.DefaultThreadPool.threadFactory", "io.quarkus.dev.io.NioThreadPoolThreadFactory");
        Timing.staticInitStarted((ClassLoader)o.getBaseRuntimeClassLoader(), (boolean)false);
        try {
            curatedApplication = o;
            Object potentialContext = params.get(DevModeContext.class.getName());
            if (potentialContext instanceof DevModeContext) {
                this.context = (DevModeContext)potentialContext;
            } else {
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                ObjectOutputStream oo = new ObjectOutputStream(out);
                oo.writeObject(potentialContext);
                this.context = (DevModeContext)new ObjectInputStream(new ByteArrayInputStream(out.toByteArray())).readObject();
            }
            augmentAction = new AugmentActionImpl(curatedApplication);
            RuntimeUpdatesProcessor.INSTANCE = this.setupRuntimeCompilation(this.context, (Path)params.get("app-root"));
            if (RuntimeUpdatesProcessor.INSTANCE != null) {
                RuntimeUpdatesProcessor.INSTANCE.checkForFileChange();
                RuntimeUpdatesProcessor.INSTANCE.checkForChangedClasses(true);
            }
            try {
                augmentAction.performCustomBuild(TestHandler.class.getName(), null, new String[]{TestSetupBuildItem.class.getName(), LoggingSetupBuildItem.class.getName(), ConsoleFormatterBannerBuildItem.class.getName()});
            }
            catch (Throwable t) {
                System.err.println("Failed to start quarkus test mode");
                t.printStackTrace();
                System.exit(1);
            }
            Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void run() {
                    Class<DevModeMain> clazz = DevModeMain.class;
                    synchronized (DevModeMain.class) {
                        try {
                            IsolatedTestModeMain.this.close();
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                        return;
                    }
                }
            }, "Quarkus Shutdown Thread"));
            Quarkus.waitForExit();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

