/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.deployment;

import io.quarkus.bootstrap.model.AppArtifactKey;
import io.quarkus.bootstrap.model.PathsCollection;
import io.quarkus.builder.item.MultiBuildItem;
import io.quarkus.deployment.ApplicationArchive;
import io.quarkus.maven.dependency.ArtifactKey;
import io.quarkus.paths.PathCollection;
import io.quarkus.paths.PathList;
import java.nio.file.Path;
import org.jboss.jandex.IndexView;

public final class ApplicationArchiveImpl
extends MultiBuildItem
implements ApplicationArchive {
    private final IndexView indexView;
    private final PathCollection rootDirs;
    private final PathCollection paths;
    private final ArtifactKey artifactKey;

    public ApplicationArchiveImpl(IndexView indexView, Path archiveRoot, Path archiveLocation, ArtifactKey artifactKey) {
        this(indexView, (PathCollection)PathList.of((Path[])new Path[]{archiveRoot}), (PathCollection)PathList.of((Path[])new Path[]{archiveLocation}), artifactKey);
    }

    public ApplicationArchiveImpl(IndexView indexView, PathCollection rootDirs, PathCollection paths, ArtifactKey artifactKey) {
        this.indexView = indexView;
        this.rootDirs = rootDirs;
        this.paths = paths;
        this.artifactKey = artifactKey;
    }

    @Override
    public IndexView getIndex() {
        return this.indexView;
    }

    @Override
    @Deprecated
    public Path getArchiveLocation() {
        return (Path)this.paths.iterator().next();
    }

    @Override
    @Deprecated
    public PathsCollection getRootDirs() {
        return PathsCollection.from((Iterable)this.rootDirs);
    }

    @Override
    public PathCollection getRootDirectories() {
        return this.rootDirs;
    }

    @Override
    @Deprecated
    public PathsCollection getPaths() {
        return PathsCollection.from((Iterable)this.paths);
    }

    @Override
    public PathCollection getResolvedPaths() {
        return this.paths;
    }

    @Override
    public AppArtifactKey getArtifactKey() {
        return this.artifactKey == null ? null : new AppArtifactKey(this.artifactKey.getGroupId(), this.artifactKey.getArtifactId(), this.artifactKey.getClassifier(), this.artifactKey.getType());
    }

    @Override
    public ArtifactKey getKey() {
        return this.artifactKey;
    }
}

