/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.container.image.deployment;

import io.quarkus.deployment.Capabilities;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.Set;

public final class ContainerImageCapabilitiesUtil {
    public static final Map<String, String> CAPABILITY_TO_EXTENSION_NAME = Map.of("io.quarkus.container.image.jib", "quarkus-container-image-jib", "io.quarkus.container.image.docker", "quarkus-container-image-docker", "io.quarkus.container.image.podman", "quarkus-container-image-podman", "io.quarkus.container.image.openshift", "quarkus-container-image-openshift", "io.quarkus.container.image.buildpack", "quarkus-container-image-buildpack");
    private static final Map<String, String> CAPABILITY_TO_BUILDER_NAME = Map.of("io.quarkus.container.image.jib", "jib", "io.quarkus.container.image.docker", "docker", "io.quarkus.container.image.podman", "podman", "io.quarkus.container.image.openshift", "openshift", "io.quarkus.container.image.buildpack", "buildpack");

    private ContainerImageCapabilitiesUtil() {
    }

    public static Optional<String> getActiveContainerImageCapability(Capabilities capabilities) {
        Set<String> activeContainerImageCapabilities = ContainerImageCapabilitiesUtil.getContainerImageCapabilities(capabilities);
        if (activeContainerImageCapabilities.size() > 1) {
            throw new IllegalStateException(String.join((CharSequence)" and ", activeContainerImageCapabilities) + " were detected, at most one container-image extension can be present.\nEither remove the unneeded ones, or select one by setting any of the following configuration properties: " + String.valueOf(ContainerImageCapabilitiesUtil.createBuilderSelectionPropertySuggestion(capabilities)));
        }
        return activeContainerImageCapabilities.isEmpty() ? Optional.empty() : Optional.of(activeContainerImageCapabilities.iterator().next());
    }

    private static StringBuilder createBuilderSelectionPropertySuggestion(Capabilities capabilities) {
        StringBuilder suggestion = new StringBuilder();
        boolean isFirst = true;
        for (String capability : capabilities.getCapabilities()) {
            if (!ContainerImageCapabilitiesUtil.isContainerImageCapability(capability)) continue;
            if (!isFirst) {
                suggestion.append(", ");
            }
            isFirst = false;
            suggestion.append('\'').append("quarkus.container-image.builder=").append(CAPABILITY_TO_BUILDER_NAME.get(capability)).append('\'');
        }
        return suggestion;
    }

    private static Set<String> getContainerImageCapabilities(Capabilities capabilities) {
        HashSet<String> activeContainerImageCapabilities = new HashSet<String>();
        for (String capability : capabilities.getCapabilities()) {
            if (!ContainerImageCapabilitiesUtil.isContainerImageCapability(capability)) continue;
            if (!CAPABILITY_TO_EXTENSION_NAME.containsKey(capability)) {
                throw new IllegalArgumentException("Unknown container image capability: " + capability);
            }
            activeContainerImageCapabilities.add(CAPABILITY_TO_EXTENSION_NAME.get(capability));
        }
        return activeContainerImageCapabilities;
    }

    private static boolean isContainerImageCapability(String capability) {
        return capability.toLowerCase().contains("container.image");
    }
}

