/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.config.yaml.runtime;

import io.smallrye.config.source.yaml.YamlConfigSource;
import java.io.FileNotFoundException;
import java.io.IOError;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.microprofile.config.spi.ConfigSource;
import org.eclipse.microprofile.config.spi.ConfigSourceProvider;

public final class ApplicationYamlProvider
implements ConfigSourceProvider {
    public static final String APPLICATION_YAML = "application.yaml";
    private static final int APPLICATION_YAML_IN_JAR_ORDINAL = 254;
    public static final String APPLICATION_YML = "application.yml";
    private static final int APPLICATION_YML_IN_JAR_ORDINAL = 253;

    public Iterable<ConfigSource> getConfigSources(ClassLoader forClassLoader) {
        List<ConfigSource> yamlSources = this.getConfigSourcesForFileName(APPLICATION_YAML, 254, forClassLoader);
        List<ConfigSource> ymlSources = this.getConfigSourcesForFileName(APPLICATION_YML, 253, forClassLoader);
        if (yamlSources.isEmpty() && ymlSources.isEmpty()) {
            return Collections.emptyList();
        }
        if (yamlSources.isEmpty()) {
            return ymlSources;
        }
        if (ymlSources.isEmpty()) {
            return yamlSources;
        }
        ArrayList<ConfigSource> result = new ArrayList<ConfigSource>(yamlSources.size() + ymlSources.size());
        result.addAll(yamlSources);
        result.addAll(ymlSources);
        return result;
    }

    private List<ConfigSource> getConfigSourcesForFileName(String fileName, int inJarOrdinal, ClassLoader forClassLoader) {
        YamlConfigSource configSource2;
        Throwable throwable;
        List<Object> sources;
        block31: {
            sources = Collections.emptyList();
            try {
                InputStream str = forClassLoader.getResourceAsStream(fileName);
                if (str == null) break block31;
                throwable = null;
                try (InputStream c = str;){
                    configSource2 = new YamlConfigSource(fileName, str, inJarOrdinal);
                    assert (sources.isEmpty());
                    sources = Collections.singletonList(configSource2);
                }
                catch (Throwable configSource2) {
                    throwable = configSource2;
                    throw configSource2;
                }
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        Path path = Paths.get("config", fileName);
        if (Files.exists(path, new LinkOption[0])) {
            try {
                throwable = null;
                try (InputStream str = Files.newInputStream(path, new OpenOption[0]);){
                    configSource2 = new YamlConfigSource(fileName, str, inJarOrdinal + 10);
                    sources = sources.isEmpty() ? Collections.singletonList(configSource2) : Arrays.asList((ConfigSource)sources.get(0), configSource2);
                }
                catch (Throwable throwable2) {
                    throwable = throwable2;
                    throw throwable2;
                }
            }
            catch (FileNotFoundException | NoSuchFileException str) {
            }
            catch (IOException e) {
                throw new IOError(e);
            }
        }
        return sources;
    }
}

