/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.cache.deployment;

import io.quarkus.cache.runtime.CacheKeyParameterPositions;
import java.util.function.BiFunction;
import org.objectweb.asm.AnnotationVisitor;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.MethodVisitor;

class RestClientMethodEnhancer
implements BiFunction<String, ClassVisitor, ClassVisitor> {
    private static final String CACHE_KEY_PARAMETER_POSITIONS_DESCRIPTOR = "L" + CacheKeyParameterPositions.class.getName().replace('.', '/') + ";";
    private final String methodName;
    private final short[] cacheKeyParameterPositions;

    public RestClientMethodEnhancer(String methodName, short[] cacheKeyParameterPositions) {
        this.methodName = methodName;
        this.cacheKeyParameterPositions = cacheKeyParameterPositions;
    }

    @Override
    public ClassVisitor apply(String className, ClassVisitor classVisitor) {
        return new ClassVisitor(589824, classVisitor){

            public MethodVisitor visitMethod(int access, String name, String descriptor, String signature, String[] exceptions) {
                MethodVisitor superVisitor = super.visitMethod(access, name, descriptor, signature, exceptions);
                if (!name.equals(RestClientMethodEnhancer.this.methodName)) {
                    return superVisitor;
                }
                return new MethodVisitor(589824, superVisitor){

                    public void visitEnd() {
                        AnnotationVisitor annotation = super.visitAnnotation(CACHE_KEY_PARAMETER_POSITIONS_DESCRIPTOR, true);
                        annotation.visit("value", (Object)RestClientMethodEnhancer.this.cacheKeyParameterPositions);
                        annotation.visitEnd();
                        super.visitEnd();
                    }
                };
            }
        };
    }
}

