/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.runner;

import io.quarkus.bootstrap.runner.ClassLoadingResource;
import io.quarkus.bootstrap.runner.JarFileReference;
import io.quarkus.bootstrap.runner.ManifestInfo;
import io.smallrye.common.io.jar.JarEntries;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.nio.file.Path;
import java.security.CodeSource;
import java.security.ProtectionDomain;
import java.security.cert.Certificate;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class JarResource
implements ClassLoadingResource {
    private volatile ProtectionDomain protectionDomain;
    private final ManifestInfo manifestInfo;
    final Path jarPath;
    final AtomicReference<CompletableFuture<JarFileReference>> jarFileReference = new AtomicReference();

    public JarResource(ManifestInfo manifestInfo, Path jarPath) {
        this.manifestInfo = manifestInfo;
        this.jarPath = jarPath;
    }

    @Override
    public void init() {
        URL url;
        try {
            Object path = this.jarPath.toAbsolutePath().toString();
            if (!((String)path).startsWith("/")) {
                path = "/" + (String)path;
            }
            URI uri = new URI("file", null, (String)path, null, null);
            url = new URL((URL)null, uri.toString(), new JarUrlStreamHandler(uri));
        }
        catch (MalformedURLException | URISyntaxException e) {
            throw new RuntimeException("Unable to create protection domain for " + String.valueOf(this.jarPath), e);
        }
        this.protectionDomain = new ProtectionDomain(new CodeSource(url, (Certificate[])null), null);
    }

    @Override
    public byte[] getResourceData(String resource) {
        return JarFileReference.withJarFile(this, resource, JarResourceDataProvider.INSTANCE);
    }

    @Override
    public URL getResourceURL(String resource) {
        return JarFileReference.withJarFile(this, resource, JarResourceURLProvider.INSTANCE);
    }

    @Override
    public ManifestInfo getManifestInfo() {
        return this.manifestInfo;
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.protectionDomain;
    }

    @Override
    public void close() {
        JarFileReference ref;
        CompletableFuture<JarFileReference> futureRef = this.jarFileReference.get();
        if (futureRef != null && (ref = (JarFileReference)futureRef.getNow(null)) != null) {
            ref.markForClosing(this);
        }
    }

    @Override
    public void resetInternalCaches() {
        this.close();
    }

    public String toString() {
        return "JarResource{" + String.valueOf(this.jarPath.getFileName()) + "}";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        JarResource that = (JarResource)o;
        return this.jarPath.equals(that.jarPath);
    }

    public int hashCode() {
        return Objects.hashCode(this.jarPath);
    }

    private static class JarUrlStreamHandler
    extends URLStreamHandler {
        private final String externalForm;

        private JarUrlStreamHandler(URI uri) {
            this.externalForm = "file:".concat(uri.getRawPath());
        }

        @Override
        protected URLConnection openConnection(URL u) throws IOException {
            return new JarURLConnection(u);
        }

        @Override
        protected String toExternalForm(URL u) {
            return this.externalForm;
        }
    }

    private static class JarResourceDataProvider
    implements JarFileReference.JarFileConsumer<byte[]> {
        private static final JarResourceDataProvider INSTANCE = new JarResourceDataProvider();

        private JarResourceDataProvider() {
        }

        @Override
        public byte[] apply(JarFile jarFile, Path path, String res) {
            byte[] byArray;
            block11: {
                ZipEntry entry = jarFile.getEntry(res);
                if (entry == null) {
                    return null;
                }
                InputStream is = jarFile.getInputStream(entry);
                try {
                    int read;
                    byte[] data = new byte[(int)entry.getSize()];
                    int pos = 0;
                    for (int rem = data.length; rem > 0; rem -= read) {
                        read = is.read(data, pos, rem);
                        if (read == -1) {
                            throw new RuntimeException("Failed to read all data for " + res);
                        }
                        pos += read;
                    }
                    byArray = data;
                    if (is == null) break block11;
                }
                catch (Throwable throwable) {
                    try {
                        if (is != null) {
                            try {
                                is.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw new RuntimeException("Failed to read zip entry " + res, e);
                    }
                }
                is.close();
            }
            return byArray;
        }
    }

    private static class JarResourceURLProvider
    implements JarFileReference.JarFileConsumer<URL> {
        private static final JarResourceURLProvider INSTANCE = new JarResourceURLProvider();

        private JarResourceURLProvider() {
        }

        @Override
        public URL apply(JarFile jarFile, Path path, String resource) {
            JarEntry entry = jarFile.getJarEntry(resource);
            if (entry == null) {
                return null;
            }
            try {
                URL resUrl = JarResourceURLProvider.getUrl(path, JarResourceURLProvider.getRealName(entry, resource));
                StringBuilder file = new StringBuilder((resUrl.getProtocol() == null ? 4 : resUrl.getProtocol().length()) + 1 + resUrl.getPath().length() + (resUrl.getQuery() == null ? 0 : 3 + resUrl.getQuery().length()));
                file.append(resUrl.getProtocol());
                file.append(':');
                file.append(resUrl.getPath());
                if (resUrl.getQuery() != null) {
                    file.append("%3F");
                    file.append(resUrl.getQuery());
                }
                return new URL("jar", null, file.toString());
            }
            catch (MalformedURLException | URISyntaxException e) {
                throw new RuntimeException(e);
            }
        }

        private static String getRealName(JarEntry entry, String resource) {
            String realName = JarEntries.getRealName((JarEntry)entry);
            if (resource.endsWith("/") && entry.isDirectory()) {
                if (realName.endsWith("/")) {
                    return realName;
                }
                return realName + "/";
            }
            if (realName.endsWith("/")) {
                return realName.substring(0, realName.length() - 1);
            }
            return realName;
        }

        private static URL getUrl(Path jarPath, String realName) throws MalformedURLException, URISyntaxException {
            URI jarUri = jarPath.toUri();
            StringBuilder ssp = new StringBuilder(jarUri.getPath().length() + realName.length() + 2);
            ssp.append(jarUri.getPath());
            ssp.append("!/");
            ssp.append(realName);
            return new URI(jarUri.getScheme(), null, ssp.toString(), null, null).toURL();
        }
    }

    private static class JarURLConnection
    extends URLConnection {
        private final File file;

        private JarURLConnection(URL url) throws IOException {
            super(url);
            try {
                this.file = new File(url.toURI());
            }
            catch (URISyntaxException e) {
                throw new IOException(e);
            }
        }

        @Override
        public void connect() throws IOException {
            if (!this.file.exists()) {
                throw new FileNotFoundException(this.file.getAbsolutePath());
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            return new FileInputStream(this.file);
        }

        @Override
        public int getContentLength() {
            return (int)this.file.length();
        }

        @Override
        public long getContentLengthLong() {
            return this.file.length();
        }

        @Override
        public String getContentType() {
            return "application/java-archive";
        }
    }
}

