/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven;

import io.quarkus.bootstrap.model.ApplicationModelBuilder;
import io.quarkus.bootstrap.resolver.maven.ApplicationDependencyTreeResolver;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.MavenArtifactResolver;
import io.quarkus.bootstrap.util.DependencyUtils;
import io.quarkus.maven.dependency.ResolvedDependencyBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Consumer;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.graph.Dependency;
import org.eclipse.aether.graph.DependencyNode;

@Deprecated(since="3.19.0", forRemoval=true)
public class BuildDependencyGraphVisitor {
    private final MavenArtifactResolver resolver;
    private final ApplicationModelBuilder appBuilder;
    private final Consumer<String> buildTreeConsumer;
    private final List<Boolean> depth;
    private DependencyNode currentDeployment;
    private DependencyNode currentRuntime;
    private Artifact runtimeArtifactToFind;

    public BuildDependencyGraphVisitor(MavenArtifactResolver resolver, ApplicationModelBuilder appBuilder, Consumer<String> buildTreeConsumer) {
        this.resolver = resolver;
        this.appBuilder = appBuilder;
        this.buildTreeConsumer = buildTreeConsumer;
        this.depth = buildTreeConsumer == null ? null : new ArrayList<Boolean>();
    }

    public void visit(DependencyNode node) throws BootstrapMavenException {
        if (this.depth != null) {
            this.consume(node);
        }
        Dependency dep = node.getDependency();
        DependencyNode previousDeployment = this.currentDeployment;
        DependencyNode previousRuntime = this.currentRuntime;
        Artifact previousRuntimeArtifact = this.runtimeArtifactToFind;
        Artifact newRuntimeArtifact = ApplicationDependencyTreeResolver.getRuntimeArtifact(node);
        if (newRuntimeArtifact != null) {
            this.currentDeployment = node;
            this.runtimeArtifactToFind = newRuntimeArtifact;
            this.currentRuntime = null;
        } else if (this.runtimeArtifactToFind != null && this.currentRuntime == null && this.runtimeArtifactToFind.equals(dep.getArtifact())) {
            this.currentRuntime = node;
            this.runtimeArtifactToFind = null;
        }
        List children = node.getChildren();
        int childrenTotal = children.size();
        if (childrenTotal > 0) {
            if (childrenTotal == 1) {
                if (this.depth != null) {
                    this.depth.add(false);
                }
                this.visit((DependencyNode)children.get(0));
            } else {
                if (this.depth != null) {
                    this.depth.add(true);
                }
                int i = 0;
                while (i < childrenTotal) {
                    this.visit((DependencyNode)children.get(i++));
                    if (this.depth == null || i != childrenTotal - 1) continue;
                    this.depth.set(this.depth.size() - 1, false);
                }
            }
            if (this.depth != null) {
                this.depth.remove(this.depth.size() - 1);
            }
        }
        this.visitLeave(node);
        this.currentDeployment = previousDeployment;
        this.currentRuntime = previousRuntime;
        this.runtimeArtifactToFind = previousRuntimeArtifact;
    }

    private void consume(DependencyNode node) {
        StringBuilder buf = new StringBuilder();
        if (!this.depth.isEmpty()) {
            for (int i = 0; i < this.depth.size() - 1; ++i) {
                if (this.depth.get(i).booleanValue()) {
                    buf.append('\u2502').append("  ");
                    continue;
                }
                buf.append("   ");
            }
            if (this.depth.get(this.depth.size() - 1).booleanValue()) {
                buf.append('\u251c').append('\u2500').append(' ');
            } else {
                buf.append('\u2514').append('\u2500').append(' ');
            }
        }
        Artifact a = node.getArtifact();
        buf.append(a.getGroupId()).append(":").append(a.getArtifactId()).append(":");
        if (!a.getClassifier().isEmpty()) {
            buf.append(a.getClassifier()).append(":");
        }
        if (!"jar".equals(a.getExtension())) {
            buf.append(a.getExtension()).append(":");
        }
        buf.append(a.getVersion());
        if (!this.depth.isEmpty()) {
            buf.append(" (").append(node.getDependency().getScope());
            if (node.getDependency().isOptional()) {
                buf.append(" optional");
            }
            buf.append(')');
        }
        this.buildTreeConsumer.accept(buf.toString());
    }

    private void visitLeave(DependencyNode node) throws BootstrapMavenException {
        Dependency dep = node.getDependency();
        if (dep == null) {
            return;
        }
        if (this.currentDeployment == null) {
            return;
        }
        if (this.currentRuntime == null && this.appBuilder.getDependency(DependencyUtils.getKey(node.getArtifact())) == null) {
            this.appBuilder.addDependency((ResolvedDependencyBuilder)DependencyUtils.newDependencyBuilder(node, this.resolver).setFlags(8));
        } else if (this.currentRuntime == node) {
            this.currentRuntime = null;
            this.runtimeArtifactToFind = null;
        }
        if (this.currentDeployment == node) {
            this.currentDeployment = null;
        }
    }
}

