/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.resolver.maven.workspace;

import io.quarkus.bootstrap.resolver.maven.BootstrapMavenContext;
import io.quarkus.bootstrap.resolver.maven.BootstrapMavenException;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelBuilderFactory;
import io.quarkus.bootstrap.resolver.maven.BootstrapModelResolver;
import io.quarkus.bootstrap.resolver.maven.options.BootstrapMavenOptions;
import io.quarkus.bootstrap.resolver.maven.workspace.BootstrapModelCache;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalProject;
import io.quarkus.bootstrap.resolver.maven.workspace.LocalWorkspace;
import io.quarkus.bootstrap.resolver.maven.workspace.ModelUtils;
import io.quarkus.maven.dependency.GAV;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedDeque;
import java.util.concurrent.Phaser;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Consumer;
import java.util.function.Function;
import org.apache.maven.model.Model;
import org.apache.maven.model.Parent;
import org.apache.maven.model.Profile;
import org.apache.maven.model.building.DefaultModelBuildingRequest;
import org.apache.maven.model.building.ModelBuilder;
import org.apache.maven.model.building.ModelBuildingRequest;
import org.apache.maven.model.building.ModelCache;
import org.apache.maven.model.resolution.ModelResolver;
import org.apache.maven.model.resolution.WorkspaceModelResolver;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.repository.WorkspaceReader;
import org.eclipse.aether.repository.WorkspaceRepository;
import org.jboss.logging.Logger;

public class WorkspaceLoader
implements WorkspaceModelResolver,
WorkspaceReader {
    private static final Logger log = Logger.getLogger(WorkspaceLoader.class);
    private static final String POM_XML = "pom.xml";
    private static final Model MISSING_MODEL = new Model();
    private final Deque<RawModule> moduleQueue = new ConcurrentLinkedDeque<RawModule>();
    private final Map<Path, Model> loadedPoms = new ConcurrentHashMap<Path, Model>();
    private final Function<Path, Model> modelProvider;
    private final Map<GAV, Model> loadedModules = new ConcurrentHashMap<GAV, Model>();
    private final LocalWorkspace workspace = new LocalWorkspace();
    private final Path currentProjectPom;
    private boolean warnOnFailingWsModules;
    private ModelBuilder modelBuilder;
    private BootstrapModelResolver modelResolver;
    private ModelCache modelCache;
    private List<String> activeProfileIds;
    private List<String> inactiveProfileIds;
    private List<Profile> profiles;

    private static Path locateCurrentProjectPom(Path path) throws BootstrapMavenException {
        for (Path p = path; p != null; p = p.getParent()) {
            Path pom = p.resolve(POM_XML);
            if (!Files.exists(pom, new LinkOption[0])) continue;
            return pom;
        }
        throw new BootstrapMavenException("Failed to locate project pom.xml for " + String.valueOf(path));
    }

    WorkspaceLoader(BootstrapMavenContext ctx, Path currentProjectPom, Function<Path, Model> modelProvider) throws BootstrapMavenException {
        try {
            BasicFileAttributes fileAttributes = Files.readAttributes(currentProjectPom, BasicFileAttributes.class, new LinkOption[0]);
            this.currentProjectPom = fileAttributes.isDirectory() ? WorkspaceLoader.locateCurrentProjectPom(currentProjectPom) : currentProjectPom;
        }
        catch (IOException e) {
            throw new IllegalArgumentException(String.valueOf(currentProjectPom) + " does not exist", e);
        }
        this.addModulePom(this.currentProjectPom);
        Function<Path, Model> function = this.modelProvider = modelProvider == null ? pom -> null : modelProvider;
        if (ctx != null && ctx.isEffectiveModelBuilder()) {
            this.modelBuilder = BootstrapModelBuilderFactory.getDefaultModelBuilder();
            this.modelResolver = BootstrapModelResolver.newInstance(ctx, this);
            this.modelCache = new BootstrapModelCache(this.modelResolver.getSession());
            this.profiles = ctx.getActiveSettingsProfiles();
            BootstrapMavenOptions cliOptions = ctx.getCliOptions();
            this.activeProfileIds = new ArrayList<String>(this.profiles.size() + cliOptions.getActiveProfileIds().size());
            for (Profile p : this.profiles) {
                this.activeProfileIds.add(p.getId());
            }
            this.activeProfileIds.addAll(cliOptions.getActiveProfileIds());
            this.inactiveProfileIds = cliOptions.getInactiveProfileIds();
            this.warnOnFailingWsModules = ctx.isWarnOnFailingWorkspaceModules();
        }
        this.workspace.setBootstrapMavenContext(ctx);
    }

    private void addModulePom(Path pom) {
        if (pom != null) {
            this.moduleQueue.push(new RawModule(pom));
        }
    }

    void setWorkspaceRootPom(Path rootPom) {
        this.addModulePom(rootPom);
    }

    LocalProject load() throws BootstrapMavenException {
        AtomicReference currentProject = new AtomicReference();
        Consumer<Model> processor = this.modelBuilder == null ? rawModel -> {
            LocalProject project = new LocalProject((Model)rawModel, this.workspace);
            if (currentProject.get() == null && project.getDir().equals(this.currentProjectPom.getParent())) {
                currentProject.set(project);
            }
        } : rawModel -> {
            DefaultModelBuildingRequest req = new DefaultModelBuildingRequest();
            req.setPomFile(rawModel.getPomFile());
            req.setModelResolver((ModelResolver)this.modelResolver);
            req.setSystemProperties(System.getProperties());
            req.setUserProperties(System.getProperties());
            req.setModelCache(this.modelCache);
            req.setActiveProfileIds(this.activeProfileIds);
            req.setInactiveProfileIds(this.inactiveProfileIds);
            req.setProfiles(this.profiles);
            req.setRawModel(rawModel);
            req.setWorkspaceModelResolver((WorkspaceModelResolver)this);
            LocalProject project = null;
            try {
                project = new LocalProject(this.modelBuilder.build((ModelBuildingRequest)req), this.workspace);
            }
            catch (Exception e) {
                if (this.warnOnFailingWsModules) {
                    log.warn((Object)("Failed to resolve effective model for " + String.valueOf(rawModel.getPomFile())), (Throwable)e);
                    return;
                }
                throw new RuntimeException("Failed to resolve the effective model for " + String.valueOf(rawModel.getPomFile()), e);
            }
            if (currentProject.get() == null && project.getDir().equals(this.currentProjectPom.getParent())) {
                currentProject.set(project);
            }
            for (String module : project.getModelBuildingResult().getEffectiveModel().getModules()) {
                this.addModulePom(project.getDir().resolve(module).resolve(POM_XML));
            }
        };
        ConcurrentLinkedDeque<Exception> errors = new ConcurrentLinkedDeque<Exception>();
        while (!this.moduleQueue.isEmpty()) {
            ConcurrentLinkedDeque newModules = new ConcurrentLinkedDeque();
            while (!this.moduleQueue.isEmpty()) {
                Phaser phaser = new Phaser(1);
                while (!this.moduleQueue.isEmpty()) {
                    phaser.register();
                    RawModule module = this.moduleQueue.removeLast();
                    CompletableFuture.runAsync(() -> {
                        try {
                            this.loadModule(module, newModules);
                        }
                        catch (Exception e) {
                            errors.add(e);
                        }
                        finally {
                            phaser.arriveAndDeregister();
                        }
                    });
                }
                phaser.arriveAndAwaitAdvance();
                this.assertNoErrors(errors);
            }
            for (RawModule newModule : newModules) {
                newModule.process(processor);
            }
        }
        if (currentProject.get() == null) {
            throw new BootstrapMavenException("Failed to load project " + String.valueOf(this.currentProjectPom));
        }
        return (LocalProject)currentProject.get();
    }

    private void loadModule(RawModule rawModule, Collection<RawModule> newModules) {
        Path parentPom;
        Path moduleDir = rawModule.pom.getParent();
        if (moduleDir == null) {
            moduleDir = WorkspaceLoader.getFsRootDir();
        }
        if (this.loadedPoms.containsKey(moduleDir)) {
            return;
        }
        Model model = rawModule.model = this.modelProvider == null ? null : this.modelProvider.apply(moduleDir);
        if (rawModule.model == null) {
            rawModule.model = WorkspaceLoader.readModel(rawModule.pom);
        }
        this.loadedPoms.put(moduleDir, rawModule.model);
        if (rawModule.model == MISSING_MODEL) {
            return;
        }
        Model added = this.loadedModules.putIfAbsent(new GAV(ModelUtils.getGroupId(rawModule.model), rawModule.model.getArtifactId(), ModelUtils.getVersion(rawModule.model)), rawModule.model);
        if (added != null) {
            return;
        }
        newModules.add(rawModule);
        for (String module : rawModule.model.getModules()) {
            this.queueModule(rawModule.model.getProjectDirectory().toPath().resolve(module));
        }
        for (Profile profile : rawModule.model.getProfiles()) {
            for (String module : profile.getModules()) {
                this.queueModule(rawModule.model.getProjectDirectory().toPath().resolve(module));
            }
        }
        if (rawModule.parent == null && (parentPom = rawModule.getParentPom()) != null) {
            Path parentDir = parentPom.getParent();
            if (parentDir == null) {
                parentDir = WorkspaceLoader.getFsRootDir();
            }
            if (!this.loadedPoms.containsKey(parentDir)) {
                rawModule.parent = new RawModule(parentPom);
                this.moduleQueue.push(rawModule.parent);
            }
        }
    }

    private static Path getFsRootDir() {
        return Path.of("/", new String[0]);
    }

    private void queueModule(Path dir) {
        if (!this.loadedPoms.containsKey(dir)) {
            this.moduleQueue.push(new RawModule(dir.resolve(POM_XML)));
        }
    }

    public Model resolveRawModel(String groupId, String artifactId, String versionConstraint) {
        return this.loadedModules.get(new GAV(groupId, artifactId, versionConstraint));
    }

    public Model resolveEffectiveModel(String groupId, String artifactId, String versionConstraint) {
        LocalProject project = this.workspace.getProject(groupId, artifactId);
        return project != null && project.getVersion().equals(versionConstraint) ? project.getModelBuildingResult().getEffectiveModel() : null;
    }

    public WorkspaceRepository getRepository() {
        return this.workspace.getRepository();
    }

    public File findArtifact(Artifact artifact) {
        if (!"pom".equals(artifact.getExtension())) {
            return null;
        }
        Model model = this.loadedModules.get(new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        return model == null ? null : model.getPomFile();
    }

    public List<String> findVersions(Artifact artifact) {
        Model model = this.loadedModules.get(new GAV(artifact.getGroupId(), artifact.getArtifactId(), artifact.getVersion()));
        return model == null ? List.of() : List.of(ModelUtils.getVersion(model));
    }

    private void assertNoErrors(Collection<Exception> errors) throws BootstrapMavenException {
        if (!errors.isEmpty()) {
            StringBuilder sb = new StringBuilder("The following errors were encountered while loading the workspace:");
            log.error((Object)sb);
            int i = 1;
            block0: for (Exception error : errors) {
                String prefix = i++ + ")";
                log.error((Object)prefix, (Throwable)error);
                sb.append(System.lineSeparator()).append(prefix).append(" ").append(error.getLocalizedMessage());
                for (StackTraceElement e : error.getStackTrace()) {
                    int j;
                    sb.append(System.lineSeparator());
                    for (j = 0; j < prefix.length(); ++j) {
                        sb.append(" ");
                    }
                    sb.append("at ").append(e);
                    if (!e.getClassName().contains("io.quarkus")) continue;
                    sb.append(System.lineSeparator());
                    for (j = 0; j < prefix.length(); ++j) {
                        sb.append(" ");
                    }
                    sb.append("...");
                    continue block0;
                }
            }
            throw new BootstrapMavenException(sb.toString());
        }
    }

    private static Model readModel(Path pom) {
        try {
            Model model = ModelUtils.readModel(pom);
            model.setPomFile(pom.toFile());
            return model;
        }
        catch (NoSuchFileException e) {
            log.warn((Object)("Module(s) under " + String.valueOf(pom.getParent()) + " will be handled as thirdparty dependencies because " + String.valueOf(pom) + " does not exist"));
            return MISSING_MODEL;
        }
        catch (IOException e) {
            throw new UncheckedIOException("Failed to load POM from " + String.valueOf(pom), e);
        }
    }

    private static class RawModule {
        final Path pom;
        Model model;
        RawModule parent;
        boolean processed;

        private RawModule(Path pom) {
            this(null, pom);
        }

        private RawModule(RawModule parent, Path pom) {
            this.pom = pom.normalize().toAbsolutePath();
            this.parent = parent;
        }

        private Path getParentPom() {
            if (this.model == null) {
                return null;
            }
            Path parentPom = null;
            Parent parent = this.model.getParent();
            if (parent != null && parent.getRelativePath() != null && !parent.getRelativePath().isEmpty()) {
                parentPom = this.pom.getParent().resolve(parent.getRelativePath()).normalize();
                if (Files.isDirectory(parentPom, new LinkOption[0])) {
                    parentPom = parentPom.resolve(WorkspaceLoader.POM_XML);
                }
            } else {
                Path parentDir = this.pom.getParent().getParent();
                if (parentDir != null) {
                    parentPom = parentDir.resolve(WorkspaceLoader.POM_XML);
                }
            }
            return parentPom != null && Files.exists(parentPom, new LinkOption[0]) ? parentPom : null;
        }

        private void process(Consumer<Model> consumer) {
            if (this.processed) {
                return;
            }
            this.processed = true;
            if (this.parent != null) {
                this.parent.process(consumer);
            }
            if (this.model != null) {
                consumer.accept(this.model);
            }
        }
    }
}

