/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.connection;

import java.io.File;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.gradle.api.Action;
import org.gradle.internal.Cast;
import org.gradle.internal.impldep.org.jspecify.annotations.Nullable;
import org.gradle.internal.operations.MultipleBuildOperationFailures;
import org.gradle.tooling.BuildAction;
import org.gradle.tooling.BuildController;
import org.gradle.tooling.FetchModelResult;
import org.gradle.tooling.UnknownModelException;
import org.gradle.tooling.UnsupportedVersionException;
import org.gradle.tooling.internal.adapter.ObjectGraphAdapter;
import org.gradle.tooling.internal.adapter.ProtocolToModelAdapter;
import org.gradle.tooling.internal.adapter.ViewBuilder;
import org.gradle.tooling.internal.consumer.DefaultFetchModelResult;
import org.gradle.tooling.internal.consumer.connection.HasCompatibilityMapping;
import org.gradle.tooling.internal.consumer.connection.ToolingParameterProxy;
import org.gradle.tooling.internal.consumer.versioning.ModelMapping;
import org.gradle.tooling.internal.consumer.versioning.VersionDetails;
import org.gradle.tooling.internal.gradle.DefaultProjectIdentifier;
import org.gradle.tooling.internal.protocol.BuildResult;
import org.gradle.tooling.internal.protocol.InternalUnsupportedModelException;
import org.gradle.tooling.internal.protocol.ModelIdentifier;
import org.gradle.tooling.model.Model;
import org.gradle.tooling.model.ProjectModel;
import org.gradle.tooling.model.gradle.GradleBuild;
import org.gradle.tooling.model.internal.Exceptions;

abstract class UnparameterizedBuildController
extends HasCompatibilityMapping
implements BuildController {
    private final ProtocolToModelAdapter adapter;
    private final ObjectGraphAdapter resultAdapter;
    private final ModelMapping modelMapping;
    protected final VersionDetails gradleVersion;
    private final File rootDir;

    public UnparameterizedBuildController(ProtocolToModelAdapter adapter, ModelMapping modelMapping, VersionDetails gradleVersion, File rootDir) {
        this.adapter = adapter;
        this.resultAdapter = adapter.newGraph();
        this.modelMapping = modelMapping;
        this.gradleVersion = gradleVersion;
        this.rootDir = rootDir;
    }

    @Override
    public <T> T getModel(Class<T> modelType) throws UnknownModelException {
        return this.getModel(null, modelType);
    }

    @Override
    public <T> T findModel(Class<T> modelType) {
        return this.findModel(null, modelType);
    }

    @Override
    public GradleBuild getBuildModel() {
        return this.getModel(null, GradleBuild.class);
    }

    @Override
    public <T> T getModel(Model target, Class<T> modelType) throws UnknownModelException {
        return this.getModel(target, modelType, null, null);
    }

    @Override
    public <T> T findModel(Model target, Class<T> modelType) {
        return this.findModel(target, modelType, null, null);
    }

    @Override
    public <T, P> T getModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws UnsupportedVersionException {
        return this.getModel(null, modelType, parameterType, parameterInitializer);
    }

    @Override
    public <T, P> T findModel(Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
        return this.findModel(null, modelType, parameterType, parameterInitializer);
    }

    @Override
    public <T, P> T findModel(Model target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) {
        try {
            return this.getModel(target, modelType, parameterType, parameterInitializer);
        }
        catch (UnknownModelException e) {
            return null;
        }
    }

    @Override
    public <T, P> T getModel(Model target, Class<T> modelType, Class<P> parameterType, Action<? super P> parameterInitializer) throws UnsupportedVersionException, UnknownModelException {
        BuildResult<?> result;
        Object originalTarget = this.unpackModelTarget(target);
        ModelIdentifier modelIdentifier = this.getModelIdentifierFromModelType(modelType);
        P parameter = UnparameterizedBuildController.initializeParameter(parameterType, parameterInitializer);
        try {
            result = this.getModel(originalTarget, modelIdentifier, parameter);
        }
        catch (InternalUnsupportedModelException e) {
            throw Exceptions.unknownModel(modelType, e);
        }
        return this.adaptModel(target, modelType, result.getModel());
    }

    protected <T> T adaptModel(@Nullable Model target, Class<T> modelType, Object model) {
        ViewBuilder<T> viewBuilder = this.resultAdapter.builder(modelType);
        this.applyCompatibilityMapping(viewBuilder, new DefaultProjectIdentifier(this.rootDir, UnparameterizedBuildController.getProjectPath(target)));
        return viewBuilder.build(model);
    }

    protected <T> ModelIdentifier getModelIdentifierFromModelType(Class<T> modelType) {
        return this.modelMapping.getModelIdentifierFromModelType(modelType);
    }

    protected @Nullable Object unpackModelTarget(@Nullable Model target) {
        return target == null ? null : this.adapter.unpack(target);
    }

    protected static <P> P initializeParameter(@Nullable Class<P> parameterType, Action<? super P> parameterInitializer) {
        UnparameterizedBuildController.validateParameters(parameterType, parameterInitializer);
        if (parameterType != null) {
            P parameter = parameterType.cast(Proxy.newProxyInstance(parameterType.getClassLoader(), new Class[]{parameterType}, (InvocationHandler)new ToolingParameterProxy()));
            parameterInitializer.execute(parameter);
            return parameter;
        }
        return null;
    }

    private static <P> void validateParameters(@Nullable Class<P> parameterType, @Nullable Action<? super P> parameterInitializer) {
        if (parameterType == null && parameterInitializer != null || parameterType != null && parameterInitializer == null) {
            throw new NullPointerException("parameterType and parameterInitializer both need to be set for a parameterized model request.");
        }
        if (parameterType != null) {
            ToolingParameterProxy.validateParameter(parameterType);
        }
    }

    private static String getProjectPath(@Nullable Model target) {
        if (target instanceof ProjectModel) {
            return ((ProjectModel)((Object)target)).getProjectIdentifier().getProjectPath();
        }
        return ":";
    }

    protected abstract BuildResult<?> getModel(@Nullable Object var1, ModelIdentifier var2, @Nullable Object var3) throws InternalUnsupportedModelException;

    @Override
    public boolean getCanQueryProjectModelInParallel(Class<?> modelType) {
        return false;
    }

    @Override
    public <T> List<T> run(Collection<? extends BuildAction<? extends T>> actions) {
        ArrayList<T> results = new ArrayList<T>(actions.size());
        ArrayList<Throwable> failures = new ArrayList<Throwable>();
        for (BuildAction<T> action : actions) {
            try {
                T result = action.execute(this);
                results.add(result);
            }
            catch (Throwable t) {
                failures.add(t);
            }
        }
        if (!failures.isEmpty()) {
            throw new MultipleBuildOperationFailures(failures, null);
        }
        return results;
    }

    @Override
    public void send(Object value) {
        throw new UnsupportedVersionException(String.format("Gradle version %s does not support streaming values to the client.", this.gradleVersion.getVersion()));
    }

    @Override
    public <M> FetchModelResult<M> fetch(Class<M> modelType) {
        return this.fetch(null, modelType, null, null);
    }

    @Override
    public <M> FetchModelResult<M> fetch(Model target, Class<M> modelType) {
        return this.fetch(target, modelType, null, null);
    }

    @Override
    public <M, P> FetchModelResult<M> fetch(Class<M> modelType, @Nullable Class<P> parameterType, @Nullable Action<? super P> parameterInitializer) {
        return this.fetch(null, modelType, parameterType, parameterInitializer);
    }

    @Override
    public <M, P> FetchModelResult<M> fetch(@Nullable Model target, Class<M> modelType, @Nullable Class<P> parameterType, @Nullable Action<? super P> parameterInitializer) {
        try {
            M model = this.getModel(target, modelType, parameterType, parameterInitializer);
            return DefaultFetchModelResult.success(Cast.uncheckedNonnullCast(model));
        }
        catch (Exception e) {
            return DefaultFetchModelResult.failure(e);
        }
    }
}

