/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.tooling.internal.consumer.loader;

import java.io.Closeable;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import org.gradle.initialization.BuildCancellationToken;
import org.gradle.internal.classpath.ClassPath;
import org.gradle.internal.concurrent.CompositeStoppable;
import org.gradle.internal.impldep.com.google.common.cache.Cache;
import org.gradle.internal.impldep.com.google.common.cache.CacheBuilder;
import org.gradle.internal.impldep.org.jspecify.annotations.NullMarked;
import org.gradle.internal.logging.progress.ProgressLoggerFactory;
import org.gradle.tooling.GradleConnectionException;
import org.gradle.tooling.internal.consumer.ConnectionParameters;
import org.gradle.tooling.internal.consumer.Distribution;
import org.gradle.tooling.internal.consumer.connection.ConsumerConnection;
import org.gradle.tooling.internal.consumer.loader.ToolingImplementationLoader;
import org.gradle.tooling.internal.protocol.InternalBuildProgressListener;

public class CachingToolingImplementationLoader
implements ToolingImplementationLoader,
Closeable {
    private final ToolingImplementationLoader loader;
    private final Cache<ClassPath, ConsumerConnection> connections = CacheBuilder.newBuilder().maximumSize(15L).build();

    public CachingToolingImplementationLoader(ToolingImplementationLoader loader) {
        this.loader = loader;
    }

    @Override
    public ConsumerConnection create(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
        ClassPath classpath = distribution.getToolingImplementationClasspath(progressLoggerFactory, progressListener, connectionParameters, cancellationToken);
        try {
            return this.connections.get(classpath, new ConsumerConnectionCreator(distribution, progressLoggerFactory, progressListener, connectionParameters, cancellationToken));
        }
        catch (ExecutionException e) {
            throw new GradleConnectionException(String.format("Could not create an instance of Tooling API implementation using the specified %s.", distribution.getDisplayName()), e);
        }
    }

    @Override
    public void close() {
        try {
            CompositeStoppable.stoppable(this.connections.asMap().values()).stop();
        }
        finally {
            this.connections.invalidateAll();
        }
    }

    @NullMarked
    private class ConsumerConnectionCreator
    implements Callable<ConsumerConnection> {
        private final Distribution distribution;
        private final ProgressLoggerFactory progressLoggerFactory;
        private final InternalBuildProgressListener progressListener;
        private final ConnectionParameters connectionParameters;
        private final BuildCancellationToken cancellationToken;

        public ConsumerConnectionCreator(Distribution distribution, ProgressLoggerFactory progressLoggerFactory, InternalBuildProgressListener progressListener, ConnectionParameters connectionParameters, BuildCancellationToken cancellationToken) {
            this.distribution = distribution;
            this.progressLoggerFactory = progressLoggerFactory;
            this.progressListener = progressListener;
            this.connectionParameters = connectionParameters;
            this.cancellationToken = cancellationToken;
        }

        @Override
        public ConsumerConnection call() throws Exception {
            return CachingToolingImplementationLoader.this.loader.create(this.distribution, this.progressLoggerFactory, this.progressListener, this.connectionParameters, this.cancellationToken);
        }
    }
}

