/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathElement;
import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.maven.dependency.ResolvedDependency;
import io.quarkus.paths.ManifestAttributes;
import io.quarkus.paths.OpenPathTree;
import java.io.IOException;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.function.Function;

public class FilteredClassPathElement
implements ClassPathElement {
    private final ClassPathElement delegate;
    private final Set<String> removed;
    private final Set<String> resources;

    public FilteredClassPathElement(ClassPathElement delegate, Collection<String> removed) {
        this.delegate = delegate;
        this.removed = new HashSet<String>(removed);
        this.resources = new HashSet<String>(delegate.getProvidedResources());
        this.resources.removeAll(this.removed);
    }

    @Override
    public ResolvedDependency getResolvedDependency() {
        return this.delegate.getResolvedDependency();
    }

    @Override
    public boolean isRuntime() {
        return this.delegate.isRuntime();
    }

    @Override
    public <T> T apply(Function<OpenPathTree, T> func) {
        return this.delegate.apply(func);
    }

    @Override
    public Path getRoot() {
        return this.delegate.getRoot();
    }

    @Override
    public ClassPathResource getResource(String name) {
        if (this.removed.contains(name)) {
            return null;
        }
        return this.delegate.getResource(name);
    }

    @Override
    public Set<String> getProvidedResources() {
        return this.resources;
    }

    @Override
    public boolean containsReloadableResources() {
        return this.delegate.containsReloadableResources();
    }

    @Override
    public ProtectionDomain getProtectionDomain() {
        return this.delegate.getProtectionDomain();
    }

    @Override
    public ManifestAttributes getManifestAttributes() {
        return this.delegate.getManifestAttributes();
    }

    @Override
    public void close() throws IOException {
        this.delegate.close();
    }
}

