/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.classloading;

import io.quarkus.bootstrap.classloading.ClassPathResource;
import io.quarkus.bootstrap.classloading.DirectoryClassPathElement;
import io.quarkus.bootstrap.classloading.JarClassPathElement;
import java.io.Closeable;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.security.ProtectionDomain;
import java.util.Collections;
import java.util.Set;
import java.util.jar.Manifest;

public interface ClassPathElement
extends Closeable {
    public static final ClassPathElement EMPTY = new ClassPathElement(){

        @Override
        public Path getRoot() {
            return null;
        }

        @Override
        public ClassPathResource getResource(String name) {
            return null;
        }

        @Override
        public Set<String> getProvidedResources() {
            return Collections.emptySet();
        }

        @Override
        public ProtectionDomain getProtectionDomain(ClassLoader classLoader) {
            return null;
        }

        @Override
        public Manifest getManifest() {
            return null;
        }

        @Override
        public void close() throws IOException {
        }
    };

    public Path getRoot();

    public ClassPathResource getResource(String var1);

    public Set<String> getProvidedResources();

    public ProtectionDomain getProtectionDomain(ClassLoader var1);

    public Manifest getManifest();

    public static ClassPathElement fromPath(Path path) {
        return Files.isDirectory(path, new LinkOption[0]) ? new DirectoryClassPathElement(path) : new JarClassPathElement(path);
    }
}

