/*
 * Decompiled with CFR 0.152.
 */
package io.quarkus.bootstrap.workspace;

import io.quarkus.bootstrap.model.MappableCollectionFactory;
import io.quarkus.bootstrap.workspace.SourceDir;
import io.quarkus.paths.DirectoryPathTree;
import io.quarkus.paths.PathFilter;
import io.quarkus.paths.PathTree;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.nio.file.Path;
import java.util.Collections;
import java.util.Map;
import java.util.Objects;

public class LazySourceDir
implements SourceDir,
Serializable {
    private Path srcDir;
    private PathFilter srcFilter;
    private Path destDir;
    private PathFilter destFilter;
    private Path genSrcDir;
    private Map<Object, Object> data;

    static SourceDir fromMap(Map<String, Object> map) {
        Path srcDir = Path.of(map.get("dir").toString(), new String[0]);
        Map pathFilter = (Map)map.get("src-path-filter");
        PathFilter srcFilter = pathFilter == null ? null : PathFilter.fromMap(pathFilter);
        Path destDir = Path.of(map.get("dest-dir").toString(), new String[0]);
        pathFilter = (Map)map.get("dest-path-filter");
        PathFilter destFilter = pathFilter == null ? null : PathFilter.fromMap(pathFilter);
        Object o = map.get("apt-sources-dir");
        Path genSrcDir = o == null ? null : Path.of(o.toString(), new String[0]);
        return new LazySourceDir(srcDir, srcFilter, destDir, destFilter, genSrcDir, Collections.emptyMap());
    }

    public LazySourceDir() {
    }

    public LazySourceDir(Path srcDir, Path destinationDir) {
        this(srcDir, destinationDir, null, Collections.emptyMap());
    }

    public LazySourceDir(Path srcDir, Path destinationDir, Path generatedSourcesDir) {
        this(srcDir, destinationDir, generatedSourcesDir, Collections.emptyMap());
    }

    public LazySourceDir(Path srcDir, Path destinationDir, Path generatedSourcesDir, Map<Object, Object> data) {
        this(srcDir, null, destinationDir, null, generatedSourcesDir, data);
    }

    public LazySourceDir(Path srcDir, PathFilter srcFilter, Path destDir, PathFilter destFilter, Path genSrcDir, Map<Object, Object> data) {
        this.srcDir = Objects.requireNonNull(srcDir, "srcDir is null");
        this.srcFilter = srcFilter;
        this.destDir = Objects.requireNonNull(destDir, "destDir is null");
        this.destFilter = destFilter;
        this.genSrcDir = genSrcDir;
        this.data = data;
    }

    @Override
    public Path getDir() {
        return this.srcDir;
    }

    @Override
    public PathTree getSourceTree() {
        return new DirectoryPathTree(this.srcDir, this.srcFilter);
    }

    @Override
    public Path getOutputDir() {
        return this.destDir;
    }

    @Override
    public Path getAptSourcesDir() {
        return this.genSrcDir;
    }

    @Override
    public PathTree getOutputTree() {
        return new DirectoryPathTree(this.destDir, this.destFilter);
    }

    @Override
    public <T> T getValue(Object key, Class<T> type) {
        Object o = this.data.get(key);
        return o == null ? null : (T)type.cast(o);
    }

    @Override
    public Map<String, Object> asMap(MappableCollectionFactory factory) {
        Map<String, Object> map = factory.newMap(5);
        map.put("dir", this.srcDir.toString());
        if (this.srcFilter != null) {
            map.put("src-path-filter", this.srcFilter.asMap(factory));
        }
        map.put("dest-dir", this.destDir.toString());
        if (this.destFilter != null) {
            map.put("dest-path-filter", this.destFilter.asMap(factory));
        }
        if (this.genSrcDir != null) {
            map.put("apt-sources-dir", this.genSrcDir.toString());
        }
        return map;
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.writeUTF(this.srcDir.toAbsolutePath().toString());
        out.writeObject(this.srcFilter);
        out.writeUTF(this.destDir.toAbsolutePath().toString());
        out.writeObject(this.destFilter);
        out.writeUTF(this.genSrcDir == null ? "null" : this.genSrcDir.toAbsolutePath().toString());
        out.writeObject(this.data);
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        this.srcDir = Path.of(in.readUTF(), new String[0]);
        this.srcFilter = (PathFilter)in.readObject();
        this.destDir = Path.of(in.readUTF(), new String[0]);
        this.destFilter = (PathFilter)in.readObject();
        String genSrcStr = in.readUTF();
        if (!"null".equals(genSrcStr)) {
            this.genSrcDir = Path.of(genSrcStr, new String[0]);
        }
        this.data = (Map)in.readObject();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("dir=").append(this.srcDir);
        if (this.srcFilter != null) {
            sb.append(" src-filter=").append(this.srcFilter);
        }
        sb.append(", dest=").append(this.destDir);
        if (this.destFilter != null) {
            sb.append(" dest-filter=").append(this.destFilter);
        }
        if (this.genSrcDir != null) {
            sb.append("  gen-src-dir=").append(this.genSrcDir);
        }
        return sb.toString();
    }
}

